/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetManagerListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import ro.amiq.dvt.debug.ui.breakpoints.ToggleLineBreakpointAdapter;
import ro.amiq.dvt.debug.ui.breakpoints.TracepointsUtils;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ToggleTracepointAction
extends Action
implements IUpdate {
    private IWorkbenchPart fPart;
    private IDocument fDocument;
    private IVerticalRulerInfo fRulerInfo;
    private IToggleBreakpointsTargetManagerListener fListener = () -> this.update();

    public ToggleTracepointAction(IWorkbenchPart part, IDocument document, IVerticalRulerInfo rulerInfo) {
        super("Toggle Tracepoint");
        this.fPart = part;
        this.fDocument = document;
        this.fRulerInfo = rulerInfo;
        DebugUITools.getToggleBreakpointsTargetManager().addChangedListener(this.fListener);
    }

    public void run() {
        this.doIt();
    }

    public void runWithEvent(Event event) {
        this.doIt();
    }

    void doIt() {
        int line;
        IDocument document = this.getDocument();
        if (document != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
            try {
                IToggleBreakpointsTargetExtension ext2;
                ITextSelection selection = TracepointsUtils.getTextSelection(document, line, this.fPart);
                IToggleBreakpointsTarget target = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget(this.fPart, (ISelection)selection);
                if (target != null && (ext2 = (IToggleBreakpointsTargetExtension)DebugPlugin.getAdapter((Object)target, IToggleBreakpointsTargetExtension.class)) instanceof ToggleLineBreakpointAdapter && ext2.canToggleBreakpoints(this.fPart, (ISelection)selection)) {
                    TracepointsUtils.setUnsetTracepoints(true);
                    ((ToggleLineBreakpointAdapter)ext2).toggleBreakpoints(this.fPart, (ISelection)selection);
                    return;
                }
            }
            catch (CoreException | BadLocationException e) {
                DVTLogger.INSTANCE.logError(e);
            }
        }
    }

    public void dispose() {
        this.fDocument = null;
        this.fPart = null;
        this.fRulerInfo = null;
        DebugUITools.getToggleBreakpointsTargetManager().removeChangedListener(this.fListener);
    }

    private IDocument getDocument() {
        ITextEditor editor;
        IDocumentProvider provider;
        if (this.fDocument != null) {
            return this.fDocument;
        }
        if (this.fPart instanceof ITextEditor && (provider = (editor = (ITextEditor)this.fPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        IDocument doc = (IDocument)this.fPart.getAdapter(IDocument.class);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    public void update() {
        int line;
        IDocument document = this.getDocument();
        if (document != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
            try {
                IToggleBreakpointsTargetExtension extension;
                ITextSelection selection = TracepointsUtils.getTextSelection(document, line, this.fPart);
                IToggleBreakpointsTarget target = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget(this.fPart, (ISelection)selection);
                if (target == null) {
                    this.setEnabled(false);
                    return;
                }
                if (target instanceof IToggleBreakpointsTargetExtension && (extension = (IToggleBreakpointsTargetExtension)target).canToggleBreakpoints(this.fPart, (ISelection)selection)) {
                    this.setEnabled(true);
                    return;
                }
                if (target.canToggleLineBreakpoints(this.fPart, (ISelection)selection) || target.canToggleWatchpoints(this.fPart, (ISelection)selection) || target.canToggleMethodBreakpoints(this.fPart, (ISelection)selection)) {
                    this.setEnabled(true);
                    return;
                }
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        this.setEnabled(false);
    }
}

