/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.ui.breakpoints.DVTAbstractBreakpointEditor;
import ro.amiq.dvt.debug.ui.breakpoints.DVTBreakpointMessages;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.utils.DVTStringUtil;

public class VlogBreakpointConditionEditor
extends DVTAbstractBreakpointEditor {
    private Button conditionButton;
    private Button suspendWhenTrueButton;
    private Button suspendWhenValueChangesButton;
    private AbstractHandler undoHandler;
    private AbstractHandler redoHandler;
    private IHandlerService handlerService;
    private IHandlerActivation undoActivation;
    private IHandlerActivation redoActivation;
    private SourceViewer viewer;
    private AbstractHandler contentAssistHandler;
    private IHandlerActivation contentAssistActivation;
    private IViewSite breakpointsViewSite;
    private UndoActionHandler viewerUndoAction;
    private RedoActionHandler viewerRedoAction;
    private IDocumentListener documentListener;
    private BreakpointConditionContentAssistListener contentAssistAutoActivationListener;
    private Combo conditionHistory;
    private HashMap<BaseBreakpoint, Stack<String>> localConditionHistory;
    public static final int PROP_CONDITION = 4097;
    public static final int PROP_CONDITION_ENABLED = 4098;
    protected static final int PROP_CONDITION_SUSPEND_POLICY = 4102;
    private static final int MAX_HISTORY_SIZE = 10;
    private static final Pattern NEWLINE_PATTERN = Pattern.compile(DVTStringUtil.LINE_SEPARATOR);

    @Override
    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.conditionButton = new Button(composite, 32);
        this.conditionButton.setText(DVTBreakpointMessages.conditionButtonText);
        GridData conditionData = new GridData();
        conditionData.horizontalSpan = 1;
        this.conditionButton.setLayoutData((Object)conditionData);
        this.conditionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean enabled = VlogBreakpointConditionEditor.this.conditionButton.getSelection();
                VlogBreakpointConditionEditor.this.setEnabled(enabled);
                VlogBreakpointConditionEditor.this.setDirty(4098);
            }
        });
        this.suspendWhenTrueButton = new Button(composite, 16);
        this.suspendWhenTrueButton.setText(DVTBreakpointMessages.suspendWhenTrueButtonText);
        this.suspendWhenValueChangesButton = new Button(composite, 16);
        this.suspendWhenValueChangesButton.setText(DVTBreakpointMessages.suspendWhenValueChangesButtonText);
        this.suspendWhenTrueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VlogBreakpointConditionEditor.this.setDirty(4102);
            }
        });
        this.suspendWhenValueChangesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VlogBreakpointConditionEditor.this.setDirty(4102);
            }
        });
        this.localConditionHistory = new HashMap();
        this.conditionHistory = new Combo(parent, 12);
        this.initializeConditionHistoryDropDown();
        this.conditionHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int historyIndex = VlogBreakpointConditionEditor.this.conditionHistory.getSelectionIndex() - 1;
                if (historyIndex >= 0) {
                    VlogBreakpointConditionEditor.this.viewer.getDocument().set(VlogBreakpointConditionEditor.this.getConditionHistory()[historyIndex]);
                }
            }
        });
        GridData data = new GridData(768);
        data.widthHint = 10;
        this.conditionHistory.setLayoutData((Object)data);
        this.localConditionHistory = new HashMap(10);
        this.viewer = new SourceViewer(parent, null, null, false, 0x2000B00);
        this.viewer.setDocument((IDocument)new Document());
        GC gc = null;
        try {
            gc = new GC((Drawable)this.viewer.getTextWidget());
            gc.setFont(this.viewer.getTextWidget().getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)17);
            gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)40);
            this.viewer.getControl().setLayoutData((Object)gd);
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        this.contentAssistHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                VlogBreakpointConditionEditor.this.viewer.doOperation(13);
                return null;
            }
        };
        this.undoHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                VlogBreakpointConditionEditor.this.viewer.doOperation(1);
                return null;
            }
        };
        this.redoHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                VlogBreakpointConditionEditor.this.viewer.doOperation(2);
                return null;
            }
        };
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        this.viewer.getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                VlogBreakpointConditionEditor.this.activateHandlers();
            }

            public void focusLost(FocusEvent e) {
                VlogBreakpointConditionEditor.this.deactivateHandlers();
            }
        });
        parent.addDisposeListener(e -> this.dispose());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    @Override
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void doSave() throws CoreException {
        if (this.breakpoint instanceof LineBreakpoint && this.isDirty()) {
            String condition = this.viewer.getDocument().get().trim();
            IMarker marker = this.breakpoint.getMarker();
            if (marker != null) {
                ((LineBreakpoint)this.breakpoint).setCondition(condition);
                ((LineBreakpoint)this.breakpoint).setConditionEnabled(this.conditionButton.getSelection());
            }
            this.breakpoint.setConditionSuspendOnTrue(this.suspendWhenTrueButton.getSelection());
            if (this.hasConditionHistory()) {
                this.updateConditionHistory();
            }
        }
    }

    @Override
    public IStatus getStatus() {
        return Status.OK_STATUS;
    }

    @Override
    public Object getInput() {
        return null;
    }

    @Override
    public void setInput(Object breakpoint) throws CoreException {
        if (breakpoint instanceof BaseBreakpoint) {
            this.setBreakpoint((BaseBreakpoint)((Object)breakpoint));
        } else {
            this.setBreakpoint(null);
        }
    }

    private void setBreakpoint(BaseBreakpoint newBreakpoint) {
        this.breakpoint = newBreakpoint;
        if (this.documentListener != null) {
            this.viewer.getDocument().removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
        if (this.contentAssistAutoActivationListener != null) {
            this.viewer.getDocument().removeDocumentListener((IDocumentListener)this.contentAssistAutoActivationListener);
            this.contentAssistAutoActivationListener = null;
        }
        this.viewer.unconfigure();
        if (this.breakpoint == null) {
            this.conditionButton.setEnabled(false);
            this.conditionButton.setSelection(false);
            this.suspendWhenTrueButton.setSelection(true);
            this.suspendWhenValueChangesButton.setSelection(false);
            this.conditionHistory.select(0);
            this.viewer.getDocument().set("");
            this.setEnabled(false);
            this.setDirty(false);
            return;
        }
        this.conditionButton.setEnabled(true);
        this.suspendWhenTrueButton.setEnabled(true);
        this.suspendWhenValueChangesButton.setEnabled(true);
        this.conditionHistory.setEnabled(true);
        RfMixedLangManager instance = RfMixedLangManager.getInstance();
        IResource resource = ((LineBreakpoint)newBreakpoint).getMarker().getResource();
        IProject project = null;
        if (resource != null) {
            project = resource.getProject();
        }
        Document document = new Document();
        instance.installPartitionerForDocument(LanguageKind.VLOG, project, (IDocument)document);
        this.viewer.setDocument((IDocument)document);
        if (project != null) {
            DVTSourceViewerConfiguration config = instance.getDebugSourceViewerConfigurationForLang(LanguageKind.VLOG, project, (LineBreakpoint)newBreakpoint, this.viewer);
            this.viewer.configure((SourceViewerConfiguration)config);
        }
        try {
            boolean suspendWhenTrue = this.breakpoint.isConditionSuspendOnTrue();
            String condition = this.breakpoint.getCondition();
            this.conditionButton.setSelection(this.breakpoint instanceof LineBreakpoint && ((LineBreakpoint)this.breakpoint).isConditionEnabled());
            this.suspendWhenTrueButton.setSelection(suspendWhenTrue);
            this.suspendWhenTrueButton.setEnabled(this.conditionButton.getSelection());
            this.suspendWhenValueChangesButton.setSelection(!suspendWhenTrue);
            this.suspendWhenValueChangesButton.setEnabled(this.conditionButton.getSelection());
            this.viewer.setEditable(this.conditionButton.getSelection());
            this.viewer.getTextWidget().setEnabled(this.conditionButton.getSelection());
            document.set(condition != null ? condition : "");
            this.documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    VlogBreakpointConditionEditor.this.setDirty(4097);
                }
            };
            document.addDocumentListener(this.documentListener);
            this.contentAssistAutoActivationListener = new BreakpointConditionContentAssistListener();
            document.addDocumentListener((IDocumentListener)this.contentAssistAutoActivationListener);
            this.conditionHistory.setEnabled(this.conditionButton.getSelection());
            if (this.hasConditionHistory()) {
                this.initializeConditionHistoryDropDown();
            }
            this.setDirty(false);
            this.checkIfUsedInBreakpointsView();
            this.registerViewerUndoRedoActions();
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void dispose() {
        this.deactivateHandlers();
        super.dispose();
    }

    private void setEnabled(boolean enabled) {
        this.viewer.setEditable(enabled);
        this.viewer.getTextWidget().setEnabled(enabled);
        if (enabled) {
            this.setFocus();
        }
        this.suspendWhenTrueButton.setEnabled(enabled);
        this.suspendWhenValueChangesButton.setEnabled(enabled);
        if (this.hasConditionHistory()) {
            this.conditionHistory.setEnabled(enabled);
        }
    }

    private boolean hasConditionHistory() {
        return this.conditionHistory != null;
    }

    private void initializeConditionHistoryDropDown() {
        this.conditionHistory.removeAll();
        String userHint = DVTBreakpointMessages.conditionHistoryUserHint;
        this.conditionHistory.add(userHint);
        this.conditionHistory.setText(userHint);
        String[] conditions = this.getConditionHistory();
        int i = 0;
        while (i < conditions.length) {
            this.conditionHistory.add(NEWLINE_PATTERN.matcher(conditions[i]).replaceAll(" "));
            ++i;
        }
    }

    private String[] getConditionHistory() {
        Stack<String> localHistory = this.localConditionHistory.get((Object)this.breakpoint);
        if (localHistory == null) {
            return new String[0];
        }
        int localHistorySize = Math.min(localHistory.size(), 10);
        String[] historyItems = new String[localHistorySize];
        int i = 0;
        while (i < localHistorySize) {
            historyItems[i] = (String)localHistory.get(localHistory.size() - i - 1);
            ++i;
        }
        return historyItems;
    }

    private void updateConditionHistory() {
        String newItem = this.viewer.getDocument().get();
        if (newItem.length() == 0) {
            return;
        }
        Stack<String> localHistory = this.localConditionHistory.get((Object)this.breakpoint);
        if (localHistory == null) {
            localHistory = new Stack();
            this.localConditionHistory.put(this.breakpoint, localHistory);
        }
        localHistory.remove(newItem);
        localHistory.push(newItem);
    }

    private void disposeViewerUndoRedoActions() {
        if (this.viewerUndoAction != null) {
            this.viewerUndoAction.dispose();
            this.viewerUndoAction = null;
        }
        if (this.viewerRedoAction != null) {
            this.viewerRedoAction.dispose();
            this.viewerRedoAction = null;
        }
    }

    private void deactivateHandlers() {
        if (this.contentAssistActivation != null) {
            this.handlerService.deactivateHandler(this.contentAssistActivation);
            this.contentAssistActivation = null;
        }
        if (this.undoActivation != null) {
            this.handlerService.deactivateHandler(this.undoActivation);
            this.undoActivation = null;
        }
        if (this.redoActivation != null) {
            this.handlerService.deactivateHandler(this.redoActivation);
            this.redoActivation = null;
        }
    }

    private void activateHandlers() {
        this.contentAssistActivation = this.handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", (IHandler)this.contentAssistHandler);
        this.checkIfUsedInBreakpointsView();
        if (this.breakpointsViewSite == null) {
            this.undoActivation = this.handlerService.activateHandler("org.eclipse.ui.edit.undo", (IHandler)this.undoHandler);
            this.redoActivation = this.handlerService.activateHandler("org.eclipse.ui.edit.redo", (IHandler)this.redoHandler);
        } else {
            this.registerViewerUndoRedoActions();
        }
    }

    private void checkIfUsedInBreakpointsView() {
        IWorkbenchPartSite site;
        if (this.breakpointsViewSite != null) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && activeWorkbenchWindow.getActivePage() != null && activeWorkbenchWindow.getActivePage().getActivePart() != null && "org.eclipse.debug.ui.BreakpointView".equals((site = activeWorkbenchWindow.getActivePage().getActivePart().getSite()).getId())) {
            this.breakpointsViewSite = (IViewSite)site;
        }
    }

    private void registerViewerUndoRedoActions() {
        if (!this.viewer.getTextWidget().isFocusControl()) {
            return;
        }
        this.disposeViewerUndoRedoActions();
        IUndoContext undoContext = this.getUndoContext();
        if (undoContext != null) {
            this.viewerUndoAction = new UndoActionHandler((IWorkbenchPartSite)this.breakpointsViewSite, undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.viewerUndoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
            this.viewerUndoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
            this.viewerRedoAction = new RedoActionHandler((IWorkbenchPartSite)this.breakpointsViewSite, undoContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.viewerRedoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
            this.viewerRedoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        }
        IActionBars actionBars = this.breakpointsViewSite.getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, (IAction)this.viewerUndoAction);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, (IAction)this.viewerRedoAction);
        actionBars.updateActionBars();
    }

    private IUndoContext getUndoContext() {
        IUndoManager undoManager = this.viewer.getUndoManager();
        if (undoManager instanceof IUndoManagerExtension) {
            return ((IUndoManagerExtension)undoManager).getUndoContext();
        }
        return null;
    }

    class BreakpointConditionContentAssistListener
    implements IDocumentListener {
        private List<String> contentAssistCandidates;
        private BreakpointConditionContentAssistTriggerJob fTrigger = new BreakpointConditionContentAssistTriggerJob();

        public BreakpointConditionContentAssistListener() {
            this.initialize();
        }

        public void initialize() {
            String rawPref = Platform.getPreferencesService().getString("ro.amiq.vlogdt", "ca.chars_trigger", "", null);
            this.contentAssistCandidates = new ArrayList<String>();
            for (String piece : Arrays.asList(rawPref.split(","))) {
                if (piece.isEmpty()) continue;
                this.contentAssistCandidates.add(piece);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (event.fLength != 0 || event.fText.length() != 1) {
                return;
            }
            char currChar = event.fText.charAt(0);
            for (String candidate : this.contentAssistCandidates) {
                if (currChar != candidate.charAt(candidate.length() - 1)) continue;
                try {
                    int offset = event.fOffset;
                    offset = Math.max(event.fOffset - candidate.length() + 1, 0);
                    String text = event.fDocument.get(offset, candidate.length());
                    if (!text.endsWith(candidate)) continue;
                    this.doContentAssist();
                    return;
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }

        private void doContentAssist() {
            this.fTrigger.schedule(DVTPlugin.getDefault().getPreferenceStore().getInt("ca.delay_trigger"));
        }

        class BreakpointConditionContentAssistTriggerJob
        extends UIJob {
            public BreakpointConditionContentAssistTriggerJob() {
                super("Breakpoint Condition Content Assist");
            }

            public boolean shouldSchedule() {
                return !DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_auto_complete");
            }

            public boolean shouldRun() {
                return !DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_auto_complete");
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ((BreakpointConditionContentAssistListener)BreakpointConditionContentAssistListener.this).VlogBreakpointConditionEditor.this.viewer.doOperation(13);
                return Status.OK_STATUS;
            }
        }
    }
}

