/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.ui.breakpoints.DVTAbstractBreakpointEditor;
import ro.amiq.dvt.debug.ui.breakpoints.DVTBreakpointMessages;
import ro.amiq.dvt.startup.core.DVTLogger;

public class VlogBreakpointEditor
extends DVTAbstractBreakpointEditor {
    private Button triggerPointButton;
    private Button hitCountButton;
    private Text hitCountText;
    private boolean triggerPointsDisabled;
    public static final int PROP_HIT_COUNT_ENABLED = 4099;
    public static final int PROP_HIT_COUNT = 4100;
    public static final int PROP_TRIGGER_POINT = 4101;

    @Override
    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            breakpointManager.getClass().getMethod("hasActiveTriggerPoints", null);
            this.triggerPointButton = new Button(composite, 32);
            this.triggerPointButton.setText(DVTBreakpointMessages.triggerButtonText);
            GridData triggerPointData = new GridData();
            triggerPointData.horizontalSpan = 3;
            this.triggerPointButton.setLayoutData((Object)triggerPointData);
            this.triggerPointButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    VlogBreakpointEditor.this.setDirty(4101);
                }
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.triggerPointsDisabled = true;
        }
        this.hitCountButton = new Button(composite, 32);
        this.hitCountButton.setText(DVTBreakpointMessages.hitCountButtonText);
        GridData hitCountData = new GridData();
        hitCountData.horizontalSpan = 1;
        this.hitCountButton.setLayoutData((Object)hitCountData);
        this.hitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean enabled = VlogBreakpointEditor.this.hitCountButton.getSelection();
                VlogBreakpointEditor.this.hitCountText.setEnabled(enabled);
                if (enabled) {
                    VlogBreakpointEditor.this.hitCountText.setFocus();
                }
                VlogBreakpointEditor.this.setDirty(4099);
            }
        });
        this.hitCountText = new Text(composite, 2048);
        this.hitCountText.setLayoutData((Object)new GridData(0, 0, true, false, 2, 1));
        this.hitCountText.addModifyListener(e -> this.setDirty(4100));
        return composite;
    }

    protected void setBreakpoint(BaseBreakpoint newBreakpoint) {
        this.breakpoint = newBreakpoint;
        if (this.breakpoint == null) {
            if (this.triggerPointButton != null) {
                this.triggerPointButton.setEnabled(false);
            }
            this.hitCountButton.setEnabled(false);
            this.hitCountButton.setSelection(false);
            this.hitCountText.setText("");
            this.hitCountText.setEnabled(false);
            this.setDirty(false);
            return;
        }
        if (this.triggerPointButton != null) {
            this.triggerPointButton.setEnabled(true);
        }
        this.hitCountButton.setEnabled(true);
        this.hitCountText.setEnabled(true);
        try {
            if (this.triggerPointButton != null) {
                this.triggerPointButton.setSelection(this.isTriggerPoint());
            }
            int hitCount = this.breakpoint.getHitCount();
            String text = "";
            boolean hasHitCount = false;
            if (hitCount > 0) {
                text = Integer.toString(hitCount);
                hasHitCount = true;
            }
            this.hitCountButton.setSelection(hasHitCount);
            this.hitCountText.setEnabled(hasHitCount);
            this.hitCountText.setText(text);
            this.setDirty(false);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void doSave() throws CoreException {
        if (this.breakpoint instanceof LineBreakpoint) {
            int hitCount = -1;
            if (this.hitCountButton.getSelection()) {
                try {
                    hitCount = Integer.parseInt(this.hitCountText.getText());
                }
                catch (NumberFormatException e) {
                    throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 4, "Hit count must be a positive integer", (Throwable)e));
                }
            }
            this.breakpoint.setHitCount(hitCount);
            if (!this.triggerPointsDisabled) {
                this.storeTriggerPoint(this.breakpoint);
            }
        }
        this.setDirty(false);
    }

    @Override
    public IStatus getStatus() {
        if (this.breakpoint != null && this.hitCountButton.getSelection()) {
            String currentHitCount = this.hitCountText.getText();
            int hitCount = -1;
            try {
                hitCount = Integer.parseInt(currentHitCount);
            }
            catch (NumberFormatException numberFormatException) {
                return new Status(4, "ro.amiq.dvt", 4, "Hit count must be a positive integer", null);
            }
            if (hitCount < 1) {
                return new Status(4, "ro.amiq.dvt", 4, "Hit count must be a positive integer", null);
            }
        }
        return Status.OK_STATUS;
    }

    @Override
    public Object getInput() {
        return this.breakpoint;
    }

    @Override
    public void setInput(Object breakpoint) throws CoreException {
        if (breakpoint instanceof BaseBreakpoint) {
            this.setBreakpoint((BaseBreakpoint)((Object)breakpoint));
        } else {
            this.setBreakpoint(null);
        }
    }

    private boolean isTriggerPoint() {
        try {
            if (this.breakpoint != null) {
                return this.breakpoint.isTriggerPoint();
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    private void storeTriggerPoint(BaseBreakpoint breakpoint) throws CoreException {
        boolean oldSelection = breakpoint.isTriggerPoint();
        if (oldSelection == this.triggerPointButton.getSelection()) {
            return;
        }
        breakpoint.setTriggerPoint(this.triggerPointButton.getSelection());
        try {
            DebugPlugin.getDefault().getBreakpointManager().getClass().getMethod("refreshTriggerpointDisplay", new Class[0]).invoke((Object)DebugPlugin.getDefault().getBreakpointManager(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void setFocus() {
    }
}

