/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.Watchpoint;
import ro.amiq.dvt.debug.ui.breakpoints.CompositeBreakpointEditor;
import ro.amiq.dvt.debug.ui.breakpoints.DVTAbstractBreakpointEditor;
import ro.amiq.dvt.debug.ui.breakpoints.VlogBreakpointConditionEditor;
import ro.amiq.dvt.debug.ui.breakpoints.VlogBreakpointEditor;
import ro.amiq.dvt.debug.ui.breakpoints.WatchpointEditor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class VlogBreakpointPage
extends PropertyPage {
    private BaseBreakpoint breakpoint;
    private DVTAbstractBreakpointEditor breakpointEditor;
    private Button enabledButton;
    private String fPrevMessage;
    private List<String> fErrorMessages = new ArrayList<String>();

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setFont(parent.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        mainComposite.setLayoutData((Object)gd);
        Composite composite = new Composite(mainComposite, 0);
        composite.setLayout((Layout)layout);
        this.enabledButton = new Button(composite, 32);
        this.enabledButton.setText("Enabled");
        this.breakpoint = (LineBreakpoint)this.getElement();
        this.breakpointEditor = this.createTypeSpecificEditor();
        this.breakpointEditor.createControl(mainComposite);
        this.breakpointEditor.addPropertyListener((source, propId) -> {
            IStatus status = this.breakpointEditor.getStatus();
            if (status.isOK()) {
                if (this.fPrevMessage != null) {
                    this.removeErrorMessage(this.fPrevMessage);
                    this.fPrevMessage = null;
                }
            } else {
                this.fPrevMessage = status.getMessage();
                this.addErrorMessage(this.fPrevMessage);
            }
        });
        if (this.breakpoint.getMarker() != null) {
            try {
                boolean enabled = this.breakpoint.isEnabled();
                this.enabledButton.setSelection(enabled);
                this.breakpointEditor.setInput((Object)this.breakpoint);
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        Dialog.applyDialogFont((Control)mainComposite);
        return mainComposite;
    }

    private DVTAbstractBreakpointEditor createTypeSpecificEditor() {
        if (this.breakpoint instanceof Watchpoint) {
            return new CompositeBreakpointEditor(new DVTAbstractBreakpointEditor[]{new WatchpointEditor(), new VlogBreakpointConditionEditor()});
        }
        return new CompositeBreakpointEditor(new DVTAbstractBreakpointEditor[]{new VlogBreakpointEditor(), new VlogBreakpointConditionEditor()});
    }

    public boolean performOk() {
        if (this.breakpoint != null) {
            try {
                this.breakpoint.setEnabled(this.enabledButton.getSelection());
                this.breakpointEditor.doSave();
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return super.performOk();
    }

    protected void addErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    protected void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage(this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }
}

