/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.breakpoints.Watchpoint;
import ro.amiq.dvt.debug.ui.breakpoints.VlogBreakpointEditor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class WatchpointEditor
extends VlogBreakpointEditor {
    public static final int PROP_ACCESS = 4112;
    public static final int PROP_MODIFICATION = 4113;
    private Button accessWatchpointButton;
    private Button modificationWatchpointButton;

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        container.setLayout((Layout)gridLayout);
        container.setFont(parent.getFont());
        super.createControl(container);
        Composite watchComp = new Composite(container, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        watchComp.setLayout((Layout)gridLayout);
        watchComp.setFont(parent.getFont());
        this.accessWatchpointButton = new Button(watchComp, 32);
        this.accessWatchpointButton.setText("Access");
        this.accessWatchpointButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WatchpointEditor.this.setDirty(4112);
            }
        });
        this.modificationWatchpointButton = new Button(watchComp, 32);
        this.modificationWatchpointButton.setText("Modification");
        this.modificationWatchpointButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WatchpointEditor.this.setDirty(4113);
            }
        });
        return container;
    }

    @Override
    protected void setBreakpoint(BaseBreakpoint breakpoint) {
        super.setBreakpoint(breakpoint);
        try {
            if (breakpoint instanceof Watchpoint) {
                Watchpoint watchpoint = (Watchpoint)breakpoint;
                this.accessWatchpointButton.setEnabled(true);
                this.modificationWatchpointButton.setEnabled(true);
                this.accessWatchpointButton.setSelection(watchpoint.isAccess());
                this.modificationWatchpointButton.setSelection(watchpoint.isModification());
            } else {
                this.accessWatchpointButton.setEnabled(false);
                this.modificationWatchpointButton.setEnabled(false);
                this.accessWatchpointButton.setSelection(false);
                this.modificationWatchpointButton.setSelection(false);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void doSave() throws CoreException {
        super.doSave();
        BaseBreakpoint breakpoint = (BaseBreakpoint)((Object)this.getInput());
        if (breakpoint instanceof Watchpoint) {
            Watchpoint watchpoint = (Watchpoint)breakpoint;
            watchpoint.setAccess(this.accessWatchpointButton.getSelection());
            watchpoint.setModification(this.modificationWatchpointButton.getSelection());
        }
    }
}

