/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.breakpoints;

import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;

public enum WatchpointsUtils {
    INSTANCE;


    public ISelection translateToFields(DVTEditor textEditor, ISelection selection, IDocument document) {
        if (textEditor == null || !(selection instanceof ITextSelection)) {
            return selection;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int offset = textSelection.getOffset();
        int end = 0;
        if (document == null) {
            return selection;
        }
        try {
            int line = document.getLineOfOffset(offset);
            IRegion region = document.getLineInformationOfOffset(offset);
            end = region.getOffset() + region.getLength();
            IRfNamedElementAndScope elementAndScope = null;
            while (offset < end) {
                Collection<? extends IRfDefElement> elementDeclarations;
                elementAndScope = RfMixedLangManager.getInstance().getRfElement(textEditor.getCurrentFile(), document, offset);
                while (elementAndScope == null) {
                    if (++offset >= end) break;
                    if (Character.isWhitespace(document.getChar(offset))) continue;
                    elementAndScope = RfMixedLangManager.getInstance().getRfElement(textEditor.getCurrentFile(), document, offset);
                }
                if (elementAndScope == null) {
                    ++offset;
                    continue;
                }
                IRfNamedElement element = elementAndScope.getIRfNamedElement();
                if (element == null) {
                    ++offset;
                    continue;
                }
                if (element instanceof IRfFieldElement && (((IRfFieldElement)element).isField() || ((IRfFieldElement)element).isArgument()) && (elementDeclarations = element.getDeclarations()) != null && !elementDeclarations.isEmpty()) {
                    for (IRfDefElement iRfDefElement : elementDeclarations) {
                        if (!this.isBreakpointOnDeclarationLine(line, textEditor.getParserPath(), iRfDefElement)) continue;
                        return new StructuredSelection((Object)element);
                    }
                }
                offset += element.getName().length() + 1;
                while (Character.isWhitespace(document.getChar(offset)) && offset < end) {
                    ++offset;
                }
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return selection;
    }

    private boolean isBreakpointOnDeclarationLine(int breakpointLine, ParserPath breakpointParserPath, IRfDefElement elementDeclaration) {
        if (elementDeclaration == null) {
            return false;
        }
        if (elementDeclaration.getStartLine() != breakpointLine + 1) {
            return false;
        }
        IRfFileDef defFile = elementDeclaration.getDefFile();
        if (defFile == null) {
            return false;
        }
        ParserPath defParserPath = defFile.getParserPath();
        return defParserPath != null && breakpointParserPath != null && defParserPath.equals(breakpointParserPath);
    }
}

