/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.connection;

import java.net.InetAddress;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.launch.DVTDebugConnectionPortValidator;
import ro.amiq.dvt.launch.ui.DVTSyncBreakpointsPolicyGroup;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class DebugConnectionDialog
extends Dialog {
    private String fTitle;
    private String fHost;
    private String fPort;
    private int fSyncBreakpointsPolicy;
    private String fInitialErrorMessage;
    private DVTDebugConnectionPortValidator fValidator;
    private Text fHostText;
    private Text fPortText;
    private DVTSyncBreakpointsPolicyGroup fSyncBreakpointsPolicyGroupWrapper;
    private Label fError;
    private Button fOkButton;
    private boolean fFirstPass;

    public DebugConnectionDialog(Shell shell, String title, String host, String port, int syncBreakpointsPolicy, String errMessage, IInputValidator validator) {
        super(shell);
        this.fTitle = title;
        this.fHost = host;
        this.fPort = port;
        this.fSyncBreakpointsPolicy = syncBreakpointsPolicy;
        this.fInitialErrorMessage = errMessage;
        this.fValidator = (DVTDebugConnectionPortValidator)validator;
    }

    public String getHost() {
        return this.fHost;
    }

    public String getPort() {
        return this.fPort;
    }

    public int getSyncBreakpointsPolicy() {
        return this.fSyncBreakpointsPolicy;
    }

    protected void buttonPressed(int buttonId) {
        this.fHost = this.fHostText.getText();
        this.fPort = this.fPortText.getText();
        this.fSyncBreakpointsPolicy = this.fSyncBreakpointsPolicyGroupWrapper.getSyncBreakpointsPolicy();
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fOkButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fPortText.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fError = new Label(composite, 0x1000000);
        DVTColorUtil.INSTANCE.setForeground((Control)this.fError, DVTColorUtil.INSTANCE.getColor(255, 1, 1), true);
        this.fError.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fError.setText(this.fInitialErrorMessage);
        this.createConnectionGroup(composite);
        this.fSyncBreakpointsPolicyGroupWrapper = new DVTSyncBreakpointsPolicyGroup(true);
        this.fSyncBreakpointsPolicyGroupWrapper.createGroup(composite, this.fSyncBreakpointsPolicy);
        this.fFirstPass = true;
        DebugConnectionDialog.applyDialogFont((Control)composite);
        return parent;
    }

    private void createConnectionGroup(Composite composite) {
        Group connectionGroup = new Group(composite, 0);
        connectionGroup.setText("Connection: ");
        GridData connectionData = new GridData(4, 0x1000000, true, false, 2, 1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        connectionGroup.setLayout((Layout)layout);
        connectionGroup.setLayoutData((Object)connectionData);
        this.createHostText((Composite)connectionGroup);
        Label portLabel = new Label((Composite)connectionGroup, 64);
        portLabel.setText("Port:");
        this.fPortText = new Text((Composite)connectionGroup, this.getInputTextStyle());
        this.fPortText.setLayoutData((Object)new GridData(768));
        if (this.fPort != null) {
            this.fPortText.setText(this.fPort);
            this.fPortText.selectAll();
        }
        this.fPortText.setTextLimit(7);
        this.fPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugConnectionDialog.this.validateInput();
                DebugConnectionDialog.this.fPort = DebugConnectionDialog.this.fPortText.getText();
            }
        });
        this.fHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugConnectionDialog.this.fHost = DebugConnectionDialog.this.fHostText.getText();
            }
        });
    }

    private void createHostText(Composite connectionGroup) {
        Label hostLabel = new Label(connectionGroup, 0);
        this.fHostText = new Text(connectionGroup, this.getInputTextStyle());
        this.fHostText.setLayoutData((Object)new GridData(768));
        hostLabel.setText("Host:");
        if (this.fHost == null) {
            return;
        }
        if (this.fHost.equals("localhost")) {
            this.fHostText.setText("localhost");
            this.fHostText.selectAll();
            return;
        }
        try {
            String localHost = InetAddress.getLocalHost().getHostName();
            if (this.fHost.equals(localHost)) {
                hostLabel.setText("Host (" + this.fHost + "):");
                this.fHostText.setText("localhost");
                this.fHostText.selectAll();
                return;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        this.fHostText.setText(this.fHost);
        this.fHostText.selectAll();
    }

    private void validateInput() {
        String errorMessage = null;
        if (this.fValidator != null) {
            errorMessage = this.fValidator.isValid(this.fPortText.getText());
        }
        this.setErrorMessage(errorMessage);
    }

    private void setErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            this.fError.setText(errorMessage);
            this.fOkButton.setEnabled(false);
        } else {
            if (!this.fFirstPass) {
                this.fError.setText("");
            }
            this.fOkButton.setEnabled(true);
        }
        this.fFirstPass = false;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fTitle != null) {
            shell.setText(this.fTitle);
        }
    }

    private int getInputTextStyle() {
        return 2052;
    }
}

