/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.debug.core.intrp.model.IIntrpLabelProvider;
import ro.amiq.dvt.debug.core.intrp.model.IntrpValue;
import ro.amiq.dvt.debug.core.model.DebugElement;
import ro.amiq.dvt.debug.core.model.breakpoints.BaseBreakpoint;
import ro.amiq.dvt.debug.core.model.variables.ListVariable;
import ro.amiq.dvt.debug.ui.model.IDebugLabelProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DebugModelPresentation
implements IDebugModelPresentation {
    public void computeDetail(IValue value, IValueDetailListener listener) {
        try {
            if (value instanceof IntrpValue) {
                listener.detailComputed(value, ((IntrpValue)value).getDetailsValueString());
            } else {
                listener.detailComputed(value, value.getValueString());
            }
        }
        catch (DebugException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Image getImage(Object element) {
        if (element instanceof IDebugLabelProvider) {
            return ((IDebugLabelProvider)element).getImage();
        }
        if (element instanceof IIntrpLabelProvider) {
            return ((IIntrpLabelProvider)element).getImage();
        }
        if (element instanceof DebugElement) {
            return ((DebugElement)((Object)element)).getImage();
        }
        if (element instanceof BaseBreakpoint) {
            return ((BaseBreakpoint)((Object)element)).getImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IDebugLabelProvider) {
            return ((IDebugLabelProvider)element).getText();
        }
        if (element instanceof IIntrpLabelProvider) {
            return ((IIntrpLabelProvider)element).getText();
        }
        if (element instanceof BaseBreakpoint) {
            return ((BaseBreakpoint)((Object)element)).getText();
        }
        if (element instanceof ListVariable) {
            return ((ListVariable)((Object)element)).getName();
        }
        return null;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getEditorId(IEditorInput input, Object element) {
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource != null && resource instanceof IFile) {
            String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.edt.ESource", false);
            if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
                return "ro.amiq.edt.ui.editor.EEditor";
            }
            fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", false);
            if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
                return "ro.amiq.vlogdt.ui.editor.VlogEditor";
            }
            fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.vhdldt.VhdlSource", false);
            if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
                return "ro.amiq.vhdldt.ui.editor.VhdlEditor";
            }
            fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.slndt.SLNSource", false);
            if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
                return "ro.amiq.slndt.ui.editor.SLNEditor";
            }
            fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.pssdt.PSSSource", false);
            if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
                return "ro.amiq.pssdt.ui.editor.PSSEditor";
            }
            fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.msdldt.MSDLSource", false);
            if (DVTFileUtils.getInstance().validExtension(fileExtensions, resource.getName())) {
                return "ro.amiq.msdldt.ui.editor.MSDLEditor";
            }
        }
        return "ro.amiq.vlogdt.ui.editor.VlogEditor";
    }

    public IEditorInput getEditorInput(Object element) {
        FileEditorInput editorInput = null;
        if (element instanceof BaseBreakpoint) {
            BaseBreakpoint breakpoint = (BaseBreakpoint)((Object)element);
            try {
                if (breakpoint.getLineNumber() <= 0) {
                    return null;
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            IResource resource = breakpoint.getMarker().getResource();
            editorInput = new FileEditorInput((IFile)resource);
        }
        if (element instanceof IFile) {
            editorInput = new FileEditorInput((IFile)element);
        }
        return editorInput;
    }
}

