/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.util;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.debug.ui.actions.DynamicResumeDebuggerButtonContribution;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;

public class ResumePopupDialog
extends PopupDialog {
    private static final String SELECTION_RUNNABLE = "selection.runnable";
    private static final SelectionListener SELECTION_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ResumePopupDialog.runWidgetSelectedAction(e.widget);
        }
    };
    private Button OKButton;

    public ResumePopupDialog() {
        super(DVTUiUtils.getActiveWorkbenchWindow().getShell(), 0, true, false, false, false, false, null, null);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(container, 0);
        label.setText("Time units:");
        final Text text = new Text(container, 2048);
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                if (arg0.keyCode == 13 || arg0.keyCode == 0x1000050) {
                    DynamicResumeDebuggerButtonContribution.runCustomValue(text.getText());
                    ResumePopupDialog.this.close();
                } else {
                    ResumePopupDialog.this.validateTimeUnit(text);
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.OKButton = this.createButton(container, 8, "OK", () -> {
            DynamicResumeDebuggerButtonContribution.runCustomValue(text.getText());
            this.close();
        });
        this.createButton(container, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        return container;
    }

    protected Point getInitialLocation(Point initialSize) {
        return Display.getDefault().getCursorLocation();
    }

    private void validateTimeUnit(Text text) {
        if (!DVTStringUtil.matches(DVTStringUtil.INTEGER_PATTERN, text.getText())) {
            this.OKButton.setEnabled(false);
            DVTColorUtil.INSTANCE.setForeground((Control)text, DVTColorUtil.INSTANCE.getColor(255, 0, 0), true);
        } else {
            this.OKButton.setEnabled(true);
            DVTColorUtil.INSTANCE.setForeground((Control)text, DVTColorUtil.INSTANCE.getDefaultForeground((Control)text), true);
        }
    }

    private Button createButton(Composite container, int push, String string, Runnable object) {
        Button button = new Button(container, push);
        if (string != null) {
            button.setText(string);
        }
        if (object != null) {
            button.setData(SELECTION_RUNNABLE, (Object)object);
            button.addSelectionListener(SELECTION_LISTENER);
        }
        return button;
    }

    private static void runWidgetSelectedAction(Widget widget) {
        Object action = widget.getData(SELECTION_RUNNABLE);
        if (action == null) {
            return;
        }
        ((Runnable)action).run();
    }
}

