/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.view;

import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.debug.ui.view.QuickLazyDVTVariablesView;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTQuickVariablesViewDelegate
implements IViewActionDelegate {
    public void run(IAction action) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            throw new IllegalStateException("Unable to find workbench windows");
        }
        IViewPart varsView = activePage.findView("org.eclipse.debug.ui.VariableView");
        if (!(varsView instanceof AbstractDebugView)) {
            throw new IllegalStateException("Unable to locate platform's Variables View");
        }
        Viewer viewer = ((AbstractDebugView)varsView).getViewer();
        if (!(viewer instanceof TreeViewer)) {
            throw new IllegalStateException("Unable to find viewer for Variables View");
        }
        Object input = ((TreeViewer)viewer).getInput();
        if (!(input instanceof IntrpStackFrame)) {
            return;
        }
        IVariable[] variables = ((IntrpStackFrame)input).getVariables();
        if (variables == null || variables.length == 0) {
            return;
        }
        DVTQuickVariablesViewDelegate.openQuickLazyDVTVariablesView();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
    }

    public static QuickLazyDVTVariablesView openQuickLazyDVTVariablesView() {
        QuickLazyDVTVariablesView view;
        block7: {
            IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
            if (!(activeEditor instanceof DVTEditor)) {
                return null;
            }
            DVTEditor editor = (DVTEditor)activeEditor;
            IEditorSite editorSite = editor.getEditorSite();
            if (editorSite == null) {
                throw new IllegalStateException("Unable to compute editor site");
            }
            ISelectionProvider selectionProvider = editorSite.getSelectionProvider();
            if (selectionProvider == null) {
                throw new IllegalStateException("Unable to compute selection provider");
            }
            IProject project = editor.getProject();
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return null;
            }
            try {
                view = editor.createQuickLazyDVTVariablesView();
                if (view != null) break block7;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        view.open();
        view.setFocus();
        view.getShell().forceActive();
        view.update();
        return view;
    }
}

