/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.debug.core.intrp.model.IntrpVariable;
import ro.amiq.dvt.debug.ui.view.ILazySearchVariablesModel;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class LazyDVTVariablesModel
implements ILazySearchVariablesModel {
    private final DVTBaseLabelProvider provider;
    private final IProject project;
    private IRfNamedElement inspectedElement;

    public LazyDVTVariablesModel(DVTBaseLabelProvider provider, IProject project) {
        this.provider = provider;
        this.project = project;
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (treePath == null) {
            return Collections.emptyList();
        }
        List<Object> result = new ArrayList();
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            try {
                result = this.internalComputeRoots(monitor);
            }
            catch (DebugException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                result = null;
            }
            if (result != null) {
                return result;
            }
            result = new ArrayList();
            if (result.isEmpty()) {
                result.add(AbstractTreeIterator.getDummyOperatioNode(null));
            }
            return result;
        }
        Object element = treePath.getElement();
        if (element instanceof DummyElement) {
            return result;
        }
        if (this.isRecursiveNode(treePath)) {
            TreePath reccurenceNode = TreePath.child(treePath, DummyElement.RECURRENCE_NODE.getName(), 0);
            reccurenceNode.setElement(DummyElement.RECURRENCE_NODE);
            return Collections.singletonList(reccurenceNode);
        }
        List<Object> children = null;
        try {
            children = this.internalGetChildrenForElement(element, monitor);
        }
        catch (DebugException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return result;
        }
        if (children == null) {
            return result;
        }
        int i = childStartIndex;
        while (i < Math.min(childEndIndex, children.size())) {
            TreePath prevChild;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Object dvtElementWrapper = children.get(i);
            String text = this.provider.getText(dvtElementWrapper);
            TreePath child = TreePath.child(treePath, text, i);
            child.setElement(dvtElementWrapper);
            TreePath treePath2 = prevChild = result.isEmpty() ? null : (TreePath)result.get(result.size() - 1);
            if (child.equals(prevChild, true)) {
                child.append("@(" + i + ")@");
            }
            result.add(child);
            ++i;
        }
        return result;
    }

    private boolean isRecursiveNode(TreePath treePath) {
        Object elementObj = treePath.getElement();
        if (elementObj instanceof IDVTElementWrapper) {
            elementObj = ((IDVTElementWrapper)elementObj).getRfElement();
        }
        if (!(elementObj instanceof IntrpVariable)) {
            return false;
        }
        IntrpVariable varNode = (IntrpVariable)elementObj;
        IELParamValue varXNodeValue = varNode.getxValue();
        if (varXNodeValue == null) {
            return false;
        }
        TreePath parentPath = treePath.getParent();
        while (parentPath != null) {
            Object parentPathElement = parentPath.getElement();
            if (parentPathElement instanceof IDVTElementWrapper) {
                parentPathElement = ((IDVTElementWrapper)parentPathElement).getRfElement();
            }
            IELParamValue parentXNodeValue = null;
            if (parentPathElement instanceof IntrpVariable) {
                parentXNodeValue = ((IntrpVariable)parentPathElement).getxValue();
            }
            if (varXNodeValue.equals(parentXNodeValue) || varXNodeValue == parentXNodeValue) {
                return true;
            }
            parentPath = parentPath.getParent();
        }
        return false;
    }

    private List<Object> internalGetChildrenForElement(Object element, IProgressMonitor monitor) throws DebugException {
        IValue value;
        if (monitor.isCanceled()) {
            return null;
        }
        Object obj = element;
        if (obj instanceof IDVTElementWrapper) {
            obj = ((IDVTElementWrapper)obj).getRfElement();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (obj instanceof IntrpVariable && (value = ((IntrpVariable)obj).getValue()).hasVariables()) {
            IVariable[] variables;
            IVariable[] iVariableArray = variables = value.getVariables();
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable vari = iVariableArray[n2];
                result.add(new DVTTreeElementWrapper(vari));
                ++n2;
            }
        }
        return result;
    }

    private List<TreePath> internalComputeRoots(IProgressMonitor monitor) throws DebugException {
        if (monitor.isCanceled()) {
            return null;
        }
        List<IVariable> roots = this.internalGetFromPlatformRootVariables();
        if (roots.isEmpty()) {
            return null;
        }
        if (this.inspectedElement != null) {
            IVariable variable = this.internalFindVariableOnStack(roots, new LinkedList<IVariable>(), monitor);
            if (variable == null) {
                DummyElement dummyElement = new DummyElement("\"" + this.inspectedElement.getName() + "\" " + "cannot be resolved to a variable", true);
                TreePath unresolvedNode = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, dummyElement.getName(), 0);
                unresolvedNode.setElement(dummyElement);
                return Collections.singletonList(unresolvedNode);
            }
            return this.internalComputeAllRoots(Arrays.asList(variable), monitor);
        }
        return this.internalComputeAllRoots(roots, monitor);
    }

    private IVariable internalFindVariableOnStack(List<IVariable> roots, LinkedList<IVariable> stack, IProgressMonitor monitor) throws DebugException {
        for (IVariable variable : roots) {
            if (!(variable instanceof IntrpVariable)) {
                throw new IllegalStateException("Unknown evaluation of variable " + variable);
            }
            if (monitor.isCanceled()) {
                return null;
            }
            IELParamValue xValue = ((IntrpVariable)variable).getxValue();
            IRfNamedElement element = null;
            if (xValue instanceof XValueHolder) {
                element = ((XValueHolder)xValue).getElement();
            }
            if (xValue instanceof ELParamValues.ParamValueNumber) {
                element = ((ELParamValues.ParamValueNumber)xValue).getElement();
            }
            if (element != null && element == this.inspectedElement) {
                return variable;
            }
            IValue value = variable.getValue();
            if (!value.hasVariables()) continue;
            stack.add(variable);
            IVariable foundVar = this.internalFindVariableOnStack(Arrays.asList(value.getVariables()), stack, monitor);
            if (foundVar == null) continue;
            return foundVar;
        }
        return null;
    }

    private List<TreePath> internalComputeAllRoots(List<IVariable> roots, IProgressMonitor monitor) {
        if (roots == null || roots.isEmpty()) {
            return null;
        }
        int index = 0;
        ArrayList<TreePath> varPaths = new ArrayList<TreePath>();
        for (IVariable variable : roots) {
            if (!(variable instanceof IntrpVariable)) continue;
            if (monitor.isCanceled()) {
                return varPaths;
            }
            TreePath elem = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, variable.toString(), index++);
            DVTTreeElementWrapper dvtWrapper = new DVTTreeElementWrapper(variable);
            dvtWrapper.setProject(this.project);
            elem.setElement(dvtWrapper);
            varPaths.add(elem);
        }
        return varPaths;
    }

    private List<IVariable> internalGetFromPlatformRootVariables() {
        ArrayList<IVariable> variables = new ArrayList<IVariable>();
        Utils.syncExec(() -> {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            IViewPart varsView = activePage.findView("org.eclipse.debug.ui.VariableView");
            if (!(varsView instanceof AbstractDebugView)) {
                return;
            }
            Viewer viewer = ((AbstractDebugView)varsView).getViewer();
            if (!(viewer instanceof TreeViewer)) {
                return;
            }
            Object input = ((TreeViewer)viewer).getInput();
            if (!(input instanceof IntrpStackFrame)) {
                return;
            }
            IVariable[] vars = ((IntrpStackFrame)input).getVariables();
            if (vars == null || vars.length == 0) {
                return;
            }
            Collections.addAll(variables, vars);
        });
        return variables;
    }

    @Override
    public Boolean hasChildren(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    @Override
    public TreePath getEndTreePath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return treePath;
        }
        TreePath currentPath = treePath;
        List<TreePath> children = this.getChildren(treePath, 0, Integer.MAX_VALUE, monitor);
        while (children != null && !children.isEmpty()) {
            if (monitor.isCanceled()) {
                return currentPath;
            }
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, Integer.MAX_VALUE, monitor);
        }
        return currentPath;
    }

    @Override
    public void clearModelCaches() {
    }

    public void setElementToInspect(Object namedElement) {
        if (!(namedElement instanceof IRfNamedElement)) {
            throw new IllegalStateException("Unsupported element to inspect " + namedElement);
        }
        this.inspectedElement = (IRfNamedElement)namedElement;
    }
}

