/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.debug.ui.view;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.debug.core.intrp.model.IntrpVariable;
import ro.amiq.dvt.debug.ui.view.LazyDVTVariablesModel;
import ro.amiq.dvt.debug.ui.view.VlogQuickSearchVariablesLabelProvider;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IQuickLazyCollapsableView;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.lazy.tree.ExpandCollapseState;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyTable;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.utils.ILazyTreeTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.quick.DVTQuickLazyView;
import ro.amiq.dvt.utils.StringMatcher;

public class QuickLazyDVTVariablesView
extends DVTQuickLazyView
implements IRfFilterableTreeAccessor,
IDVTLazyTable,
IQuickLazyCollapsableView {
    private LazyDVTVariablesModel model;
    protected DVTBaseLabelProvider labelProvider;
    private static final String TITLE = "Quick Variables View";
    private static final String ID = "ro.amiq.dvt.debug.ui.view.QuickLazySearchView";
    private static final int COLUMN_SIZE = 50;

    public QuickLazyDVTVariablesView(DVTEditor editor) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 48, editor.getProject());
        this.setTextFilterMessage("default-filter", "Filter by: name");
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        if (this.model == null) {
            this.model = new LazyDVTVariablesModel(this.labelProvider, this.project);
        }
        return this.model;
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.QUICK_LAZY_SEARCH_VARIABLES;
    }

    @Override
    public Objection getObjection() {
        return Objection.QUICK_VARIABLES;
    }

    @Override
    public ILazyTreeTestUtils getLazyTreeTestUtils() {
        return null;
    }

    @Override
    public boolean supportsDecorations() {
        return false;
    }

    @Override
    public String getMessageText() {
        return LazyTreeMessageCompositeType.NO_DATA.getMessage();
    }

    @Override
    public void createAndSyncTreeColumns(Table topTable, Tree tree, ScrolledComposite scrolledComposite) {
        int n = tree.getSize().x;
        if (n == 0) {
            n = 1000;
        }
        TableColumn fNameColumn = new TableColumn(topTable, 16384);
        fNameColumn.setText("Name");
        fNameColumn.setWidth(n * 50 / 100);
        TreeColumn treeNameColumn = new TreeColumn(tree, 16384);
        treeNameColumn.setWidth(fNameColumn.getWidth());
        TableColumn fValueColumn = new TableColumn(topTable, 16384);
        fValueColumn.setText("Value");
        fValueColumn.setWidth(n * 50 / 100);
        TreeColumn treeValueColumn = new TreeColumn(tree, 16384);
        treeValueColumn.setWidth(fValueColumn.getWidth());
        fNameColumn.addListener(11, event -> {
            int n1 = fNameColumn.getWidth() + fValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeNameColumn.setWidth(fNameColumn.getWidth());
        });
        fValueColumn.addListener(11, event -> {
            int n1 = fNameColumn.getWidth() + fValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeValueColumn.setWidth(fValueColumn.getWidth());
        });
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.getLabelProvider();
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchSegments();
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchTextStrictness();
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public void setInput(Object namedElement) {
        if (!(namedElement instanceof IRfNamedElement)) {
            return;
        }
        this.getModel(null);
        if (this.model == null) {
            throw new IllegalStateException("Unable to compute model for Quick Variables View");
        }
        try {
            if (!DVTPlugin.getDefault().collect().c(this.project, "F636F7265")) {
                return;
            }
            this.getShell().setText(this.getTitle());
            this.setTitleText(this.getTitle());
            this.model.setElementToInspect(namedElement);
            this.update();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean isFiltered() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return false;
        }
        return textFilterObject.isFiltered();
    }

    @Override
    public UpdateJob getUpdateJob() {
        return null;
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    public DVTBaseLabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new VlogQuickSearchVariablesLabelProvider();
        }
        return this.labelProvider;
    }

    @Override
    protected void gotoSelectedElement() {
        if (this.project == null) {
            return;
        }
        TreePath selectedPath = this.getSelectedPath();
        if (selectedPath == null) {
            return;
        }
        this.goToElement(selectedPath);
    }

    @Override
    protected void goToElement(TreePath selectedPath) {
        GoToInfo goToInfo;
        if (selectedPath == null) {
            this.closeViewAndOpenErrorDialog();
            return;
        }
        Object element = selectedPath.getElement();
        if (element instanceof IDVTElementWrapper) {
            element = ((IDVTElementWrapper)element).getRfElement();
        }
        if (!(element instanceof IntrpVariable)) {
            this.closeViewAndOpenErrorDialog();
            return;
        }
        IELParamValue xValue = ((IntrpVariable)element).getxValue();
        if (xValue == null) {
            this.closeViewAndOpenErrorDialog();
            return;
        }
        IRfNamedElement namedElement = xValue.getElement();
        if (namedElement == null) {
            XValueHolder refValueHolder;
            XNamedElement xNamedElement;
            if (xValue instanceof XValueHolder && (xNamedElement = (refValueHolder = (XValueHolder)XUtils.getRefValue(((XValueHolder)xValue).getRefValueHolder())).getXNamedElement()) != null) {
                namedElement = xNamedElement.getNamedElement();
            }
            if (namedElement == null) {
                this.closeViewAndOpenErrorDialog();
                return;
            }
        }
        if ((goToInfo = GoToInfo.sourceOf(namedElement)) == null) {
            this.closeViewAndOpenErrorDialog();
            return;
        }
        goToInfo.open(this.project, true);
    }

    @Override
    protected void addMouseListenerHyperlink(Tree tree) {
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                QuickLazyDVTVariablesView.this.gotoSelectedElement("default-tree");
            }
        });
    }

    @Override
    public void update() {
        this.getLazyTree().doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.model, ExpandCollapseState.COLLAPSED, null, false, true, true, this.getObjection()));
    }

    @Override
    protected String getId() {
        return ID;
    }

    @Override
    public int getViewColumnCount() {
        return 2;
    }

    private void closeViewAndOpenErrorDialog() {
        this.close();
        MessageDialog.open((int)1, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Quick Variables View Error", (String)"An error occurred while trying to go to the selected element.", (int)0);
    }
}

