/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;

public abstract class DNamedElementDiagram
implements DDiagram {
    protected final IProject project;
    protected final String title;
    protected final String name;
    protected String fullName;
    protected final RfElementPath elementPath;

    protected DNamedElementDiagram(IRfNamedElement namedElement, String namePrefix, ElementPath path) {
        this.project = namedElement.getRfProject() != null ? namedElement.getRfProject().getProject() : null;
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.project);
        IRfNamedElement element = memory == null || path == null ? namedElement : memory.instanceFor(path);
        this.title = NLUtils.getDesignNLLabel(namedElement, NLUtils.getNLDesign(element), path).replace("\n", " ");
        this.name = String.valueOf(namePrefix) + this.title;
        this.elementPath = RfElementPath.path(namedElement);
        this.fullName = String.valueOf(namePrefix) + this.elementPath.toNiceString();
    }

    public IRfNamedElement getNamedElement() {
        return this.elementPath.toNamedElement(this.project);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DNamedElementDiagram other = (DNamedElementDiagram)obj;
        if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName));
    }
}

