/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams;

import de.cau.cs.kieler.core.kgraph.KNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DAggregateException;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.KLayDiagramLayout;
import ro.amiq.dvt.diagrams.preferences.DiagramPreferenceAdapter;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class DPhases {
    public static KNode layoutKNode(KNode node, DProgressMonitor monitor) throws DCanceledException {
        DPhases.checkInput(node);
        monitor.subTask("Layout graph");
        Random random = new Random(1L);
        int currentSeed = 1;
        DAggregateException aggregateException = new DAggregateException("Failed to layout diagram due to exceptions!");
        int layoutRetries = DiagramPreferenceAdapter.getInstance().getDiagramLayoutRetries();
        int i = 1;
        while (i <= layoutRetries) {
            try {
                if (i > 1) {
                    DPhases.shuffleGates(node, new Random(currentSeed));
                }
                KLayDiagramLayout.INSTANCE.layout(node, currentSeed, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1, 4));
                return node;
            }
            catch (Throwable e) {
                Thread.interrupted();
                if (e instanceof DCanceledException || e instanceof ThreadDeath) {
                    if (monitor.isCanceled()) {
                        throw e;
                    }
                    monitor.setTimedout(false);
                    aggregateException.addException(new Exception("Failed to layout diagram due to timeout!"));
                } else {
                    aggregateException.addException(e);
                }
                if (i == layoutRetries) {
                    throw aggregateException;
                }
                int oldSeed = currentSeed;
                currentSeed = random.nextInt();
                DVTLogger.INSTANCE.logInfo("Failed to generate diagram with seed '" + oldSeed + "', trying seed '" + currentSeed + "'");
                monitor.setMessage("Generating diagram (" + String.valueOf(i + 1) + "/" + String.valueOf(layoutRetries) + ")...");
                ++i;
            }
        }
        return null;
    }

    public static void checkInput(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Input is null!");
        }
    }

    public static void shuffleGates(KNode node, Random r) {
        if (node == null) {
            return;
        }
        EList children = node.getChildren();
        for (KNode child : children) {
            DPhases.shuffleGates(child, r);
        }
        ArrayList copy = new ArrayList(children);
        Collections.shuffle(copy, r);
        node.getChildren().clear();
        node.getChildren().addAll(copy);
    }
}

