/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.draw.debug.DDebug;

public class DProgressMonitor
extends ProgressMonitorWrapper {
    private final Consumer<String> messageHandler;
    private final Supplier<DDebug> debugSupplier;
    private boolean isTimedout = false;
    private String debugTimeoutInfo;

    public static DProgressMonitor wrap(IProgressMonitor monitor, Consumer<String> messageHandler, Supplier<DDebug> debugSupplier) {
        return new DProgressMonitor(monitor, messageHandler, debugSupplier);
    }

    private DProgressMonitor(IProgressMonitor monitor, Consumer<String> messageHandler, Supplier<DDebug> debugSupplier) {
        super(monitor);
        this.messageHandler = messageHandler;
        this.debugSupplier = debugSupplier;
    }

    public void setTimedout(boolean b) {
        this.isTimedout = b;
    }

    public boolean isTimedout() {
        return this.isTimedout;
    }

    public void checkCanceled() throws DCanceledException {
        if (this.isTimedout() || this.isCanceled()) {
            throw new DCanceledException();
        }
    }

    public void setMessage(String message) {
        if (this.messageHandler != null) {
            this.messageHandler.accept(message);
        }
    }

    public DDebug getDebug() {
        return this.debugSupplier.get();
    }

    public String getDebugTimeoutInfo() {
        return this.debugTimeoutInfo;
    }

    public void setDebugTimeoutInfo(String debugTimeoutInfo) {
        this.debugTimeoutInfo = debugTimeoutInfo;
    }
}

