/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DGenerator;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.CHPhases;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.ICHModel;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDScene;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHActionFlags;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public class CHActionDiagram
implements ICHDiagram {
    private static final DGenerator.Builder<CHActionDiagram, CHDScene> SCENE_GENERATOR = DGenerator.Builder.input(CHActionDiagram.class).phase(CHPhases::makeComponentActionDiagram).phase(DPhases::layoutKNode).phase(CHPhases::createCHDScene);
    private CHConfig config;
    private final ICHModel model;
    private final IProject project;
    private IDVTElementWrapper wrapper;
    private String wrapperPath;
    private String elementName;
    private int depth;
    private CHPort portSelection;
    private DCHActionFlags actionFlag;
    private ArrayList<CHPort> visibleSources;
    private ArrayList<CHPort> visibleDestinations;
    private CHUVMComponent topComponent;

    public CHActionDiagram(IDVTElementWrapper wrapper, IProject project, ICHModel model, CHConfig config, int depth, CHPort portSelection, ArrayList<CHPort> visibleDestinations, ArrayList<CHPort> visibleSources, DCHActionFlags actionFlag) {
        this.project = project;
        this.model = model;
        this.config = config;
        this.depth = depth;
        this.portSelection = portSelection;
        this.visibleDestinations = visibleDestinations != null ? visibleDestinations : new ArrayList();
        this.visibleSources = visibleSources != null ? visibleSources : new ArrayList();
        this.actionFlag = actionFlag;
        switch (actionFlag) {
            case SHOW_DESTINATIONS: {
                if (this.isDuplicatePort(portSelection, this.visibleSources).booleanValue()) break;
                this.visibleSources.add(portSelection);
                break;
            }
            case SHOW_SOURCES: {
                if (this.isDuplicatePort(portSelection, this.visibleDestinations).booleanValue()) break;
                this.visibleDestinations.add(portSelection);
                break;
            }
        }
        this.setWrapper(wrapper);
    }

    public Boolean isDuplicatePort(CHPort portSelection, ArrayList<CHPort> ports) {
        for (CHPort port : ports) {
            if (!port.getName().equals(portSelection.getName()) || !port.getPath().contains(portSelection.getPath()) && !portSelection.getPath().contains(port.getPath())) continue;
            return true;
        }
        return false;
    }

    @Override
    public DGenerator<? extends DDiagram, ? extends DObject> getSceneGenerator() {
        return SCENE_GENERATOR.build(this);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public String getTitle() {
        return this.wrapper != null ? this.model.getNameFor(this.wrapper.getRfElement()) : "";
    }

    @Override
    public String getName() {
        return this.elementName != null ? "UVM Components of " + this.elementName : "";
    }

    public ICHModel getModel() {
        return this.model;
    }

    @Override
    public void setComponent(CHUVMComponent component) {
        this.topComponent = component;
    }

    @Override
    public CHUVMComponent getComponent() {
        return this.topComponent;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public CHConfig getConfig() {
        return this.config;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return this.model.getLanguageKind();
    }

    @Override
    public IDVTElementWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(IDVTElementWrapper wrapper) {
        this.wrapper = wrapper;
        this.wrapperPath = this.model.getPath(wrapper, "");
        this.elementName = this.model.getNameFor(wrapper.getRfElement());
    }

    @Override
    public ICHDiagram getCopy(CHConfig config, int depth, boolean isExplicitVifConnections) {
        CHDiagram2 copy = new CHDiagram2(this.getWrapper(), this.getProject(), this.getModel(), config != null ? config : this.getConfig(), depth, isExplicitVifConnections);
        return copy;
    }

    public CHPort getPortSelection() {
        return this.portSelection;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionFlag, this.config, this.depth, this.elementName, this.model, this.portSelection, this.project, this.topComponent, this.visibleDestinations, this.visibleSources, this.wrapper, this.wrapperPath});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CHActionDiagram other = (CHActionDiagram)obj;
        return this.actionFlag == other.actionFlag && Objects.equals(this.config, other.config) && this.depth == other.depth && Objects.equals(this.elementName, other.elementName) && Objects.equals(this.model, other.model) && Objects.equals(this.portSelection, other.portSelection) && Objects.equals(this.project, other.project) && Objects.equals(this.topComponent, other.topComponent) && Objects.equals(this.visibleDestinations, other.visibleDestinations) && Objects.equals(this.visibleSources, other.visibleSources) && Objects.equals(this.wrapper, other.wrapper) && Objects.equals(this.wrapperPath, other.wrapperPath);
    }

    public DCHActionFlags getActionFlag() {
        return this.actionFlag;
    }

    public void setActionFlag(DCHActionFlags actionFlag) {
        this.actionFlag = actionFlag;
    }

    public ArrayList<CHPort> getVisibleDestinatons() {
        return this.visibleDestinations;
    }

    public void setVisibleDestinatons(ArrayList<CHPort> visibleDestinatons) {
        this.visibleDestinations = visibleDestinatons;
    }

    public ArrayList<CHPort> getVisibleSources() {
        return this.visibleSources;
    }

    public void setVisibleSources(ArrayList<CHPort> visibleSources) {
        this.visibleSources = visibleSources;
    }
}

