/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch;

import java.io.File;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DFileDiagram;
import ro.amiq.dvt.diagrams.DGenerator;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.diagrams.ch.CHPhases;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDScene;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public class CHDiagram
extends DFileDiagram {
    private static final DGenerator.Builder<CHDiagram, CHDScene> SCENE_GENERATOR = DGenerator.Builder.input(CHDiagram.class).phase(CHPhases::parseXML).phase(DPhases::layoutKNode).phase(CHPhases::createCHDScene);
    private CHConfig config;
    private int depth;
    private CHUVMComponent topComponent;
    private boolean isExplicitVifConnections = true;
    private static final String EXTENSION = ".chd";
    private static final String PREFIX = "component_hierarchy_of_";

    public CHDiagram(IProject project, File file, CHConfig config, int depth) {
        super(project, file.getName(), file.getName(), file);
        this.config = config;
        this.depth = depth;
    }

    @Override
    public DGenerator<? extends DDiagram, ? extends DObject> getSceneGenerator() {
        return SCENE_GENERATOR.build(this);
    }

    private static String getNameFromFile(String fileName) {
        if (fileName.endsWith(EXTENSION)) {
            fileName = fileName.substring(0, fileName.length() - EXTENSION.length());
        }
        if (fileName.startsWith(PREFIX)) {
            fileName = fileName.substring(PREFIX.length());
        }
        return fileName;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public CHConfig getConfig() {
        return this.config;
    }

    @Override
    public void setComponent(CHUVMComponent component) {
        this.topComponent = component;
    }

    @Override
    public CHUVMComponent getComponent() {
        return this.topComponent;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    @Override
    public boolean isExplicitVifConnections() {
        return this.isExplicitVifConnections;
    }

    @Override
    public void setExplicitVifConnections(boolean isExplicitVifConnections) {
        this.isExplicitVifConnections = isExplicitVifConnections;
    }

    @Override
    public ICHDiagram getCopy(CHConfig config, int depth, boolean isExplicitVifConnections) {
        CHDiagram copy = new CHDiagram(this.getProject(), this.getFile(), config != null ? config : this.getConfig(), depth);
        return copy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + this.depth;
        result = 31 * result + (this.topComponent == null ? 0 : this.topComponent.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CHDiagram other = (CHDiagram)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.depth != other.depth) {
            return false;
        }
        return !(this.topComponent == null ? other.topComponent != null : !this.topComponent.equals(other.topComponent));
    }

    @Override
    public IDVTElementWrapper getWrapper() {
        return null;
    }
}

