/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DGenerator;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.diagrams.ch.CHPhases;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.ICHModel;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDScene;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.IModel;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;

public class CHDiagram2
implements ICHDiagram {
    private static final DGenerator.Builder<CHDiagram2, CHDScene> SCENE_GENERATOR = DGenerator.Builder.input(CHDiagram2.class).phase(CHPhases::makeComponentDiagram).phase(DPhases::layoutKNode).phase(CHPhases::createCHDScene);
    private CHConfig config;
    private final ICHModel model;
    private final IProject project;
    private IDVTElementWrapper wrapper;
    private String wrapperPath;
    private String elementName;
    private int depth;
    private boolean isExplicitVifConnections = true;
    private boolean isGeneratedAfterElab;
    private CHUVMComponent topComponent;

    public CHDiagram2(IDVTElementWrapper wrapper, IProject project, ICHModel model, CHConfig config, int depth, boolean isExplicitVifConnections) {
        this.project = project;
        this.model = model;
        this.config = config;
        this.depth = depth;
        this.isExplicitVifConnections = isExplicitVifConnections;
        this.setWrapper(wrapper);
    }

    @Override
    public DGenerator<? extends DDiagram, ? extends DObject> getSceneGenerator() {
        return SCENE_GENERATOR.build(this);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public String getTitle() {
        return this.wrapper != null ? this.model.getNameFor(this.wrapper.getRfElement()) : "";
    }

    @Override
    public String getName() {
        return this.elementName != null ? "UVM Components of " + this.elementName : "";
    }

    public ICHModel getModel() {
        return this.model;
    }

    @Override
    public void setComponent(CHUVMComponent component) {
        this.topComponent = component;
    }

    @Override
    public CHUVMComponent getComponent() {
        return this.topComponent;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public CHConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isExplicitVifConnections() {
        return this.isExplicitVifConnections;
    }

    @Override
    public void setExplicitVifConnections(boolean isExplicitVifConnections) {
        this.isExplicitVifConnections = isExplicitVifConnections;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return this.model.getLanguageKind();
    }

    public boolean isGeneratedAfterElab() {
        return this.isGeneratedAfterElab;
    }

    @Override
    public void setGeneratedAfterElab(boolean isGeneratedAfterElab) {
        this.isGeneratedAfterElab = isGeneratedAfterElab;
    }

    @Override
    public IDVTElementWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(IDVTElementWrapper wrapper) {
        this.wrapper = wrapper;
        this.wrapperPath = this.model.getPath(wrapper, "");
        this.elementName = this.model.getNameFor(wrapper.getRfElement());
    }

    @Override
    public ICHDiagram getCopy(CHConfig config, int depth, boolean isExplicitVifConnections) {
        CHDiagram2 copy = new CHDiagram2(this.getWrapper(), this.getProject(), this.getModel(), config != null ? config : this.getConfig(), depth, isExplicitVifConnections);
        return copy;
    }

    public void getNewWrapperFromTreePath(TreePath treePath, VerificationHierarchyView view) {
        if (treePath == null) {
            return;
        }
        IDVTModel dvtModel = view.getModel(IModel.class);
        if (!(dvtModel instanceof IModel)) {
            return;
        }
        IModel lazyModel = (IModel)dvtModel;
        TreePath restoredTreePath = this.restoreTreePath(treePath, lazyModel, view);
        if (restoredTreePath == null) {
            return;
        }
        DVTTreeElementWrapper newWrapper = new DVTTreeElementWrapper(restoredTreePath.getElement());
        newWrapper.setProject(this.getProject());
        newWrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TREE_PATH, restoredTreePath);
        TreePath parent = restoredTreePath.getParent();
        if (parent != null && parent.equals(TreePath.TOP_DUMMY_TREE_PATH)) {
            newWrapper.setParent(new DVTTreeElementWrapper(parent));
        }
        this.setWrapper(newWrapper);
    }

    private TreePath restoreTreePath(TreePath treePath, IModel model, VerificationHierarchyView view) {
        HashSet<TreePath> startPathsCopy = new HashSet<TreePath>();
        startPathsCopy.add(treePath);
        HashSet<TreePath> restoredPaths = new HashSet<TreePath>();
        List<TreePath> tops = model.getChildren(TreePath.TOP_DUMMY_TREE_PATH, 0, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        if (tops == null || tops.isEmpty()) {
            return null;
        }
        TreePath startTreePathCandidate = TreePathUtils.restorePathsStartingFromRootPath(treePath, tops, startPathsCopy, restoredPaths, view, (IProgressMonitor)new NullProgressMonitor());
        if (startTreePathCandidate == null) {
            return null;
        }
        return startTreePathCandidate;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + this.depth;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.topComponent == null ? 0 : this.topComponent.hashCode());
        result = 31 * result + (this.wrapperPath == null ? 0 : this.wrapperPath.hashCode());
        result = 31 * result + (this.wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH) == null ? 0 : this.wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CHDiagram2 other = (CHDiagram2)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.depth != other.depth) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.topComponent == null ? other.topComponent != null : !this.topComponent.equals(other.topComponent)) {
            return false;
        }
        if (this.wrapperPath == null ? other.wrapperPath != null : !this.wrapperPath.equals(other.wrapperPath)) {
            return false;
        }
        return !(this.wrapper == null ? other.wrapper != null : !this.wrapper.equals(other.wrapper));
    }
}

