/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch;

import de.cau.cs.kieler.core.kgraph.KNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.CHActionDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.NecessaryComponents;
import ro.amiq.dvt.diagrams.ch.draw.CHDrawConverter;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDScene;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHActionFlags;
import ro.amiq.dvt.diagrams.ch.klay.CHDiagramImporter;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.CHUtils;
import ro.amiq.dvt.diagrams.ch.model.CHXMLParser;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.exceptions.DMessageException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSerializerRepo;
import ro.amiq.dvt.ui.editor.breadcrumb.DummyBreadcrumbSerializer;

public class CHPhases
extends DPhases {
    public static CHDScene createCHDScene(KNode kNode, DProgressMonitor monitor) throws DCanceledException {
        CHPhases.checkInput(kNode);
        monitor.subTask("Converting to scene");
        return CHDrawConverter.INSTANCE.convert(kNode, monitor);
    }

    private static CHRoot makeSubDiagram(ICHDiagram input, DProgressMonitor monitor) throws DCanceledException {
        CHPhases.checkInput(input);
        CHRoot root = null;
        try {
            root = CHUtils.makeSubRoot(input, monitor);
            CHUtils.applyFilters(root, input.getConfig(), monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return root != null ? root : CHRoot.DUMMY_ROOT;
    }

    public static KNode makeComponentDiagram(CHDiagram2 input, DProgressMonitor monitor) throws DCanceledException {
        CHPhases.checkInput(input);
        input.getModel().checkInput(input.getWrapper());
        monitor.subTask("Creating root");
        CHRoot root = null;
        if (input.getComponent() != null) {
            root = CHPhases.makeSubDiagram(input, monitor);
        } else {
            try {
                root = input.getModel().makeComponentDiagramFor(input, monitor);
                CHUtils.applyFilters(root, input.getConfig(), monitor);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (root == null || root == CHRoot.DUMMY_ROOT) {
            throw new DMessageException("Could not generate diagram!");
        }
        KNode result = null;
        try {
            result = CHDiagramImporter.INSTANCE.toKLay(root, input.getConfig(), monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (result == null) {
            throw new DMessageException("Could not generate diagram!");
        }
        return result;
    }

    public static KNode makeComponentActionDiagram(CHActionDiagram input, DProgressMonitor monitor) {
        NecessaryComponents necessaryComponents;
        CHPhases.checkInput(input);
        input.getModel().checkInput(input.getWrapper());
        monitor.subTask("Creating root");
        CHRoot root = null;
        try {
            root = input.getModel().makeComponentDiagramFor(input, monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (root == null || root == CHRoot.DUMMY_ROOT) {
            throw new DMessageException("Could not generate diagram!");
        }
        ArrayList<CHConnection> necessaryConnections = new ArrayList<CHConnection>();
        ArrayList<CHConnection> interfacesConnections = new ArrayList<CHConnection>();
        ArrayList<CHPort> necessaryPorts = new ArrayList<CHPort>();
        if ((input.getActionFlag().equals((Object)DCHActionFlags.SHOW_DESTINATIONS) || input.getActionFlag().equals((Object)DCHActionFlags.SHOW_SOURCES)) && (necessaryComponents = CHPhases.getShowDestAndSrcNecessaryComponents(input, root)) != null) {
            necessaryConnections.addAll(necessaryComponents.necessaryConnections);
            interfacesConnections.addAll(necessaryComponents.interfacesConnections);
            necessaryPorts.addAll(necessaryComponents.necessaryPorts);
        }
        if (input.getActionFlag().equals((Object)DCHActionFlags.SHOW_CONNECTIONS)) {
            NecessaryComponents connectionsNecessaryComponents = new NecessaryComponents();
            connectionsNecessaryComponents = CHPhases.getShowConnectionsNecessaryComponents(input, root);
            necessaryConnections.addAll(connectionsNecessaryComponents.necessaryConnections);
            interfacesConnections.addAll(connectionsNecessaryComponents.interfacesConnections);
            necessaryPorts.addAll(connectionsNecessaryComponents.necessaryPorts);
        }
        if (necessaryConnections.isEmpty()) {
            CHPhases.disposeUnnecessaryNodes(root.getUVMComponent(), input.getPortSelection());
        }
        if (!necessaryConnections.isEmpty()) {
            necessaryConnections.addAll(interfacesConnections);
            root.setConnections(necessaryConnections);
        }
        if (!necessaryPorts.isEmpty()) {
            CHUVMComponent topElement = root.getUVMComponent();
            CHPhases.disposeUnnecessaryNodes(topElement, necessaryPorts, input.getPortSelection());
        }
        try {
            CHUtils.applyFilters(root, input.getConfig(), monitor);
        }
        catch (DCanceledException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        KNode result = null;
        try {
            result = CHDiagramImporter.INSTANCE.toKLay(root, input.getConfig(), monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (result == null) {
            throw new DMessageException("Could not generate diagram!");
        }
        return result;
    }

    private static NecessaryComponents getShowConnectionsNecessaryComponents(CHActionDiagram input, CHRoot root) {
        NecessaryComponents necessaryComponents = new NecessaryComponents();
        for (CHConnection connection : root.getConnections()) {
            if (connection.getDestination().getName().equals(input.getPortSelection().getName()) && connection.getDestination().getPath().contains(input.getPortSelection().getPath())) {
                necessaryComponents.necessaryConnections.add(connection);
                necessaryComponents.necessaryPorts.add(connection.getSource());
                if (necessaryComponents.necessaryPorts.indexOf(connection.getDestination()) != -1) continue;
                necessaryComponents.necessaryPorts.add(connection.getDestination());
                continue;
            }
            if (connection.getSource().getName().equals(input.getPortSelection().getName()) && connection.getSource().getPath().contains(input.getPortSelection().getPath())) {
                necessaryComponents.necessaryConnections.add(connection);
                necessaryComponents.necessaryPorts.add(connection.getDestination());
                if (necessaryComponents.necessaryPorts.indexOf(connection.getSource()) != -1) continue;
                necessaryComponents.necessaryPorts.add(connection.getSource());
                continue;
            }
            if (connection.getSource().getKind().equals((Object)CHPort.Kind.INTERFACE)) {
                necessaryComponents.interfacesConnections.add(connection);
                continue;
            }
            connection.setIsVisible(false);
        }
        return necessaryComponents;
    }

    private static NecessaryComponents getShowDestAndSrcNecessaryComponents(CHActionDiagram input, CHRoot root) {
        NecessaryComponents necessaryComponents = new NecessaryComponents();
        List<CHConnection> connections = root.getConnections();
        if (connections == null) {
            return null;
        }
        ArrayList<CHPort> visibleDestinations = input.getVisibleDestinatons();
        ArrayList<CHPort> visibleSources = input.getVisibleSources();
        if (visibleSources == null && visibleDestinations == null) {
            return null;
        }
        for (CHConnection connection : connections) {
            CHPort connectionSource;
            boolean isNecessaryConnection = false;
            CHPort connectionDestination = connection.isSwap() ? connection.getSource() : connection.getDestination();
            CHPort cHPort = connectionSource = connection.isSwap() ? connection.getDestination() : connection.getSource();
            if (connection.getSource().getKind().equals((Object)CHPort.Kind.INTERFACE)) {
                necessaryComponents.interfacesConnections.add(connection);
                continue;
            }
            if (CHPhases.isDuplicateUnorientedConnection(necessaryComponents, connection)) continue;
            if (visibleSources != null) {
                for (CHPort port : visibleSources) {
                    if (port.getDirectionKind() == CHPort.DirectionKind.BIDIRECTIONAL) {
                        boolean isNecessaryBidirectionalConnection = CHPhases.addBidirectionalPortToNecessaryComponents(necessaryComponents, connection, port);
                        if (isNecessaryConnection) continue;
                        isNecessaryConnection = isNecessaryBidirectionalConnection;
                        continue;
                    }
                    if (!connectionSource.getName().equals(port.getName()) || !connectionSource.getPath().contains(port.getPath()) || necessaryComponents.necessaryConnections.indexOf(connection) != -1) continue;
                    for (CHConnection portConnection : connectionSource.getConnections()) {
                        if (!portConnection.equalsNotOriented(connection)) continue;
                        portConnection.setIsVisible(true);
                    }
                    necessaryComponents.necessaryConnections.add(connection);
                    necessaryComponents.necessaryPorts.add(connectionDestination);
                    if (necessaryComponents.necessaryPorts.indexOf(connectionSource) == -1) {
                        necessaryComponents.necessaryPorts.add(connectionSource);
                    }
                    if (isNecessaryConnection) continue;
                    isNecessaryConnection = true;
                }
            }
            if (visibleDestinations != null) {
                for (CHPort port : visibleDestinations) {
                    if (port.getDirectionKind() == CHPort.DirectionKind.BIDIRECTIONAL) {
                        boolean isNecessaryBidirectionalConnection = CHPhases.addBidirectionalPortToNecessaryComponents(necessaryComponents, connection, port);
                        if (isNecessaryConnection) continue;
                        isNecessaryConnection = isNecessaryBidirectionalConnection;
                        continue;
                    }
                    if (!connectionDestination.getName().equals(port.getName()) || !connectionDestination.getPath().contains(port.getPath()) || necessaryComponents.necessaryConnections.indexOf(connection) != -1) continue;
                    for (CHConnection portConnection : port.getConnections()) {
                        if (!portConnection.equalsNotOriented(connection)) continue;
                        portConnection.setIsVisible(true);
                    }
                    necessaryComponents.necessaryConnections.add(connection);
                    necessaryComponents.necessaryPorts.add(connectionSource);
                    if (necessaryComponents.necessaryPorts.indexOf(connectionDestination) == -1) {
                        necessaryComponents.necessaryPorts.add(connectionDestination);
                    }
                    if (isNecessaryConnection) continue;
                    isNecessaryConnection = true;
                }
            }
            if (!isNecessaryConnection) {
                connection.setIsVisible(false);
                continue;
            }
            connection.setIsVisible(true);
        }
        return necessaryComponents;
    }

    private static boolean isDuplicateUnorientedConnection(NecessaryComponents necessaryComponents, CHConnection connection) {
        for (CHConnection foundConnection : necessaryComponents.necessaryConnections) {
            if (!connection.equalsNotOriented(foundConnection)) continue;
            return true;
        }
        return false;
    }

    private static boolean addBidirectionalPortToNecessaryComponents(NecessaryComponents necessaryComponents, CHConnection connection, CHPort port) {
        if (necessaryComponents.necessaryConnections.indexOf(connection) != -1) {
            return false;
        }
        CHPort connectionSource = connection.getSource();
        CHPort connectionDestination = connection.getDestination();
        if (!(connectionSource.getName().equals(port.getName()) && connectionSource.getPath().contains(port.getPath()) || connectionDestination.getName().equals(port.getName()) && connectionDestination.getPath().contains(port.getPath()))) {
            return false;
        }
        necessaryComponents.necessaryConnections.add(connection);
        if (necessaryComponents.necessaryPorts.indexOf(connectionDestination) == -1) {
            necessaryComponents.necessaryPorts.add(connectionDestination);
        }
        if (necessaryComponents.necessaryPorts.indexOf(connectionSource) == -1) {
            necessaryComponents.necessaryPorts.add(connectionSource);
        }
        return true;
    }

    private static void disposeUnnecessaryNodes(CHContainer node, ArrayList<CHPort> necessaryPorts, CHPort portSelection) {
        if (node.getChildren() != null && !node.getChildren().isEmpty()) {
            int numberOfVisibileChildren = node.getChildren().size();
            for (CHContainer childNode : node.getChildren()) {
                CHPhases.disposeUnnecessaryNodes(childNode, necessaryPorts, portSelection);
                if (childNode.isVisible()) continue;
                --numberOfVisibileChildren;
            }
            Boolean hasNecessaryPort = false;
            for (CHPort port : node.getPorts()) {
                if (necessaryPorts.indexOf(port) != -1) {
                    hasNecessaryPort = true;
                }
                if (port.isSelected() || !port.getName().equals(portSelection.getName()) || !port.getPath().contains(portSelection.getPath())) continue;
                port.setSelected(true);
            }
            if (numberOfVisibileChildren == 0 && !hasNecessaryPort.booleanValue()) {
                node.setVisible(false);
            }
        }
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            Boolean hasNecessaryPort = false;
            for (CHPort port : node.getPorts()) {
                if (necessaryPorts.indexOf(port) != -1) {
                    hasNecessaryPort = true;
                }
                if (port.isSelected() || !port.getName().equals(portSelection.getName()) || !port.getPath().contains(portSelection.getPath())) continue;
                port.setSelected(true);
            }
            if (!hasNecessaryPort.booleanValue()) {
                node.setVisible(false);
            }
        }
    }

    private static void disposeUnnecessaryNodes(CHContainer node, CHPort portSelection) {
        if (node.getChildren() != null && !node.getChildren().isEmpty()) {
            int numberOfVisibileChildren = node.getChildren().size();
            for (CHContainer container : node.getChildren()) {
                CHPhases.disposeUnnecessaryNodes(container, portSelection);
                if (container.isVisible()) continue;
                --numberOfVisibileChildren;
            }
            for (CHPort port : node.getPorts()) {
                if (port.isSelected() || !port.getName().equals(portSelection.getName()) || !port.getPath().contains(portSelection.getPath())) continue;
                port.setSelected(true);
            }
            if (!(numberOfVisibileChildren != 0 || node.getName().equals(portSelection.getParent().getName()) && node.getPath().contains(portSelection.getParent().getPath()))) {
                node.setVisible(false);
            }
        }
        if (node.getChildren() == null || node.getChildren().isEmpty()) {
            if (!node.getName().equals(portSelection.getParent().getName()) || !node.getPath().contains(portSelection.getParent().getPath())) {
                node.setVisible(false);
            }
            for (CHPort port : node.getPorts()) {
                if (port.isSelected() || !port.getName().equals(portSelection.getName()) || !port.getPath().contains(portSelection.getPath())) continue;
                port.setSelected(true);
            }
        }
    }

    public static KNode parseXML(CHDiagram input, DProgressMonitor monitor) throws DCanceledException {
        CHPhases.checkInput(input);
        monitor.subTask("Reading file");
        CHRoot root = null;
        CHConfig config = input.getConfig();
        if (input.getComponent() != null) {
            root = CHPhases.makeSubDiagram(input, monitor);
        } else {
            try {
                root = CHXMLParser.parse(input.getFile(), input, monitor);
                CHUtils.applyFilters(root, config, monitor);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (root == null || root == CHRoot.DUMMY_ROOT) {
            throw new DMessageException("Could not generate diagram!");
        }
        KNode result = null;
        try {
            BreadcrumbInput configBCInput = config.getBreadcrumbInput();
            if (configBCInput == null) {
                CHPhases.setBCInput(input, root, config);
            }
            result = CHDiagramImporter.INSTANCE.toKLay(root, config, monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (result == null) {
            throw new DMessageException("Could not generate diagram!");
        }
        return result;
    }

    private static void setBCInput(CHDiagram input, CHRoot root, CHConfig config) {
        if (input == null || root == null || config == null) {
            return;
        }
        IProject project = input.getProject();
        if (project == null) {
            return;
        }
        ArrayList<BreadcrumbSegment> bcSegments = new ArrayList<BreadcrumbSegment>(1);
        CHUVMComponent uvmComponent = root.getUVMComponent();
        if (uvmComponent == null) {
            return;
        }
        bcSegments.add(new BreadcrumbSegment(uvmComponent));
        config.setBreadcrumbInput(new BreadcrumbInput(project, bcSegments, BreadcrumbSerializerRepo.getSerializer(LanguageKind.VLOG, DummyBreadcrumbSerializer.class)));
    }
}

