/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.draw;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.krendering.KBackground;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KColoring;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KFontName;
import de.cau.cs.kieler.core.krendering.KFontSize;
import de.cau.cs.kieler.core.krendering.KForeground;
import de.cau.cs.kieler.core.krendering.KLineStyle;
import de.cau.cs.kieler.core.krendering.KLineWidth;
import de.cau.cs.kieler.core.krendering.KRectangle;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KRoundedRectangle;
import de.cau.cs.kieler.core.krendering.KStyle;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeType;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDContainer;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDEdge;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDLabel;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDObject;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDPort;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDScene;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.utils.CHAdapters;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionBackground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionForeground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionLineWidth;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FRectangle;
import ro.amiq.dvt.draw.utils.FontFactory;

public enum CHDrawConverter {
    INSTANCE;

    private static final DProperties.Key<FRectangle> FLOAT_LAYOUT;
    private static final DProperties.Key<List<CHDObject>> CHILDREN;

    static {
        FLOAT_LAYOUT = new DProperties.Key("CHDrawConverter.FLOAT_LAYOUT");
        CHILDREN = new DProperties.Key("CHDrawConverter.CHILDREN");
    }

    public CHDScene convert(KNode kRoot, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        KShapeLayout kLayout = (KShapeLayout)kRoot.getData(KShapeLayout.class);
        Rectangle bounds = new Rectangle(0, 0, Math.round(kLayout.getWidth()), Math.round(kLayout.getHeight()));
        CHDScene dScene = new CHDScene(kRoot, bounds);
        this.registerDObject(dScene, (KGraphElement)kRoot, null, dScene);
        dScene.setProperty(FLOAT_LAYOUT, new FRectangle(kLayout.getXpos(), kLayout.getYpos(), kLayout.getWidth(), kLayout.getHeight()));
        this.convertKNodes((List<KNode>)kRoot.getChildren(), dScene, monitor);
        this.adjustDEdges(dScene);
        this.forgeCHObjects(dScene);
        return dScene;
    }

    private void forgeCHObjects(CHDObject dObject) {
        dObject.forge();
        List<CHDObject> dChildren = dObject.getProperty(CHILDREN);
        dObject.removeProperty(CHILDREN);
        dObject.removeProperty(FLOAT_LAYOUT);
        if (dChildren != null) {
            dChildren.sort(CHDObject.COMPARATOR);
            dObject.addChildren(dChildren);
            for (CHDObject dChild : dChildren) {
                this.forgeCHObjects(dChild);
            }
        }
    }

    private void convertKNodes(List<KNode> kNodes, CHDScene dScene, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        for (KNode kNode : kNodes) {
            CHDContainer dContainer = this.registerDObject(new CHDContainer(), (KGraphElement)kNode, (KGraphElement)kNode.getParent(), dScene);
            this.setLayoutProperties((KGraphElement)kNode, (KGraphElement)kNode.getParent(), dContainer, dScene);
            this.setRenderingProperties((KGraphElement)kNode, dContainer);
            this.convertKNodes((List<KNode>)kNode.getChildren(), dScene, monitor);
            this.convertKLabels((List<KLabel>)kNode.getLabels(), dScene);
            this.convertKEdges((List<KEdge>)kNode.getOutgoingEdges(), dScene);
            this.convertKPorts((List<KPort>)kNode.getPorts(), dScene);
        }
    }

    private void convertKPorts(List<KPort> kPorts, CHDScene dScene) {
        for (KPort kPort : kPorts) {
            CHDPort dPort = this.registerDObject(new CHDPort(), (KGraphElement)kPort, (KGraphElement)kPort.getNode(), dScene);
            this.setLayoutProperties((KGraphElement)kPort, (KGraphElement)kPort.getNode(), dPort, dScene);
            this.setRenderingProperties((KGraphElement)kPort, dPort);
            this.setPortDirection(kPort, dPort);
            CHPort chPort = (CHPort)CHAdapters.getCHObjectFromKElement((KGraphElement)kPort);
            if (chPort.isSelected()) {
                dPort.setFocused(CHDPort.CHDPortFlags.IS_FOCUSED);
            }
            this.convertKPortsLabels(dScene, kPort, dPort);
        }
    }

    private void convertKPortsLabels(CHDScene dScene, KPort kPort, CHDPort dPort) {
        HashSet<CHDLabel.CHDSelectableLabel> associatedLabels = new HashSet<CHDLabel.CHDSelectableLabel>();
        for (KLabel kLabel : kPort.getLabels()) {
            KLabeledGraphElement kParent = kLabel.getParent();
            CHDLabel.CHDSelectableLabel dLabel = this.registerDObject(new CHDLabel.CHDSelectableLabel(), (KGraphElement)kLabel, (KGraphElement)kParent, dScene);
            this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kLabel.getParent(), dLabel, dScene);
            this.setTextProperties(kLabel, dLabel);
            dLabel.setPort(dPort);
            dLabel.setProperty(CHDLabel.TEXT, kLabel.getText());
            associatedLabels.add(dLabel);
            dLabel.setAssociatedLabels(associatedLabels);
        }
    }

    private void setPortDirection(KPort kPort, CHDPort dPort) {
        CHPort chPort = CHAdapters.getCHObjectFromKElement((KGraphElement)kPort, CHPort.class);
        CHDPort.Type dPortType = CHDPort.Type.RECTANGLE;
        switch (chPort.getKind()) {
            case PORT: {
                dPortType = CHDPort.Type.RECTANGLE;
                break;
            }
            case EXPORT: 
            case IMPLEMENTATION: {
                dPortType = CHDPort.Type.CIRCLE;
                break;
            }
            case INTERFACE: {
                dPortType = CHDPort.Type.BAR;
                break;
            }
            default: {
                dPortType = CHDPort.Type.CROSS;
            }
        }
        dPort.setProperty(CHDPort.TYPE, dPortType);
    }

    private void convertKEdges(List<KEdge> kEdges, CHDScene dScene) {
        for (KEdge kEdge : kEdges) {
            KNode kContainerParent = this.findEdgeContainerParent(kEdge.getSource(), kEdge.getTarget());
            CHDEdge dEdge = this.registerDObject(new CHDEdge(), (KGraphElement)kEdge, (KGraphElement)kContainerParent, dScene);
            this.setRenderingProperties((KGraphElement)kEdge, dEdge);
            KNode kLayoutParent = this.findEdgeLayoutParent(kEdge.getSource(), kEdge.getTarget());
            CHDObject dLayoutParent = dScene.getDObject((KGraphElement)kLayoutParent);
            FRectangle floatLayout = dLayoutParent.getProperty(FLOAT_LAYOUT);
            dEdge.setProperty(CHDEdge.TYPE, CHDEdge.Type.NONE);
            KEdgeLayout kEdgeLayout = (KEdgeLayout)kEdge.getData(KEdgeLayout.class);
            ArrayList<Point> dBendingPoints = new ArrayList<Point>();
            KVectorChain kEdgePoints = kEdgeLayout.createVectorChain();
            for (KVector kPoint : kEdgePoints) {
                dBendingPoints.add(floatLayout.relativeRound((float)kPoint.x, (float)kPoint.y));
            }
            dEdge.setProperty(CHDEdge.BENDING_POINTS, dBendingPoints);
            ArrayList<Point> dJunctionPoints = new ArrayList<Point>();
            KVectorChain kJunctionPoints = (KVectorChain)kEdgeLayout.getProperty(LayoutOptions.JUNCTION_POINTS);
            for (KVector kPoint : kJunctionPoints) {
                dJunctionPoints.add(floatLayout.relativeRound((float)kPoint.x, (float)kPoint.y));
            }
            dEdge.setProperty(CHDEdge.JUNCTION_POINTS, dJunctionPoints);
            for (KLabel kLabel : kEdge.getLabels()) {
                CHDLabel.CHDSelectableLabel dLabel = this.registerDObject(new CHDLabel.CHDSelectableLabel(), (KGraphElement)kLabel, (KGraphElement)kLayoutParent, dScene);
                this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kLayoutParent, dLabel, dScene);
                this.setTextProperties(kLabel, dLabel);
                dLabel.setProperty(CHDLabel.TEXT, kLabel.getText());
                dLabel.setEdge(dEdge);
                dEdge.setLabel(dLabel);
            }
        }
    }

    private KNode findEdgeContainerParent(KNode kNode1, KNode kNode2) {
        if (kNode1 == null || kNode2 == null) {
            return null;
        }
        if (kNode1.equals(kNode2)) {
            return kNode1;
        }
        HashSet<KNode> parents = new HashSet<KNode>();
        do {
            parents.add(kNode1);
        } while ((kNode1 = kNode1.getParent()) != null);
        do {
            if (!parents.contains(kNode2)) continue;
            return kNode2;
        } while ((kNode2 = kNode2.getParent()) != null);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private KNode findEdgeLayoutParent(KNode kNode1, KNode kNode2) {
        if (kNode1 == null || kNode2 == null) {
            return null;
        }
        if (!kNode1.equals(kNode2)) ** GOTO lbl7
        return kNode1.getParent();
lbl-1000:
        // 1 sources

        {
            if (!kNode1.equals(kNode2)) continue;
            return kNode1;
lbl7:
            // 2 sources

            ** while ((kNode2 = kNode2.getParent()) != null)
        }
lbl8:
        // 1 sources

        return kNode1.getParent();
    }

    private void convertKLabels(List<KLabel> kLables, CHDScene dScene) {
        for (KLabel kLabel : kLables) {
            KLabeledGraphElement kParent = kLabel.getParent();
            CHDLabel dLabel = this.registerDObject(new CHDLabel(), (KGraphElement)kLabel, (KGraphElement)kParent, dScene);
            this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kLabel.getParent(), dLabel, dScene);
            this.setTextProperties(kLabel, dLabel);
            dLabel.setProperty(CHDLabel.TEXT, kLabel.getText());
        }
    }

    private void setTextProperties(KLabel kLabel, CHDLabel dLabel) {
        KText kText = (KText)kLabel.getData(KText.class);
        String fontName = null;
        int fontSize = 0;
        int fontStyle = 0;
        EList styles = kText.getStyles();
        for (KStyle kStyle : styles) {
            if (kStyle instanceof KFontName) {
                fontName = ((KFontName)kStyle).getName();
                continue;
            }
            if (kStyle instanceof KFontSize) {
                fontSize = ((KFontSize)kStyle).getSize();
                continue;
            }
            if (kStyle instanceof KFontBold && ((KFontBold)kStyle).isBold()) {
                fontStyle |= 1;
                continue;
            }
            if (kStyle instanceof KFontItalic && ((KFontItalic)kStyle).isItalic()) {
                fontStyle |= 2;
                continue;
            }
            if (kStyle instanceof KForeground) {
                dLabel.setProperty(CHDObject.LINE_COLOR, this.convertKColoring((KColoring<?>)((KForeground)kStyle)));
                continue;
            }
            if (!(kStyle instanceof KSelectionForeground)) continue;
            dLabel.setProperty(CHDLabel.SELECTED_LINE_COLOR, this.convertKColoring((KSelectionForeground)kStyle));
        }
        dLabel.setProperty(CHDLabel.FONT, FontFactory.getInstance().getFontData(fontName, fontSize, fontStyle));
    }

    private <T extends CHDObject> T registerDObject(T dObject, KGraphElement kElement, KGraphElement kParent, CHDScene dScene) {
        ((CHDObject)dObject).setProperty(CHDObject.KELEMENT, (KGraphElement)kElement);
        dScene.putDObject(kElement, (CHDObject)dObject);
        CHDObject dParent = dScene.getDObject(kParent);
        if (dParent != null) {
            List<CHDObject> children = dParent.getProperty(CHILDREN);
            if (children == null) {
                children = new ArrayList<CHDObject>();
                dParent.setProperty(CHILDREN, children);
            }
            children.add((CHDObject)dObject);
        }
        return (T)dObject;
    }

    private void setLayoutProperties(KGraphElement kElement, KGraphElement kParent, CHDObject dObject, CHDScene dScene) {
        CHDObject dParent = dScene.getDObject(kParent);
        FRectangle parentLayout = null;
        parentLayout = dParent == null ? new FRectangle(0.0f, 0.0f, 0.0f, 0.0f) : dParent.getProperty(FLOAT_LAYOUT);
        KShapeLayout kLayout = (KShapeLayout)kElement.getData(KShapeLayout.class);
        FRectangle currentLayout = parentLayout.relative(kLayout.getXpos(), kLayout.getYpos(), kLayout.getWidth(), kLayout.getHeight());
        dObject.setProperty(FLOAT_LAYOUT, currentLayout);
        dObject.setProperty(CHDObject.LAYOUT, currentLayout.round());
    }

    private void setRenderingProperties(KGraphElement kElement, CHDObject dObject) {
        KRendering kRendering = (KRendering)kElement.getData(KRendering.class);
        if (kRendering instanceof KRectangle) {
            dObject.setProperty(CHDContainer.ROUNDED, false);
        } else if (kRendering instanceof KRoundedRectangle) {
            dObject.setProperty(CHDContainer.ROUNDED, true);
        }
        EList kStyles = kRendering.getStyles();
        for (KStyle kStyle : kStyles) {
            if (kStyle instanceof KSelectionBackground) {
                dObject.setProperty(CHDObject.SELECTED_FILL_COLOR, this.convertKColoring((KSelectionBackground)kStyle));
                continue;
            }
            if (kStyle instanceof KBackground) {
                dObject.setProperty(CHDObject.FILL_COLOR, this.convertKColoring((KColoring<?>)((KBackground)kStyle)));
                continue;
            }
            if (kStyle instanceof KSelectionForeground) {
                dObject.setProperty(CHDObject.SELECTED_LINE_COLOR, this.convertKColoring((KSelectionForeground)kStyle));
                continue;
            }
            if (kStyle instanceof KForeground) {
                dObject.setProperty(CHDObject.LINE_COLOR, this.convertKColoring((KColoring<?>)((KForeground)kStyle)));
                continue;
            }
            if (kStyle instanceof KSelectionLineWidth) {
                dObject.setProperty(CHDObject.SELECTED_LINE_WIDTH, Math.round(((KSelectionLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (kStyle instanceof KLineWidth) {
                dObject.setProperty(CHDObject.LINE_WIDTH, Math.round(((KLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (!(kStyle instanceof KLineStyle)) continue;
            dObject.setProperty(CHDObject.LINE_STYLE, this.convertKLineStyle(((KLineStyle)kStyle).getLineStyle()));
        }
    }

    private RGBV convertKColoring(KColoring<?> kColoring) {
        KColor color = kColoring.getColor();
        return ColorFactory.getInstance().getRGBV(color.getRed(), color.getGreen(), color.getBlue(), kColoring.getAlpha() > 0);
    }

    private int convertKLineStyle(LineStyle kStyle) {
        if (kStyle == LineStyle.SOLID) {
            return 1;
        }
        if (kStyle == LineStyle.DASH) {
            return 2;
        }
        if (kStyle == LineStyle.DASHDOT) {
            return 4;
        }
        if (kStyle == LineStyle.DASHDOTDOT) {
            return 5;
        }
        if (kStyle == LineStyle.DOT) {
            return 3;
        }
        return 1;
    }

    private void adjustDEdges(CHDScene dScene) {
        for (Map.Entry<KGraphElement, CHDObject> entry : dScene.getKDEntries()) {
            CHDEdge.Type type;
            KEdge kEdge;
            KEdgeLayout data;
            if (!(entry.getKey() instanceof KEdge) || (data = (KEdgeLayout)(kEdge = (KEdge)entry.getKey()).getData(KEdgeLayout.class)) != null && data.getProperty(LayoutOptions.EDGE_TYPE) == EdgeType.NONE) continue;
            List<Point> dBendingPoints = entry.getValue().getProperty(CHDEdge.BENDING_POINTS);
            this.trimEdgeEnd(dBendingPoints.get(0), dBendingPoints.get(1), dScene.getDObject((KGraphElement)kEdge.getSourcePort()).getProperty(CHDObject.LAYOUT), (type = entry.getValue().getProperty(CHDEdge.TYPE)) == CHDEdge.Type.UNDIRECTED);
            this.trimEdgeEnd(dBendingPoints.get(dBendingPoints.size() - 1), dBendingPoints.get(dBendingPoints.size() - 2), dScene.getDObject((KGraphElement)kEdge.getTargetPort()).getProperty(CHDObject.LAYOUT), type == CHDEdge.Type.DIRECTED || type == CHDEdge.Type.UNDIRECTED);
        }
    }

    private void trimEdgeEnd(Point edgeP1, Point edgeP2, Rectangle portLayout, boolean hasArrow) {
        if (edgeP1.x >= portLayout.x && edgeP1.x <= portLayout.x + portLayout.width) {
            edgeP1.x = edgeP2.x > edgeP1.x ? portLayout.x + portLayout.width + 1 + (hasArrow ? 3 : 0) : portLayout.x - 1 - (hasArrow ? 3 : 0);
        }
    }
}

