/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDLabel;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDObject;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DHeadClosedArrow;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DOval;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class CHDEdge
extends CHDObject
implements DSelectable {
    public static final DProperties.Key<List<Point>> BENDING_POINTS = new DProperties.Key("CHDEdge.BENDING_POINTS");
    public static final DProperties.Key<List<Point>> JUNCTION_POINTS = new DProperties.Key("CHDEdge.JUNCTION_POINTS");
    public static final DProperties.Key<Integer> SOURCE_ARROW_SIZE = new DProperties.Key("CHDEdge.SOURCE_ARROW_SIZE");
    public static final DProperties.Key<Integer> TARGET_ARROW_SIZE = new DProperties.Key("CHDEdge.TARGET_ARROW_SIZE");
    public static final DProperties.Key<Type> TYPE = new DProperties.Key("CHDEdge.TYPE");
    private static final int JUNCTION_SIZE = 4;
    private DLine line;
    private List<DHeadClosedArrow> arrowHeads;
    private List<DOval> junctionCircles;
    private CHDLabel.CHDSelectableLabel label;

    public void setLabel(CHDLabel.CHDSelectableLabel label) {
        this.label = label;
    }

    public CHDLabel.CHDSelectableLabel getLabel() {
        return this.label;
    }

    @Override
    public void forge() {
        int y2;
        int x2;
        int y1;
        int x1;
        List<Point> bendingPoints = this.getProperty(BENDING_POINTS);
        this.line = new DLine(bendingPoints);
        this.line.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
        this.line.setLineStyle((Integer)this.getProperty(LINE_STYLE));
        this.line.setLineCap(3);
        this.addChild(this.line);
        this.arrowHeads = new ArrayList<DHeadClosedArrow>();
        Type type = this.getProperty(TYPE);
        if (type == Type.DIRECTED || type == Type.UNDIRECTED) {
            x1 = bendingPoints.get((int)(bendingPoints.size() - 1)).x;
            y1 = bendingPoints.get((int)(bendingPoints.size() - 1)).y;
            x2 = bendingPoints.get((int)(bendingPoints.size() - 2)).x;
            y2 = bendingPoints.get((int)(bendingPoints.size() - 2)).y;
            this.arrowHeads.add(new DHeadClosedArrow(this.getProperty(TARGET_ARROW_SIZE), x1 + 3 * Integer.signum(x1 - x2), y1, x2, y2));
        }
        if (type == Type.UNDIRECTED) {
            x1 = bendingPoints.get((int)0).x;
            y1 = bendingPoints.get((int)0).y;
            x2 = bendingPoints.get((int)1).x;
            y2 = bendingPoints.get((int)1).y;
            this.arrowHeads.add(new DHeadClosedArrow(this.getProperty(SOURCE_ARROW_SIZE), x1 + 3 * Integer.signum(x1 - x2), y1, x2, y2));
        }
        this.addChildren(this.arrowHeads);
        this.junctionCircles = new ArrayList<DOval>();
        List<Point> junctionPoints = this.getProperty(JUNCTION_POINTS);
        for (Point junctionPoint : junctionPoints) {
            this.junctionCircles.add(new DOval(4, junctionPoint));
        }
        this.addChildren(this.junctionCircles);
        this.select(false, "MAIN_SELECTION");
    }

    @Override
    public void select(boolean selected, String type) {
        RGBV lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
        int lineWidth = selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue();
        this.line.setLineColor(lineColor);
        this.line.setLineWidth(lineWidth);
        for (DHeadClosedArrow arrowHead : this.arrowHeads) {
            arrowHead.setLineColor(lineColor);
            arrowHead.setFillColor(lineColor);
            arrowHead.setLineWidth(lineWidth);
        }
        for (DOval junctionCircle : this.junctionCircles) {
            junctionCircle.setLineColor(lineColor);
            junctionCircle.setFillColor(lineColor);
            junctionCircle.setLineWidth(lineWidth);
        }
    }

    @Override
    public List<DObject> getSelectedObjects() {
        ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
        selectedObjects.add(this.line);
        selectedObjects.addAll(this.arrowHeads);
        selectedObjects.addAll(this.junctionCircles);
        return selectedObjects;
    }

    public static enum Type {
        NONE,
        DIRECTED,
        UNDIRECTED;

    }
}

