/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.draw.obj;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDEdge;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDObject;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDPort;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSearchable;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class CHDLabel
extends CHDObject
implements DSearchable {
    public static final DProperties.Key<FontData> FONT = new DProperties.Key("CHDLabel.FONT");
    public static final DProperties.Key<String> TEXT = new DProperties.Key("CHDLabel.TEXT");
    protected DText text;

    @Override
    public void forge() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        this.text = new DText(this.getProperty(TEXT), layout.x, layout.y, layout.width, layout.height, this.getProperty(FONT));
        this.text.setTextColor((RGBV)this.getProperty(LINE_COLOR));
        this.addChild(this.text);
    }

    @Override
    public String getSearchText() {
        return this.getProperty(TEXT);
    }

    @Override
    public void highlightSearchMatch(DSearchable.Highlight highlight) {
        DText text = (DText)this.getChildren().get(0);
        if (highlight == DSearchable.Highlight.NONE) {
            text.setHighlight(-1, -1);
        } else {
            text.setHighlightColor(highlight.getColor());
            text.setHighlight(1, this.getProperty(TEXT).length() - 1);
        }
    }

    @Override
    public String shortValueString() {
        return this.getProperty(TEXT);
    }

    public static class CHDSelectableLabel
    extends CHDLabel
    implements DSelectable {
        private CHDEdge edge;
        private CHDPort port;
        private Set<CHDSelectableLabel> associatedLabels;

        public void setEdge(CHDEdge edge) {
            this.edge = edge;
        }

        public CHDEdge getEdge() {
            return this.edge;
        }

        public void setPort(CHDPort port) {
            this.port = port;
        }

        public CHDPort getPort() {
            return this.port;
        }

        public Set<CHDSelectableLabel> getAssociatedLabels() {
            return this.associatedLabels;
        }

        public void setAssociatedLabels(Set<CHDSelectableLabel> associatedLabels) {
            this.associatedLabels = associatedLabels;
        }

        @Override
        public void select(boolean selected, String type) {
            RGBV lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            this.text.setTextColor(lineColor);
        }

        @Override
        public List<DObject> getSelectedObjects() {
            ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
            selectedObjects.add(this.text);
            return selectedObjects;
        }
    }
}

