/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.draw.obj;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import java.util.Comparator;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDContainer;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDEdge;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDLabel;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDPort;
import ro.amiq.dvt.diagrams.ch.utils.CHAdapters;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public abstract class CHDObject
extends DGroup {
    public static final Comparator<CHDObject> COMPARATOR = new Comparator<CHDObject>(){

        @Override
        public int compare(CHDObject o1, CHDObject o2) {
            return Integer.compare(this.position(o1), this.position(o2));
        }

        private int position(CHDObject o) {
            if (o == null) {
                return -1;
            }
            if (o instanceof CHDContainer) {
                return 1;
            }
            if (o instanceof CHDLabel) {
                return 2;
            }
            if (o instanceof CHDEdge) {
                return 3;
            }
            if (o instanceof CHDPort) {
                return 4;
            }
            return 0;
        }
    };
    public static final DProperties.Key<KGraphElement> KELEMENT = new DProperties.Key("CHDObject.KELEMENT");
    public static final DProperties.Key<Rectangle> LAYOUT = new DProperties.Key("CHDObject.LAYOUT");
    public static final DProperties.Key<RGBV> LINE_COLOR = new DProperties.Key("CHDObject.LINE_COLOR");
    public static final DProperties.Key<RGBV> SELECTED_LINE_COLOR = new DProperties.Key("CHDObject.SELECTED_LINE_COLOR");
    public static final DProperties.Key<RGBV> FILL_COLOR = new DProperties.Key("CHDObject.FILL_COLOR");
    public static final DProperties.Key<RGBV> SELECTED_FILL_COLOR = new DProperties.Key("CHDObject.SELECTED_FILL_COLOR");
    public static final DProperties.Key<Integer> LINE_WIDTH = new DProperties.Key("CHDObject.LINE_WIDTH");
    public static final DProperties.Key<Integer> SELECTED_LINE_WIDTH = new DProperties.Key("CHDObject.SELECTED_LINE_WIDTH");
    public static final DProperties.Key<Integer> LINE_STYLE = new DProperties.Key("CHDObject.LINE_STYLE");
    private final DProperties properties = new DProperties();

    public CHDObject(String name) {
        super(name);
    }

    public CHDObject() {
    }

    public <T> T getProperty(DProperties.Key<T> key) {
        return this.properties.get(key);
    }

    public <T> void removeProperty(DProperties.Key<T> key) {
        this.properties.remove(key);
    }

    public <T> void setProperty(DProperties.Key<T> key, T value) {
        this.properties.put(key, value);
    }

    public abstract void forge();

    @Override
    public String shortValueString() {
        return CHAdapters.getCHNameFromCHDObject(this);
    }

    @Override
    public String longValueString() {
        return this.properties.toString();
    }
}

