/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDObject;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DOval;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class CHDPort
extends CHDObject
implements DSelectable {
    public static final DProperties.Key<Type> TYPE = new DProperties.Key("CHDPort.TYPE");
    private DOval oval;
    private DRectangle rectangle;
    private DRectangle bar;
    private DLine line1;
    private DLine line2;
    private CHDPortFlags isFocused;

    @Override
    public void forge() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        Type type = this.getProperty(TYPE);
        if (type == Type.CIRCLE) {
            this.oval = new DOval(layout.x, layout.y, layout.width, layout.height);
            this.oval.setFillColor((RGBV)this.getProperty(FILL_COLOR));
            this.oval.setLineColor((RGBV)this.getProperty(LINE_COLOR));
            this.addChild(this.oval);
        } else {
            this.rectangle = new DRectangle(layout.x, layout.y, layout.width, layout.height);
            this.rectangle.setFillColor((RGBV)this.getProperty(FILL_COLOR));
            this.rectangle.setLineColor((RGBV)this.getProperty(LINE_COLOR));
            this.addChild(this.rectangle);
            if (type == Type.BAR) {
                int barHeight = layout.height / 3;
                int barOffset = (layout.height - barHeight) / 2;
                this.bar = new DRectangle(layout.x + 1, layout.y + barOffset, layout.width - 2, barHeight);
                this.bar.setLineColor((RGBV)this.getProperty(LINE_COLOR));
                this.bar.setFillColor((RGBV)this.getProperty(LINE_COLOR));
                this.addChild(this.bar);
            } else if (type == Type.CROSS) {
                this.line1 = new DLine(new int[]{layout.x + 1, layout.y + 1, layout.x + layout.width - 1, layout.y + layout.height - 1});
                this.line1.setLineColor((RGBV)this.getProperty(LINE_COLOR));
                this.addChild(this.line1);
                this.line2 = new DLine(new int[]{layout.x + layout.width - 1, layout.y + 1, layout.x + 1, layout.y + layout.height - 1});
                this.line2.setLineColor((RGBV)this.getProperty(LINE_COLOR));
                this.addChild(this.line2);
            }
        }
    }

    @Override
    public void select(boolean selected, String type) {
        RGBV lineColor;
        RGBV rGBV = lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
        if (this.oval != null) {
            this.oval.setLineColor(lineColor);
        }
        if (this.rectangle != null) {
            this.rectangle.setLineColor(lineColor);
        }
        if (this.bar != null) {
            this.bar.setLineColor(lineColor);
        }
        if (this.line1 != null) {
            this.line1.setLineColor(lineColor);
        }
        if (this.line2 != null) {
            this.line2.setLineColor(lineColor);
        }
    }

    @Override
    public List<DObject> getSelectedObjects() {
        ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
        selectedObjects.add(this.oval);
        selectedObjects.add(this.rectangle);
        selectedObjects.add(this.bar);
        selectedObjects.add(this.line1);
        selectedObjects.add(this.line2);
        return selectedObjects;
    }

    public CHDPortFlags isFocused() {
        return this.isFocused;
    }

    public void setFocused(CHDPortFlags isFocused) {
        this.isFocused = isFocused;
    }

    public static enum CHDPortFlags {
        IS_FOCUSED;

    }

    public static enum Type {
        CIRCLE,
        RECTANGLE,
        BAR,
        CROSS;

    }
}

