/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDContainer;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDEdge;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDLabel;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDObject;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDPort;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDScene;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHGoToInstanceAction;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHGoToTypeAction;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHShowConnectionsAction;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHShowDesignDiagramAction;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHShowDestinationsAction;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHShowSourcesAction;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHStepIntoAction;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHStepOutAction;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHDesign;
import ro.amiq.dvt.diagrams.ch.model.CHInterface;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.utils.CHAdapters;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.editor.DMenuSeparator;
import ro.amiq.dvt.diagrams.editor.DSelectionContributor;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class CHEditorContributorsCommon {
    public static List<DMenuItem> getMenuItems(DDiagramEditor diagramEditor, Set<DSelectable> selection) {
        DDiagram diagram = diagramEditor.getInput().getDiagram();
        ArrayList<DMenuItem> actions = new ArrayList<DMenuItem>();
        LinkedHashSet<GoToInfo> typeMarkers = new LinkedHashSet<GoToInfo>(4);
        LinkedHashSet<GoToInfo> instanceMarkers = new LinkedHashSet<GoToInfo>(4);
        boolean isInstance = false;
        if (diagram == null) {
            return Collections.emptyList();
        }
        for (DSelectable selectable : selection) {
            CHPort chPort;
            CHConnection connection = null;
            if (selectable instanceof CHDEdge) {
                connection = CHAdapters.getCHObjectFromCHDObject((CHDObject)((Object)selectable), CHConnection.class);
            } else if (selectable instanceof CHDLabel.CHDSelectableLabel && ((CHDLabel.CHDSelectableLabel)selectable).getEdge() != null) {
                connection = CHAdapters.getCHObjectFromCHDObject(((CHDLabel.CHDSelectableLabel)selectable).getEdge(), CHConnection.class);
            }
            if (connection != null) {
                if (connection.getTypeMarker() == null) continue;
                typeMarkers.add(connection.getTypeMarker());
                continue;
            }
            if (selectable instanceof CHDContainer) {
                GoToInfo instanceMarker;
                CHContainer container = CHAdapters.getCHObjectFromCHDObject((CHDContainer)selectable, CHUVMComponent.class);
                if (container == null) {
                    container = CHAdapters.getCHObjectFromCHDObject((CHDContainer)selectable, CHDesign.class);
                    continue;
                }
                IDVTElementWrapper wrapper = container.getWrapper();
                if (wrapper != null) {
                    Object wrapperElement = wrapper.getRfElement();
                    if (wrapperElement instanceof IRfInstanceElement) {
                        isInstance = true;
                    } else if (wrapperElement instanceof IRfDesignElement) {
                        TreePath treePath = TreePath.of(null, container.getPath().split("\\."), null);
                        treePath.setElement(wrapperElement);
                        wrapper.setAdditionalInfo(IDVTElementWrapper.Attribute.TREE_PATH, treePath);
                        actions.add(new DCHShowDesignDiagramAction(diagram, wrapper));
                    }
                }
                if (!(container instanceof CHUVMComponent)) continue;
                GoToInfo typeMarker = ((CHUVMComponent)container).getTypeMarker();
                if (typeMarker != null) {
                    typeMarkers.add(typeMarker);
                }
                if ((instanceMarker = ((CHUVMComponent)container).getInstanceMarker()) == null) continue;
                instanceMarkers.add(instanceMarker);
                continue;
            }
            if (!(selectable instanceof CHDLabel.CHDSelectableLabel) || (chPort = CHAdapters.getCHObjectFromCHDObject(((CHDLabel.CHDSelectableLabel)selectable).getPort(), CHPort.class)) == null || !(chPort instanceof CHInterface)) continue;
            CHInterface interfacePort = (CHInterface)chPort;
            if (interfacePort != null) {
                typeMarkers.add(interfacePort.getTypeMarker());
                actions.add(new DCHGoToTypeAction(diagram, typeMarkers));
            }
            return actions;
        }
        if (selection.size() == 1) {
            DCHStepOutAction stepOut;
            DCHStepIntoAction stepIn = new DCHStepIntoAction(diagram, selection);
            if (stepIn.isVisible()) {
                actions.add(stepIn);
                if (!typeMarkers.isEmpty() || !instanceMarkers.isEmpty()) {
                    actions.add(DMenuSeparator.INSTANCE);
                }
            }
            if ((stepOut = new DCHStepOutAction(diagram, selection)).isVisible()) {
                actions.add(stepOut);
                if (!typeMarkers.isEmpty() || !instanceMarkers.isEmpty()) {
                    actions.add(DMenuSeparator.INSTANCE);
                }
            }
        }
        if (selection.size() == 2) {
            DCHShowConnectionsAction showConnectionsAction;
            DCHShowSourcesAction showSourcesAction;
            DCHShowDestinationsAction showDestinationsAction = new DCHShowDestinationsAction(diagram, selection);
            if (showDestinationsAction.isVisible()) {
                actions.add(showDestinationsAction);
            }
            if ((showSourcesAction = new DCHShowSourcesAction(diagram, selection)).isVisible()) {
                actions.add(showSourcesAction);
            }
            if (showDestinationsAction.isVisible() || showSourcesAction.isVisible()) {
                actions.add(DMenuSeparator.INSTANCE);
            }
            if ((showConnectionsAction = new DCHShowConnectionsAction(diagram, selection)).isVisible()) {
                actions.add(showConnectionsAction);
            }
        }
        if (!typeMarkers.isEmpty()) {
            actions.add(new DCHGoToTypeAction(diagram, typeMarkers));
        }
        if (!instanceMarkers.isEmpty()) {
            actions.add(new DCHGoToInstanceAction(diagram, instanceMarkers, isInstance));
        }
        return actions;
    }

    public static Map<String, Set<DSelectable>> getSelectedObjects(DDiagramEditor diagramEditor, DSelectable object) {
        CHConnection connection;
        DObject content = diagramEditor.getCanvas().getContent();
        HashSet<DSelectable> selectables = new HashSet<DSelectable>();
        if (object instanceof CHDLabel.CHDSelectableLabel && ((CHDLabel.CHDSelectableLabel)object).getEdge() != null) {
            selectables.add(object);
            object = ((CHDLabel.CHDSelectableLabel)object).getEdge();
        }
        if (object == null) {
            return DSelectionContributor.createMainSelection(selectables);
        }
        if (content instanceof CHDScene && object instanceof CHDEdge && (connection = CHAdapters.getCHObjectFromCHDObject((CHDEdge)object, CHConnection.class)) != null) {
            HashSet<CHConnection> connections = new HashSet<CHConnection>();
            connections.addAll(connection.getSource().getConnections());
            for (CHConnection connect : new HashSet(connections)) {
                connections.addAll(connect.getDestination().getConnections());
                connections.addAll(connect.getSource().getConnections());
            }
            for (CHConnection conn : connections) {
                CHDEdge dEdge = (CHDEdge)CHAdapters.getCHDObjectFromCHObject((CHDScene)content, conn);
                if (dEdge == null) continue;
                selectables.add(dEdge);
                if (dEdge.getLabel() == null) continue;
                selectables.add(dEdge.getLabel());
            }
            if (selectables.isEmpty()) {
                selectables.add(object);
            }
            return DSelectionContributor.createMainSelection(selectables);
        }
        if (object instanceof CHDLabel.CHDSelectableLabel && ((CHDLabel.CHDSelectableLabel)object).getPort() != null) {
            CHDLabel.CHDSelectableLabel selectableLabel = (CHDLabel.CHDSelectableLabel)object;
            Set<CHDLabel.CHDSelectableLabel> associatedSelectableLabels = selectableLabel.getAssociatedLabels();
            selectables.addAll(associatedSelectableLabels);
            return DSelectionContributor.createMainSelection(selectables);
        }
        return DSelectionContributor.createMainSelection(object);
    }

    public static DObject[] getFocusedObjects(DDiagramEditor diagramEditor, DObject content) {
        HashSet<DObject> result = new HashSet<DObject>();
        if (!(content instanceof CHDScene)) {
            return null;
        }
        List<DObject> children = ((CHDScene)content).getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        CHDContainer root = (CHDContainer)children.get(0);
        Set<DObject> focusedObj = CHEditorContributorsCommon.getFocusedObjects(root);
        if (focusedObj != null && !focusedObj.isEmpty()) {
            result.addAll(focusedObj);
        }
        return !result.isEmpty() ? result.toArray(new DObject[result.size()]) : null;
    }

    public static Set<DObject> getFocusedObjects(CHDObject element) {
        List<DObject> children = element.getChildren();
        if (children == null) {
            return null;
        }
        HashSet<DObject> result = new HashSet<DObject>();
        for (DObject dObject : children) {
            CHDPort chdPort;
            Set<DObject> focusedObjects;
            if (dObject instanceof CHDContainer && (focusedObjects = CHEditorContributorsCommon.getFocusedObjects((CHDObject)dObject)) != null) {
                result.addAll(focusedObjects);
            }
            if (!(dObject instanceof CHDPort) || (chdPort = (CHDPort)dObject).isFocused() == null) continue;
            result.add(dObject);
        }
        return result;
    }
}

