/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.editor;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.CHActionDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.ICHModel;
import ro.amiq.dvt.diagrams.ch.editor.CHEditorContributors;
import ro.amiq.dvt.diagrams.ch.editor.CHEditorContributorsCommon;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DCHActionFlags;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorFactory;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DFocusContributor;
import ro.amiq.dvt.diagrams.editor.DMKCContributor;
import ro.amiq.dvt.diagrams.editor.DMenuContributor;
import ro.amiq.dvt.diagrams.editor.DSelectionContributor;
import ro.amiq.dvt.diagrams.editor.DToolbarContributor;
import ro.amiq.dvt.diagrams.editor.DTransitionTableContributor;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;

public class CHEditorFactory
extends DDiagramEditorFactory {
    private CHEditorFactory(DDiagram diagram) {
        this.diagram = diagram;
    }

    public DDiagramEditorInput createEditorInput() {
        return this.createEditorInput(this.diagram);
    }

    public static CHEditorFactory newFileDiagram(IProject project, File file, CHConfig config, int depth) {
        return new CHEditorFactory(new CHDiagram(project, file, config, depth));
    }

    public static CHEditorFactory newComponentDiagram(IDVTElementWrapper wrapper, IProject project, ICHModel model, CHConfig config, int depth, boolean detailedDesign) {
        return new CHEditorFactory(new CHDiagram2(wrapper, project, model, config, depth, detailedDesign));
    }

    public static CHEditorFactory newComponentSubDiagram(ICHDiagram diagram, CHUVMComponent component, CHConfig config, int depth, boolean detailedDesign) {
        ICHDiagram newDiagram = diagram.getCopy(config, depth, detailedDesign);
        newDiagram.setComponent(component);
        return new CHEditorFactory(newDiagram);
    }

    public static CHEditorFactory newComponentActionDiagram(IDVTElementWrapper wrapper, IProject project, ICHModel model, CHConfig config, int depth, CHPort portSelection, ArrayList<CHPort> visibleDestinations, ArrayList<CHPort> visibleSources, DCHActionFlags actionFlags) {
        return new CHEditorFactory(new CHActionDiagram(wrapper, project, model, config, depth, portSelection, visibleDestinations, visibleSources, actionFlags));
    }

    @Override
    public DDiagramEditorInput createEditorInput(DDiagram diagram) {
        DSelectionContributor selectionContributor = CHEditorContributorsCommon::getSelectedObjects;
        DMenuContributor menuContributor = CHEditorContributorsCommon::getMenuItems;
        DFocusContributor miscContributor = CHEditorContributorsCommon::getFocusedObjects;
        DToolbarContributor toolbarContributor = CHEditorContributors::getToolbarActions;
        return new DDiagramEditorInput(diagram, toolbarContributor, menuContributor, selectionContributor, DTransitionTableContributor.EMPTY, DMKCContributor.EMPTY, miscContributor, null);
    }

    public static void refreshCHDiagrams(IWorkbenchWindow window, VerificationHierarchyView view) {
        if (view == null) {
            return;
        }
        IProject project = view.getProject();
        if (project == null) {
            return;
        }
        DDiagramEditor.diagramEditorsAsStream(window).filter(editor -> editor.getInput().getDiagram() instanceof CHDiagram2).forEach(editor -> {
            DDiagram diagram = editor.getInput().getDiagram();
            DDiagram editorDiagram = diagram;
            if (!(editorDiagram instanceof CHDiagram2)) {
                return;
            }
            if (!project.equals((Object)diagram.getProject())) {
                return;
            }
            CHDiagram2 chDiagram = (CHDiagram2)diagram;
            IDVTElementWrapper oldWrapper = chDiagram.getWrapper();
            if (oldWrapper == null) {
                return;
            }
            TreePath oldTreePath = (TreePath)oldWrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
            if (oldTreePath == null) {
                return;
            }
            chDiagram.getNewWrapperFromTreePath(oldTreePath, view);
            Utils.asyncExec(() -> editor.updateEditor());
        });
    }
}

