/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.editor.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.CHActionDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.editor.CHEditorFactory;
import ro.amiq.dvt.diagrams.ch.editor.actions.DCHFiltersContentAssistProvider;
import ro.amiq.dvt.diagrams.ch.editor.actions.DCHFiltersDialogUtils;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.ch.utils.CHFilterSet;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.actions.DFiltersDialogAbstract;
import ro.amiq.dvt.diagrams.filters.DiagramFiltersUtils;

public class DCHFiltersDialog
extends DFiltersDialogAbstract {
    private Button reducePortsCheckbox;
    private Button reduceBlocksCheckbox;
    private static final List<String> PREDEFINED_FILTERS = new ArrayList<String>(Arrays.asList("Driver & Monitor (predefined)"));
    private static final String LINE_REGEX = "(show|hide)\\s+((port(s{0,1})|intance(s{0,1})|transaction type(s{0,1})|type(s{0,1})|port type(s{0,1})){0,1},{0,1} *)*\\s+matching\\s+(\\S+\\s+\\S+)+";
    private static final List<String> KINDS = Arrays.asList("port", "ports", "port type", "port types", "transaction type", "transaction types", "instance", "instances", "type", "types");
    private static final String SYNTAX_TOOLTIP = "Examples:\n\nhide instances matching [regex]\nshow types matching [regex]\ncolor ports, transaction types matching [regex]\ncolor transaction types matching [regex] using blue\ncolor ports matching [regex] using random";

    public DCHFiltersDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location);
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        DDiagram diagram = this.getDiagramEditor().getInput().getDiagram();
        CHConfig config = ((ICHDiagram)diagram).getConfig();
        CHFilterSet currentFilters = null;
        if (config != null) {
            currentFilters = config.getActiveFilters();
        }
        this.filterSets = new LinkedHashMap();
        this.filterSets.put("None", null);
        this.filterSets.putAll(DiagramFiltersUtils.getFiltersBundle("diagramfilters.all_ch_diagram_filters"));
        for (String filterSetName : this.filterSets.keySet()) {
            this.filterSetCombo.add(filterSetName);
        }
        if (currentFilters == null || this.filterSets.get(currentFilters.getName()) == null) {
            this.selectSet("None");
        } else {
            this.selectSet(currentFilters.getName());
        }
    }

    @Override
    public void selectSet(String setName) {
        if (setName == null) {
            return;
        }
        this.currentFiltersName = setName;
        if (this.newSetComposite.isVisible()) {
            this.toggleNewSetComposite();
        }
        if (setName.equals("None")) {
            this.selectNone();
            return;
        }
        this.filterText.setEnabled(true);
        this.filterSetCombo.setText(setName);
        DiagramFiltersUtils.FilterBundle filterBundle = (DiagramFiltersUtils.FilterBundle)this.filterSets.get(setName);
        if (filterBundle == null) {
            return;
        }
        this.filterText.setText(filterBundle.filterSetContents);
        if (PREDEFINED_FILTERS.contains(setName)) {
            this.filterText.setEditable(false);
            if (this.deleteSetButton != null) {
                this.deleteSetButton.setEnabled(false);
            }
            if (this.duplicateSetButton != null) {
                this.duplicateSetButton.setEnabled(true);
            }
            if (this.reducePortsCheckbox != null) {
                this.reducePortsCheckbox.setEnabled(false);
                this.reducePortsCheckbox.setSelection(filterBundle.reducePorts);
            }
            if (this.reduceBlocksCheckbox != null) {
                this.reduceBlocksCheckbox.setEnabled(false);
                this.reduceBlocksCheckbox.setSelection(filterBundle.reduceGates);
            }
        } else {
            this.filterText.setEditable(true);
            if (this.deleteSetButton != null) {
                this.deleteSetButton.setEnabled(true);
            }
            if (this.duplicateSetButton != null) {
                this.duplicateSetButton.setEnabled(true);
            }
            if (this.reducePortsCheckbox != null) {
                this.reducePortsCheckbox.setEnabled(true);
                this.reducePortsCheckbox.setSelection(filterBundle.reducePorts);
            }
            if (this.reduceBlocksCheckbox != null) {
                this.reduceBlocksCheckbox.setEnabled(true);
                this.reduceBlocksCheckbox.setSelection(filterBundle.reduceBlocks);
            }
        }
    }

    @Override
    public void selectNone() {
        this.filterSetCombo.setText("None");
        this.filterText.setText("");
        this.filterText.setEnabled(false);
        DDiagram diagram = this.getDiagramEditor().getInput().getDiagram();
        CHConfig config = ((ICHDiagram)diagram).getConfig();
        if (this.deleteSetButton != null) {
            this.deleteSetButton.setEnabled(false);
        }
        if (this.duplicateSetButton != null) {
            this.duplicateSetButton.setEnabled(false);
        }
        if (this.reducePortsCheckbox != null) {
            this.reducePortsCheckbox.setEnabled(true);
            this.reducePortsCheckbox.setSelection(config != null ? config.configReducePorts() : false);
        }
        if (this.reduceBlocksCheckbox != null) {
            this.reduceBlocksCheckbox.setEnabled(true);
            this.reduceBlocksCheckbox.setSelection(config != null ? config.configReduceBlocks() : false);
        }
    }

    @Override
    public void saveFilters(Map<String, DiagramFiltersUtils.FilterBundle> filterSets) {
        DiagramFiltersUtils.saveFilters(filterSets, "diagramfilters.all_ch_diagram_filters", true);
    }

    @Override
    public void saveSet(String currentFiltersText) {
        if ("None".equals(this.currentFiltersName)) {
            return;
        }
        boolean reducePorts = this.reducePortsCheckbox != null ? this.reducePortsCheckbox.getSelection() : false;
        boolean reduceBlocks = this.reduceBlocksCheckbox != null ? this.reduceBlocksCheckbox.getSelection() : false;
        this.filterSets.put(this.currentFiltersName, new DiagramFiltersUtils.FilterBundle(currentFiltersText, reducePorts, false, reduceBlocks, false));
        this.saveFilters(this.filterSets);
    }

    @Override
    public void openEditor(boolean newEditor) {
        ICHDiagram diagram = (ICHDiagram)this.getDiagramEditor().getInput().getDiagram();
        this.saveSet(this.filterText.getText());
        String selectedFilter = this.filterSetCombo.getText();
        String serializedSelectedFilter = "None".equals(selectedFilter) ? null : ((DiagramFiltersUtils.FilterBundle)this.filterSets.get(selectedFilter)).serializeBundle();
        boolean reducePortsCheckboxSelection = this.reducePortsCheckbox != null ? this.reducePortsCheckbox.getSelection() : false;
        boolean reduceBlocksCheckboxSelection = this.reduceBlocksCheckbox != null ? this.reduceBlocksCheckbox.getSelection() : false;
        CHConfig config = DCHFiltersDialogUtils.INSTANCE.getConfig(diagram.getConfig(), diagram.getLanguageKind(), selectedFilter, serializedSelectedFilter, reducePortsCheckboxSelection, reduceBlocksCheckboxSelection);
        CHEditorFactory chEditorFactory = null;
        if (diagram.getComponent() != null) {
            chEditorFactory = CHEditorFactory.newComponentSubDiagram(diagram, diagram.getComponent(), config, diagram.getDepth(), diagram.isExplicitVifConnections());
        } else if (diagram instanceof CHActionDiagram) {
            CHActionDiagram chActionDiagram = (CHActionDiagram)diagram;
            chEditorFactory = CHEditorFactory.newComponentActionDiagram(chActionDiagram.getWrapper(), diagram.getProject(), chActionDiagram.getModel(), config, chActionDiagram.getDepth(), chActionDiagram.getPortSelection(), chActionDiagram.getVisibleDestinatons(), chActionDiagram.getVisibleSources(), chActionDiagram.getActionFlag());
        } else {
            chEditorFactory = diagram instanceof CHDiagram ? CHEditorFactory.newFileDiagram(diagram.getProject(), ((CHDiagram)diagram).getFile(), config, diagram.getDepth()) : CHEditorFactory.newComponentDiagram(((CHDiagram2)diagram).getWrapper(), diagram.getProject(), ((CHDiagram2)diagram).getModel(), config, diagram.getDepth(), diagram.isExplicitVifConnections());
        }
        this.close();
        if (chEditorFactory != null) {
            if (newEditor) {
                chEditorFactory.openNewEditor();
            } else {
                chEditorFactory.openReuseEditor(this.getDiagramEditor());
            }
        }
    }

    @Override
    public void createAdditionalButtons(Composite composite) {
        this.reducePortsCheckbox = this.createButton(composite, 32, GridDataFactory.fillDefaults().span(5, 1).align(1, 0x1000000).grab(false, false), "Hide unconnected ports", null);
        this.reduceBlocksCheckbox = this.createButton(composite, 32, GridDataFactory.fillDefaults().span(5, 1).align(1, 0x1000000).grab(false, false), "Hide blocks without ports", null);
    }

    @Override
    public IContentProposalProvider getContentProposalProvider() {
        return DCHFiltersContentAssistProvider.getInstance();
    }

    @Override
    public String getTooltipText() {
        return SYNTAX_TOOLTIP;
    }

    @Override
    public String getLineRegex() {
        return LINE_REGEX;
    }

    @Override
    public List<String> getKindNames() {
        return KINDS;
    }
}

