/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.editor.actions;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.CHActionDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.editor.CHEditorFactory;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;

public class DCHPreferencesDialog
extends DEditorDialog {
    private Spinner depthSpinner;
    private Button explicitVifConnectionsCheckbox;
    private LanguageKind languageKind;

    public DCHPreferencesDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, false);
    }

    @Override
    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        final ICHDiagram diagram = (ICHDiagram)this.getDiagramEditor().getInput().getDiagram();
        Label depthLabel = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).applyTo((Control)depthLabel);
        depthLabel.setText("Depth");
        this.depthSpinner = new Spinner(composite, 2048);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).hint(50, -1).grab(false, false).applyTo((Control)this.depthSpinner);
        this.depthSpinner.setTextLimit(3);
        this.depthSpinner.setMinimum(1);
        this.depthSpinner.setMaximum(999);
        this.depthSpinner.setSelection(diagram.getDepth());
        boolean isGeneratedAfterElab = false;
        if (diagram instanceof CHDiagram2 && ((CHDiagram2)diagram).isGeneratedAfterElab()) {
            isGeneratedAfterElab = true;
        }
        this.languageKind = diagram.getLanguageKind();
        if (this.languageKind.equals((Object)LanguageKind.VLOG) && isGeneratedAfterElab) {
            Label explicitVifConnectionsLabel = new Label(composite, 0);
            GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, false).applyTo((Control)explicitVifConnectionsLabel);
            explicitVifConnectionsLabel.setText("Show Explicit Vif Connections");
            this.explicitVifConnectionsCheckbox = new Button(composite, 32);
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)this.explicitVifConnectionsCheckbox);
            this.explicitVifConnectionsCheckbox.setSelection(diagram.isExplicitVifConnections());
            this.explicitVifConnectionsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isChecked = DCHPreferencesDialog.this.explicitVifConnectionsCheckbox.getSelection();
                    DCHPreferencesDialog.this.explicitVifConnectionsCheckbox.setSelection(isChecked);
                    diagram.setExplicitVifConnections(isChecked);
                }
            });
        }
    }

    @Override
    protected void createBottomArea(Composite parent) {
        Composite composite = this.createBottomComposite(parent, 2);
        this.createPreferencesLink("ro.amiq.dvt.diagrams.CHDPreferencePage", composite);
        Composite buttonsComposite = this.createButtonsComposite(composite, 3);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.createButton(buttonsComposite, 8, "New", () -> this.openEditor(true));
        this.createButton(buttonsComposite, 8, "Apply", () -> this.openEditor(false));
    }

    private void openEditor(boolean newEditor) {
        CHEditorFactory chEditorFactory = null;
        ICHDiagram chDiagram = (ICHDiagram)this.getDiagramEditor().getInput().getDiagram();
        if (chDiagram.getComponent() != null) {
            chEditorFactory = CHEditorFactory.newComponentSubDiagram(chDiagram, chDiagram.getComponent(), null, this.depthSpinner.getSelection(), this.languageKind.equals((Object)LanguageKind.VLOG) && this.explicitVifConnectionsCheckbox != null && this.explicitVifConnectionsCheckbox.getSelection());
        } else if (chDiagram instanceof CHDiagram) {
            CHDiagram diagram = (CHDiagram)chDiagram;
            chEditorFactory = CHEditorFactory.newFileDiagram(diagram.getProject(), diagram.getFile(), diagram.getConfig(), this.depthSpinner.getSelection());
        } else if (chDiagram instanceof CHDiagram2) {
            CHDiagram2 diagram = (CHDiagram2)chDiagram;
            chEditorFactory = CHEditorFactory.newComponentDiagram(diagram.getWrapper(), diagram.getProject(), diagram.getModel(), diagram.getConfig(), this.depthSpinner.getSelection(), this.languageKind.equals((Object)LanguageKind.VLOG) && this.explicitVifConnectionsCheckbox != null && this.explicitVifConnectionsCheckbox.getSelection());
        } else if (chDiagram instanceof CHActionDiagram) {
            CHActionDiagram diagram = (CHActionDiagram)chDiagram;
            chEditorFactory = CHEditorFactory.newComponentActionDiagram(diagram.getWrapper(), diagram.getProject(), diagram.getModel(), diagram.getConfig(), this.depthSpinner.getSelection(), diagram.getPortSelection(), diagram.getVisibleDestinatons(), diagram.getVisibleSources(), diagram.getActionFlag());
        }
        this.close();
        if (chEditorFactory != null) {
            if (newEditor) {
                chEditorFactory.openNewEditor();
            } else {
                chEditorFactory.openReuseEditor(this.getDiagramEditor());
            }
        }
    }
}

