/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.editor.actions.menu;

import java.util.ArrayList;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.CHActionDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDLabel;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDPort;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.ch.utils.CHAdapters;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.editor.VHDiagramBreadcrumbUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public abstract class AbstractDCHShowAction
extends DMenuAction {
    private static final int SHOW_ACTION_DEFAULT_DEPTH = 10;
    private CHUVMPort portSelection;
    private CHDPort.Type chdPortType;

    protected AbstractDCHShowAction(DDiagram diagram, Set<DSelectable> selection, String actionName) {
        super(diagram, actionName);
        DSelectable selectable = selection.iterator().next();
        if (selectable instanceof CHDLabel.CHDSelectableLabel) {
            this.portSelection = CHAdapters.getCHPortFromCHDSelectableLabel((CHDLabel.CHDSelectableLabel)selectable, CHUVMPort.class);
            this.chdPortType = ((CHDLabel.CHDSelectableLabel)selectable).getPort().getProperty(CHDPort.TYPE);
        }
    }

    @Override
    public void run() {
        int diagramDepth;
        if (this.portSelection == null) {
            return;
        }
        IDVTBreadcrumbHost activeEditor = this.getEditor();
        if (activeEditor == null) {
            return;
        }
        DDiagram diagram = this.getDiagram();
        if (diagram == null) {
            return;
        }
        LanguageKind langKind = this.getLanguageKind(diagram);
        if (langKind == null) {
            return;
        }
        VHBreadcrumbUtils utils = VHDiagramBreadcrumbUtils.getUtils(langKind);
        BreadcrumbInput breadcrumbInput = DiagramBreadcrumbUtils.getBreadcrumbInput(VHBreadcrumbViewer.class, activeEditor);
        if (breadcrumbInput == null) {
            return;
        }
        if (breadcrumbInput.getInputSegments() == null || breadcrumbInput.getInputSegments().isEmpty()) {
            return;
        }
        ArrayList<BreadcrumbSegment> breadcrumbSegments = new ArrayList<BreadcrumbSegment>(1);
        breadcrumbSegments.add(breadcrumbInput.getInputSegments().get(0));
        CHConfig config = ((ICHDiagram)diagram).getConfig();
        if (config == null) {
            return;
        }
        config.setBreadcrumbInput(new BreadcrumbInput(activeEditor.getProject(), breadcrumbSegments, utils.getBreadcrumbSerializer()));
        DVTTreeElementWrapper wrapper = new DVTTreeElementWrapper(config.getBreadcrumbInput().getSegment(0));
        if (((IDVTElementWrapper)wrapper).getProject() == null && this.getProject() != null) {
            wrapper.setProject(this.getProject());
        }
        ArrayList<CHPort> visibleSources = new ArrayList<CHPort>();
        ArrayList<CHPort> visibleDestinations = new ArrayList<CHPort>();
        int n = diagram instanceof CHDiagram2 ? ((CHDiagram2)diagram).getDepth() : (diagramDepth = diagram instanceof CHActionDiagram ? ((CHActionDiagram)diagram).getDepth() : 0);
        if (diagramDepth < 1) {
            return;
        }
        this.actionSpecificRun(wrapper, config, visibleSources, visibleDestinations, diagramDepth > 10 ? diagramDepth : 10);
    }

    public abstract void actionSpecificRun(IDVTElementWrapper var1, CHConfig var2, ArrayList<CHPort> var3, ArrayList<CHPort> var4, int var5);

    public LanguageKind getLanguageKind(DDiagram diagram) {
        if (diagram instanceof CHDiagram) {
            return LanguageKind.VLOG;
        }
        CHContainer parent = this.portSelection.getParent();
        if (parent == null) {
            return null;
        }
        IDVTElementWrapper wrapper = parent.getWrapper();
        if (wrapper == null) {
            return null;
        }
        return wrapper.getLanguageKind();
    }

    public CHUVMPort getPortSelection() {
        return this.portSelection;
    }

    public void setPortSelection(CHUVMPort portSelection) {
        this.portSelection = portSelection;
    }

    public CHDPort.Type getChdPortType() {
        return this.chdPortType;
    }

    public void setChdPortType(CHDPort.Type chdPortType) {
        this.chdPortType = chdPortType;
    }
}

