/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.editor.actions.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDContainer;
import ro.amiq.dvt.diagrams.ch.editor.CHEditorFactory;
import ro.amiq.dvt.diagrams.ch.editor.actions.menu.DMenuActionMessages;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.utils.CHAdapters;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.editor.DiagramBreadcrumbUtils;
import ro.amiq.dvt.diagrams.editor.VHDiagramBreadcrumbUtils;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public class DCHStepIntoAction
extends DMenuAction {
    private CHUVMComponent selection;

    public DCHStepIntoAction(DDiagram diagram, Set<DSelectable> selection) {
        super(diagram, DMenuActionMessages.stepIntoTitle);
        DSelectable selectable = selection.iterator().next();
        this.selection = selectable instanceof CHDContainer ? CHAdapters.getCHObjectFromCHDObject((CHDContainer)selectable, CHUVMComponent.class) : null;
    }

    @Override
    public boolean isVisible() {
        return this.selection != null && !this.selection.getChildren().isEmpty() && this.selection.getParent() != null;
    }

    @Override
    public void run() {
        IDVTBreadcrumbHost activeEditor = this.getEditor();
        if (activeEditor == null) {
            return;
        }
        DDiagram diagram = this.getDiagram();
        if (diagram == null) {
            return;
        }
        LanguageKind langKind = this.getLanguageKind(diagram);
        if (langKind == null) {
            return;
        }
        VHBreadcrumbUtils utils = VHDiagramBreadcrumbUtils.getUtils(langKind);
        BreadcrumbInput breadcrumbInput = DiagramBreadcrumbUtils.getBreadcrumbInput(VHBreadcrumbViewer.class, activeEditor);
        List breadcrumbSegments = null;
        if (breadcrumbInput != null) {
            List<IRfBreadcrumbElement> gatePathElements;
            List<IRfBreadcrumbElement> inputPathElements = breadcrumbInput.getInputPathElements();
            if (inputPathElements == null) {
                inputPathElements = new ArrayList<IRfBreadcrumbElement>(2);
            }
            if ((gatePathElements = utils.getPathSegmentsForDiagram(this.selection, diagram instanceof CHDiagram)) != null) {
                Collections.reverse(gatePathElements);
                if (!inputPathElements.isEmpty()) {
                    gatePathElements.removeAll(inputPathElements);
                }
                inputPathElements.addAll(gatePathElements);
                breadcrumbSegments = inputPathElements.stream().map(namedElement -> new BreadcrumbSegment((IRfBreadcrumbElement)namedElement)).collect(Collectors.toList());
            }
        }
        CHConfig config = null;
        if (breadcrumbSegments != null && langKind != null) {
            config = ((ICHDiagram)diagram).getConfig();
            config.setBreadcrumbInput(new BreadcrumbInput(activeEditor.getProject(), breadcrumbSegments, utils.getBreadcrumbSerializer()));
        }
        this.openReuseEditor(CHEditorFactory.newComponentSubDiagram((ICHDiagram)diagram, this.selection, config, ((ICHDiagram)diagram).getDepth(), ((ICHDiagram)diagram).isExplicitVifConnections()), (DDiagramEditor)this.getEditor());
    }

    private LanguageKind getLanguageKind(DDiagram diagram) {
        IDVTElementWrapper wrapper = this.selection.getWrapper();
        if (wrapper == null) {
            return null;
        }
        return wrapper.getLanguageKind();
    }
}

