/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.klay;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.krendering.KForeground;
import de.cau.cs.kieler.core.krendering.KPolyline;
import de.cau.cs.kieler.core.krendering.KRectangle;
import de.cau.cs.kieler.core.krendering.KRenderingFactory;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Alignment;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.EdgeType;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.kiml.util.nodespacing.Spacing;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.p4nodes.bk.CompactionStrategy;
import de.cau.cs.kieler.klay.layered.properties.GreedySwitchType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.WideNodesStrategy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.IDiagramEngine;
import ro.amiq.dvt.diagrams.ch.klay.CHDataWrapper;
import ro.amiq.dvt.diagrams.ch.klay.CHKLayRendering;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHDesign;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.ch.model.CHUtils;
import ro.amiq.dvt.diagrams.ch.utils.CHAdapters;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.ch.utils.ICHFilter;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.rendering.KLayStyleFactory;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;

public enum CHDiagramImporter implements IDiagramEngine
{
    INSTANCE;

    private static final String UVM_SEQ_ITEM_PULL_IMP = "uvm_seq_item_pull_imp";
    private static final String SEQ_ITEM_EXPORT = "seq_item_export";
    private static LanguageKind languageKind;

    public KNode toKLay(CHRoot root, CHConfig config, DProgressMonitor monitor) throws DCanceledException {
        List<CHConnection> rootConnections;
        KNode kDesignNode;
        monitor.checkCanceled();
        languageKind = root.getLanguageKind();
        KNode kRoot = KimlUtil.createInitializedNode();
        KRectangle kRendering = KRenderingFactory.eINSTANCE.createKRectangle();
        EList kStyles = kRendering.getStyles();
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createBackground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.WHITE), 0));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.WHITE), 0));
        kRoot.getData().add((Object)kRendering);
        KShapeLayout kRootLayout = (KShapeLayout)kRoot.getData(KShapeLayout.class);
        kRootLayout.setProperty(LayoutOptions.EXPAND_NODES, (Object)true);
        kRootLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN);
        kRootLayout.setProperty(LayoutOptions.ALGORITHM, (Object)"de.cau.cs.kieler.klay.layered");
        kRootLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(0.0f));
        Bundle bundle = Bundle.of(DVTPlugin.getDefault().getPreferenceStore().getInt("chdiagrams.font_size"), DVTPlugin.getDefault().getPreferenceStore().getBoolean("chdiagrams.decreasing_font"), root.getCustomDepth() + 2, new LinkedHashMap<Object, KGraphElement>(), config, monitor);
        KNode kUVMNode = this.createKNodes(root.getUVMComponent(), 0, bundle);
        if (kUVMNode != null) {
            kRoot.getChildren().add((Object)kUVMNode);
        }
        if (root.getDesign() != null && (kDesignNode = this.createKNodes(root.getDesign(), 0, bundle)) != null) {
            kRoot.getChildren().add((Object)kDesignNode);
        }
        if ((rootConnections = root.getConnections()) != null) {
            for (CHConnection connection : rootConnections) {
                this.createKEdge(connection, bundle);
            }
        }
        kRoot.getData().add((Object)new CHDataWrapper(bundle.kElementsMap));
        this.addDummyEdges(root.getUVMComponent(), bundle.kElementsMap, monitor);
        this.computeNodeSize(kRoot);
        return kRoot;
    }

    private KNode createKNodes(CHContainer container, int level, Bundle bundle) throws DCanceledException {
        String containerType;
        bundle.monitor.checkCanceled();
        if (container == null || !container.isVisible()) {
            return null;
        }
        if (bundle.kElementsMap.containsKey(container)) {
            return (KNode)bundle.kElementsMap.get(container);
        }
        if (level < bundle.depth - 1) {
            ++level;
        }
        KNode kNode = KimlUtil.createInitializedNode();
        kNode.getData().add((Object)new CHDataWrapper(container));
        bundle.kElementsMap.put(container, (KGraphElement)kNode);
        ++bundle.nofKNodes;
        this.setKIdentifier((KGraphElement)kNode, container.getPath());
        this.setKNodeRendering(kNode, bundle.config, bundle.depth, level);
        Point labelSize = null;
        float kNodeLabelsWidth = 0.0f;
        float kNodeLabelsHeight = 0.0f;
        FontData containerLabelFontData = FontFactory.getInstance().getFontData("Ubuntu Mono", bundle.containerLabelFontSize, 1);
        if (bundle.decreasingFont) {
            containerLabelFontData = FontFactory.getInstance().depthFontData(containerLabelFontData, bundle.depth, level);
        }
        labelSize = this.setKLabel((KLabeledGraphElement)kNode, container.getName(), containerLabelFontData);
        kNodeLabelsWidth = labelSize.x;
        kNodeLabelsHeight = labelSize.y;
        String string = containerType = container.isInterpMode() ? container.getType() : container.getSanitizedType(languageKind, false);
        if (containerType != null) {
            labelSize = this.setKLabel((KLabeledGraphElement)kNode, '(' + containerType + ')', containerLabelFontData);
            kNodeLabelsWidth = Math.max(kNodeLabelsWidth, (float)labelSize.x);
            kNodeLabelsHeight += kNodeLabelsHeight;
            if (container instanceof CHUVMComponent && ((CHUVMComponent)container).problemDetected() != null) {
                labelSize = this.setKLabel((KLabeledGraphElement)kNode, ((CHUVMComponent)container).problemDetected(), containerLabelFontData);
                kNodeLabelsWidth = Math.max(kNodeLabelsWidth, (float)labelSize.x);
                kNodeLabelsHeight += kNodeLabelsHeight;
            }
        }
        KShapeLayout kNodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
        kNodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(kNodeLabelsWidth));
        kNodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(kNodeLabelsHeight));
        kNodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)"de.cau.cs.kieler.klay.layered");
        kNodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)CHKLayRendering.HIERARCHY_HANDLING);
        kNodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)CHKLayRendering.DIAGRAM_DIRECTION);
        kNodeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)CHKLayRendering.EDGE_ROUTING);
        kNodeLayout.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, CHKLayRendering.CONTAINER_LABEL_PLACEMENT);
        kNodeLayout.setProperty(LayoutOptions.SIZE_OPTIONS, CHKLayRendering.CONTAINER_SIZE_OPTIONS);
        kNodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, CHKLayRendering.CONTAINER_SIZE_CONSTRAINTS);
        kNodeLayout.setProperty(LayoutOptions.PORT_LABEL_PLACEMENT, (Object)CHKLayRendering.CONTAINER_PORT_LABEL_PLACEMENT);
        kNodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)CHKLayRendering.CONTAINER_PORT_CONSTRAINTS);
        kNodeLayout.setProperty(LayoutOptions.ALIGNMENT, (Object)Alignment.RIGHT);
        kNodeLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(0.0f));
        kNodeLayout.setProperty(LayoutOptions.PORT_SPACING, (Object)Float.valueOf(CHKLayRendering.PORT_SPACING));
        kNodeLayout.setProperty(LayoutOptions.SPACING, (Object)Float.valueOf(20.0f));
        Spacing.Margins additionalPortSpacing = new Spacing.Margins(CHKLayRendering.ADDITIONAL_PORT_SPACING);
        additionalPortSpacing.top += (double)(1.2f * kNodeLabelsHeight);
        additionalPortSpacing.bottom += (double)(0.2f * kNodeLabelsHeight);
        kNodeLayout.setProperty(LayoutOptions.ADDITIONAL_PORT_SPACE, (Object)additionalPortSpacing);
        kNodeLayout.setProperty(Properties.CROSS_MIN, (Object)CrossingMinimizationStrategy.LAYER_SWEEP);
        kNodeLayout.setProperty(Properties.LINEAR_SEGMENTS_DEFLECTION_DAMPENING, (Object)Float.valueOf(0.3f));
        kNodeLayout.setProperty(Properties.NODE_PLACER, (Object)NodePlacementStrategy.BRANDES_KOEPF);
        kNodeLayout.setProperty(Properties.GREEDY_SWITCH_TYPE, (Object)GreedySwitchType.TWO_SIDED);
        kNodeLayout.setProperty(Properties.WIDE_NODES_ON_MULTIPLE_LAYERS, (Object)WideNodesStrategy.OFF);
        kNodeLayout.setProperty(Properties.FEEDBACK_EDGES, (Object)Boolean.FALSE);
        kNodeLayout.setProperty(Properties.COMPACTION_STRATEGY, (Object)CompactionStrategy.IMPROVE_STRAIGHTNESS);
        boolean hasChildren = !container.getChildren().isEmpty();
        float kNodeBorderSpacing = 15.0f;
        float minHeight = ((Float)kNodeLayout.getProperty(LayoutOptions.MIN_HEIGHT)).floatValue();
        for (CHPort port : container.getPorts()) {
            String typeLabel;
            if (!port.isVisible()) continue;
            KPort kPort = KimlUtil.createInitializedPort();
            kPort.getData().add((Object)new CHDataWrapper(port));
            kNode.getPorts().add((Object)kPort);
            bundle.kElementsMap.put(port, (KGraphElement)kPort);
            ++bundle.nofKPorts;
            this.setKIdentifier((KGraphElement)kPort, port.getPath());
            this.setKPortRendering(kPort, bundle.config);
            KShapeLayout kPortLayout = (KShapeLayout)kPort.getData(KShapeLayout.class);
            kPortLayout.setSize((float)CHKLayRendering.PORT_SIZE, (float)CHKLayRendering.PORT_SIZE);
            labelSize = this.setKLabel((KLabeledGraphElement)kPort, port.getName(), CHKLayRendering.PORT_LABEL_FONT_DATA);
            if (hasChildren) {
                kNodeBorderSpacing = Math.max(kNodeBorderSpacing, (float)labelSize.x);
            }
            if (!CHUtils.hasVisibleConnections(port)) {
                minHeight += (float)labelSize.y + 15.0f;
            }
            String string2 = typeLabel = port.isInterpMode() ? port.getType() : port.getSanitizedType(languageKind, false);
            if (typeLabel == null) continue;
            labelSize = this.setKLabel((KLabeledGraphElement)kPort, '(' + typeLabel + ')', CHKLayRendering.PORT_LABEL_FONT_DATA);
            if (hasChildren) {
                kNodeBorderSpacing = Math.max(kNodeBorderSpacing, (float)labelSize.x);
            }
            if (CHUtils.hasVisibleConnections(port)) continue;
            minHeight += (float)labelSize.y + 15.0f;
        }
        kNodeLayout.setProperty(LayoutOptions.BORDER_SPACING, (Object)Float.valueOf(kNodeBorderSpacing));
        kNodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(minHeight));
        if (!CHUtils.hasVisiblePorts(container) && !CHUtils.hasVisibleChildren(container)) {
            kNodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(2.0f * ((Float)kNodeLayout.getProperty(LayoutOptions.MIN_HEIGHT)).floatValue()));
        }
        List<CHContainer> children = container.getChildren();
        for (CHContainer child : children) {
            KNode childNode = this.createKNodes(child, level, bundle);
            if (childNode == null) continue;
            childNode.setParent(kNode);
        }
        return kNode;
    }

    private void computeNodeSize(KNode root) {
        KShapeLayout kNodeLayout;
        float maxWidth = 0.0f;
        for (KNode kNode : root.getChildren()) {
            kNodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
            float f = maxWidth = ((Float)kNodeLayout.getProperty(LayoutOptions.MIN_WIDTH)).floatValue() > maxWidth ? ((Float)kNodeLayout.getProperty(LayoutOptions.MIN_WIDTH)).floatValue() : maxWidth;
        }
        for (KNode kNode : root.getChildren()) {
            if (CHAdapters.getCHObjectFromKElement((KGraphElement)kNode, CHDesign.class) != null) continue;
            if (kNode.getChildren().isEmpty()) {
                kNodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
                kNodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(maxWidth));
                continue;
            }
            this.computeNodeSize(kNode);
        }
    }

    private void createDummyKEdge(KNode sourceNode, KNode destNode) {
        if (sourceNode == null || destNode == null) {
            return;
        }
        KEdge edge = KimlUtil.createInitializedEdge();
        edge.setSource(sourceNode);
        edge.setTarget(destNode);
        this.setKEdgeRendering(edge, null);
        KEdgeLayout kEdgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        kEdgeLayout.setProperty(LayoutOptions.EDGE_TYPE, (Object)EdgeType.NONE);
        kEdgeLayout.setProperty(LayoutOptions.THICKNESS, (Object)Float.valueOf(1.0f));
    }

    private void createKEdge(CHConnection connection, Bundle bundle) throws DCanceledException {
        String dataType;
        bundle.monitor.checkCanceled();
        if (!connection.isVisible()) {
            return;
        }
        KGraphElement kSourceNode = bundle.kElementsMap.get(connection.getSource().getParent());
        if (!(kSourceNode instanceof KNode)) {
            return;
        }
        KGraphElement kSourcePort = bundle.kElementsMap.get(connection.getSource());
        if (!(kSourcePort instanceof KPort)) {
            return;
        }
        KGraphElement kDestinationNode = bundle.kElementsMap.get(connection.getDestination().getParent());
        if (!(kDestinationNode instanceof KNode)) {
            return;
        }
        KGraphElement kDestinationPort = bundle.kElementsMap.get(connection.getDestination());
        if (!(kDestinationPort instanceof KPort)) {
            return;
        }
        KEdge kEdge = KimlUtil.createInitializedEdge();
        kEdge.getData().add((Object)new CHDataWrapper(connection));
        bundle.kElementsMap.put(connection, (KGraphElement)kEdge);
        ++bundle.nofKEdges;
        if (CHUtils.isAncestor(connection.getSource().getParent(), connection.getDestination().getParent())) {
            KShapeLayout kPortLayout = (KShapeLayout)kSourcePort.getData(KShapeLayout.class);
            kPortLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)PortSide.WEST);
            kEdge.setSource((KNode)kDestinationNode);
            kEdge.setSourcePort((KPort)kDestinationPort);
            kEdge.setTarget((KNode)kSourceNode);
            kEdge.setTargetPort((KPort)kSourcePort);
        } else if (SEQ_ITEM_EXPORT.equals(connection.getDestination().getName()) && UVM_SEQ_ITEM_PULL_IMP.equals(connection.getDestination().getSanitizedType(languageKind, true))) {
            kEdge.setSource((KNode)kDestinationNode);
            kEdge.setSourcePort((KPort)kDestinationPort);
            kEdge.setTarget((KNode)kSourceNode);
            kEdge.setTargetPort((KPort)kSourcePort);
        } else {
            kEdge.setSource((KNode)kSourceNode);
            kEdge.setSourcePort((KPort)kSourcePort);
            kEdge.setTarget((KNode)kDestinationNode);
            kEdge.setTargetPort((KPort)kDestinationPort);
        }
        KEdgeLayout kEdgeLayout = (KEdgeLayout)kEdge.getData(KEdgeLayout.class);
        kEdgeLayout.setProperty(LayoutOptions.EDGE_TYPE, (Object)EdgeType.UNDIRECTED);
        kEdgeLayout.setProperty(LayoutOptions.THICKNESS, (Object)Float.valueOf(1.0f));
        this.setKEdgeRendering(kEdge, bundle.config);
        if (connection.getDestination().getParent() instanceof CHDesign) {
            return;
        }
        CHPort sourcePort = connection.getSource();
        if (sourcePort instanceof CHUVMPort && (dataType = ((CHUVMPort)sourcePort).getDataType()) != null) {
            this.setKLabel((KLabeledGraphElement)kEdge, dataType, CHKLayRendering.PORT_LABEL_FONT_DATA);
        }
    }

    private void addDummyEdges(CHContainer container, Map<Object, KGraphElement> kElementsMap, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (container == null) {
            return;
        }
        ArrayList<CHContainer> unconnected = new ArrayList<CHContainer>();
        for (CHContainer child : container.getChildren()) {
            if (!child.isConnected()) {
                unconnected.add(child);
            }
            this.addDummyEdges(child, kElementsMap, monitor);
        }
        double floor = Math.floor(Math.sqrt(unconnected.size()));
        int i = 0;
        while (i < unconnected.size() - 1) {
            if ((double)(i + 1) % floor != 0.0) {
                KNode node1 = (KNode)kElementsMap.get(unconnected.get(i));
                KNode node2 = (KNode)kElementsMap.get(unconnected.get(i + 1));
                this.createDummyKEdge(node1, node2);
            }
            ++i;
        }
    }

    private Point setKLabel(KLabeledGraphElement kElement, String text, FontData fontData) {
        text = ' ' + text + ' ';
        KLabel kLabel = KimlUtil.createInitializedLabel((KLabeledGraphElement)kElement);
        kLabel.setText(text);
        kLabel.getData().add((Object)new CHDataWrapper(kLabel));
        KText kText = KRenderingFactory.eINSTANCE.createKText();
        EList kStyles = kText.getStyles();
        KForeground labelFontForeground = KLayStyleFactory.INSTANCE.createForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.LABEL_FONT_COLOR), 255);
        kStyles.add((Object)labelFontForeground);
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createSelectionForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.EDGE_SELECTION_FG), 255));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createFontName(fontData.getName()));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createFontSize(fontData.getHeight()));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createFontBold((fontData.getStyle() & 1) != 0));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createFontItalic((fontData.getStyle() & 2) != 0));
        if (kElement instanceof KPort) {
            EList kPortData = kElement.getData();
            for (KGraphData data : kPortData) {
                CHUVMPort chUvmPort;
                Object dataWrapper;
                if (!(data instanceof CHDataWrapper) || !((dataWrapper = ((CHDataWrapper)data).getData()) instanceof CHUVMPort) || !(chUvmPort = (CHUVMPort)dataWrapper).isSelected()) continue;
                kStyles.remove((Object)labelFontForeground);
                kStyles.add((Object)KLayStyleFactory.INSTANCE.createForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.PURPLE), 255));
            }
        }
        KShapeLayout kLableLayout = (KShapeLayout)kLabel.getData(KShapeLayout.class);
        Point bounds = FontFactory.getInstance().stringExtent(text, fontData);
        kLableLayout.setSize((float)bounds.x, (float)bounds.y);
        kLableLayout.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)(this.isSelfLoopEdge(kElement) ? EdgeLabelPlacement.HEAD : EdgeLabelPlacement.CENTER));
        kLabel.getData().add((Object)kText);
        return bounds;
    }

    private boolean isSelfLoopEdge(KLabeledGraphElement element) {
        if (!(element instanceof KEdge)) {
            return false;
        }
        KEdge edge = (KEdge)element;
        KPort source = edge.getSourcePort();
        KPort target = edge.getTargetPort();
        if (source == null || target == null) {
            return false;
        }
        return source.getNode() != null && source.getNode() == target.getNode();
    }

    private void setKIdentifier(KGraphElement kElement, String identifier) {
        KIdentifier kIdentifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
        kIdentifier.setId(identifier);
        kElement.getData().add((Object)kIdentifier);
    }

    private void setKNodeRendering(KNode kNode, CHConfig config, int depth, int level) {
        ICHFilter blockColoringFilter;
        KRectangle kRendering = KRenderingFactory.eINSTANCE.createKRectangle();
        EList kStyles = kRendering.getStyles();
        RGB color = CHKLayRendering.CONTAINER_BG;
        if (config != null && config.hasFilters() && (blockColoringFilter = config.getActiveFilters().getBlockColoringFilter(CHAdapters.getCHObjectFromKElement((KGraphElement)kNode, CHContainer.class), config.getLanguageKind())) != null) {
            color = blockColoringFilter.getColor();
        }
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createBackground(KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().depthRGB(color, depth, level)), 255));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.CONTAINER_FG), 255));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createLineWidth(1.0f));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createLineStyle(CHKLayRendering.CONTAINER_LINE_STYLE));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createSelectionBackground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.CONTAINER_SELECTION_BG), 255));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createSelectionForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.CONTAINER_SELECTION_FG), 255));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createSelectionLineWidth(3.0f));
        kNode.getData().add((Object)kRendering);
    }

    private void setKPortRendering(KPort kPort, CHConfig config) {
        KRectangle kRendering = KRenderingFactory.eINSTANCE.createKRectangle();
        EList kStyles = kRendering.getStyles();
        RGB color = CHKLayRendering.PORT_BG;
        if (config != null && config.hasFilters()) {
            ICHFilter portColoringFilter = config.getActiveFilters().getPortColoringFilter(CHAdapters.getCHObjectFromKElement((KGraphElement)kPort, CHPort.class), config.getLanguageKind());
            if (config.hasFilters() && portColoringFilter != null) {
                color = portColoringFilter.getColor();
            }
        }
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createBackground(KLayStyleFactory.createColorFromRGB(color), 255));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.PORT_FG), 255));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createSelectionBackground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.PORT_SELECTION_BG), 255));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createSelectionForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.PORT_SELECTION_FG), 255));
        kPort.getData().add((Object)kRendering);
    }

    private void setKEdgeRendering(KEdge kEdge, CHConfig config) {
        KPolyline kRendering = KRenderingFactory.eINSTANCE.createKPolyline();
        EList kStyles = kRendering.getStyles();
        RGB color = CHKLayRendering.EDGE_FG;
        if (config != null && config.hasFilters()) {
            ICHFilter connectionColoringFilter = config.getActiveFilters().getConnectionColoringFilter(CHAdapters.getCHObjectFromKElement((KGraphElement)kEdge, CHConnection.class));
            if (config.hasFilters() && connectionColoringFilter != null) {
                color = connectionColoringFilter.getColor();
            }
        }
        int alpha = 0;
        if (((KEdgeLayout)kEdge.getData(KEdgeLayout.class)).getProperty(LayoutOptions.EDGE_TYPE) != EdgeType.NONE) {
            alpha = 255;
        }
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createLineStyle(CHKLayRendering.EDGE_LINE_STYLE));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createForeground(KLayStyleFactory.createColorFromRGB(color), alpha));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createSelectionForeground(KLayStyleFactory.createColorFromRGB(CHKLayRendering.EDGE_SELECTION_FG), alpha));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createLineWidth(1.0f));
        kStyles.add((Object)KLayStyleFactory.INSTANCE.createSelectionLineWidth(3.0f));
        kEdge.getData().add((Object)kRendering);
    }

    public static class Bundle {
        public final CHConfig config;
        public final DProgressMonitor monitor;
        public final int containerLabelFontSize;
        public final boolean decreasingFont;
        public final int depth;
        public final Map<Object, KGraphElement> kElementsMap;
        public int nofKNodes;
        public int nofKEdges;
        public int nofKPorts;

        private Bundle(int containerLabelFontSize, boolean decreasingFont, int depth, Map<Object, KGraphElement> kElementsMap, CHConfig config, DProgressMonitor monitor) {
            this.containerLabelFontSize = containerLabelFontSize;
            this.decreasingFont = decreasingFont;
            this.depth = depth;
            this.kElementsMap = kElementsMap;
            this.config = config;
            this.monitor = monitor;
        }

        public static Bundle of(int containerLabelFontSize, boolean decreasingFont, int depth, Map<Object, KGraphElement> kElementsMap, CHConfig config, DProgressMonitor monitor) {
            return new Bundle(containerLabelFontSize, decreasingFont, depth, kElementsMap, config, monitor);
        }
    }
}

