/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.ch.model.ICHElement;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;

public class CHConnection
implements ICHElement {
    private CHPort source;
    private CHPort destination;
    private GoToInfo marker;
    private GoToInfo inspectMarker;
    private LanguageKind lang;
    private IProject project;
    private boolean isVisible = true;
    private boolean swap;

    public CHConnection(CHPort source, CHPort destination, LanguageKind lang, IProject project) {
        this.source = source;
        this.destination = destination;
        this.lang = lang;
        this.project = project;
    }

    public CHPort getSource() {
        return this.source;
    }

    public CHPort getDestination() {
        return this.destination;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setIsVisible(boolean value) {
        this.isVisible = value;
    }

    public GoToInfo getTypeMarker() {
        if (this.project == null || this.marker != null) {
            return this.marker;
        }
        this.marker = this.source instanceof CHUVMPort ? VHViewUtils.getTypeMarker(((CHUVMPort)this.source).getDataType(), this.lang, this.project) : null;
        return this.marker;
    }

    public CHConnection getCopy(CHPort source, CHPort destination) {
        return new CHConnection(source, destination, this.lang, this.project);
    }

    @Override
    public GoToInfo getInspectViewMarker() {
        return this.inspectMarker != null ? this.inspectMarker : this.getTypeMarker();
    }

    @Override
    public void setInspectViewMarker(GoToInfo marker) {
        this.inspectMarker = marker;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CHConnection other = (CHConnection)obj;
        if (this.destination == null ? other.destination != null : !this.destination.equals(other.destination)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public boolean equalsNotOriented(Object obj) {
        boolean invertedSources;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.source == null || this.destination == null) {
            return false;
        }
        CHConnection other = (CHConnection)obj;
        CHPort otherDestination = other.destination;
        CHPort otherSource = other.source;
        if (otherDestination == null || otherSource == null) {
            return false;
        }
        boolean sameDestination = this.destination.getName().equals(otherDestination.getName()) && (this.destination.getPath().contains(otherDestination.getPath()) || otherDestination.getPath().contains(this.destination.getPath()));
        boolean invertedDestination = this.destination.getName().equals(otherSource.getName()) && (this.destination.getPath().contains(otherSource.getPath()) || otherSource.getPath().contains(this.destination.getPath()));
        boolean sameSource = this.source.getName().equals(otherSource.getName()) && (this.source.getPath().contains(otherSource.getPath()) || otherSource.getPath().contains(this.source.getPath()));
        boolean bl = invertedSources = this.source.getName().equals(otherDestination.getName()) && (this.source.getPath().contains(otherDestination.getPath()) || otherDestination.getPath().contains(this.source.getPath()));
        if (sameDestination && sameSource) {
            return true;
        }
        return invertedDestination && invertedSources;
    }

    public void swapDirection() {
        this.swap = true;
    }

    public boolean isSwap() {
        return this.swap;
    }
}

