/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.ICHElement;
import ro.amiq.dvt.model.reflection.GoToInfo;

public abstract class CHObject
implements ICHElement {
    protected static final Pattern TYPE_PATTERN = Pattern.compile("^(?:[a-zA-Z_$][a-zA-Z\\d_$]*::)*([a-zA-Z_$][a-zA-Z\\d_$]*)\\s*#*.*");
    private final String path;
    private final String name;
    private final String type;
    private final String svType;
    private final CHContainer parent;
    private boolean isInterpMode;
    private boolean isVisible = true;
    private boolean isRelevant = true;

    public CHObject(String path, String name, String type, String svType, CHContainer parent) {
        this.path = path;
        this.name = name;
        this.type = type;
        this.svType = svType;
        this.parent = parent;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setIsVisible(boolean value, boolean isRelevant) {
        this.isVisible = isRelevant ? value : this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isRelevant() {
        return this.isRelevant;
    }

    public void setIsRelevant(boolean value) {
        this.isRelevant = value;
    }

    public String getSanitizedType(LanguageKind languageKind, boolean acceptName) {
        if (this.type == null) {
            return acceptName ? this.name : null;
        }
        if (languageKind == LanguageKind.E || languageKind == LanguageKind.SLN) {
            return this.type;
        }
        Matcher matcher = TYPE_PATTERN.matcher(this.type);
        if (!matcher.matches()) {
            return this.type;
        }
        return matcher.group(1);
    }

    public String getSanitizedName(LanguageKind languageKind) {
        if (languageKind != LanguageKind.VLOG) {
            return this.name;
        }
        int indexArray = this.name.indexOf("[");
        if (indexArray > 0) {
            return this.name.substring(0, indexArray);
        }
        return this.name;
    }

    public String getSVType() {
        return this.svType;
    }

    public CHContainer getParent() {
        return this.parent;
    }

    @Override
    public GoToInfo getInspectViewMarker() {
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CHObject other = (CHObject)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public boolean isInterpMode() {
        return this.isInterpMode;
    }

    public void setInterpMode(boolean isInterpMode) {
        this.isInterpMode = isInterpMode;
    }
}

