/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHObject;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;

public abstract class CHPort
extends CHObject {
    private Kind kind;
    private DirectionKind directionKind;
    private List<CHConnection> connections;
    private IProject project;
    private LanguageKind lang;
    private List<String> portParentsTypes;
    private List<String> portParentsNames;
    private boolean isSelected;
    private GoToInfo instanceMarker;
    private boolean isEndpointDestinatination;
    private boolean isEndpointSource;

    protected CHPort(String path, String name, String type, String svType, Kind kind, DirectionKind directionKind, CHContainer parent) {
        super(path, name, type, svType, parent);
        this.kind = kind;
        this.directionKind = directionKind;
    }

    protected CHPort(String path, String name, String type, String svType, Kind kind, DirectionKind directionKind, CHContainer parent, IProject project, LanguageKind lang) {
        super(path, name, type, svType, parent);
        this.kind = kind;
        this.directionKind = directionKind;
        this.project = project;
        this.lang = lang;
    }

    public Kind getKind() {
        return this.kind;
    }

    public DirectionKind getDirectionKind() {
        return this.directionKind;
    }

    public abstract CHPort getCopy(CHContainer var1);

    public void addConnection(CHConnection connection) {
        if (this.connections == null) {
            this.connections = new ArrayList<CHConnection>(4);
        }
        this.connections.add(connection);
    }

    public List<CHConnection> getConnections() {
        return this.connections != null ? this.connections : Collections.emptyList();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public GoToInfo getInstanceMarker() {
        if (this.project == null || this.instanceMarker != null) {
            return this.instanceMarker;
        }
        this.instanceMarker = VHViewUtils.getPortMarker(this.getParentsNames(), this.getParentsTypes(), this.getName(), this.getType(), this.lang, this.project);
        return this.instanceMarker;
    }

    @Override
    public GoToInfo getInspectViewMarker() {
        return this.instanceMarker != null ? this.instanceMarker : this.getInstanceMarker();
    }

    public List<String> getParentsNames() {
        return this.portParentsNames != null ? this.portParentsNames : Collections.emptyList();
    }

    public List<String> getParentsTypes() {
        return this.portParentsTypes != null ? this.portParentsTypes : Collections.emptyList();
    }

    public void computeParentsNames() {
        if (this.portParentsNames != null) {
            return;
        }
        this.portParentsNames = new ArrayList<String>();
        CHContainer parent = this.getParent();
        if (this.lang == LanguageKind.VLOG) {
            do {
                this.portParentsNames.add(parent.getName());
            } while ((parent = parent.getParent()) != null);
            Collections.reverse(this.portParentsNames);
        }
    }

    public void computeParentsTypes() {
        if (this.portParentsTypes != null) {
            return;
        }
        this.portParentsTypes = new ArrayList<String>();
        CHContainer parent = this.getParent();
        if (this.lang == LanguageKind.VLOG) {
            do {
                this.portParentsTypes.add(parent.getSanitizedType(this.lang, true));
            } while ((parent = parent.getParent()) != null);
            Collections.reverse(this.portParentsTypes);
        }
    }

    public void setEndpointDestination() {
        this.isEndpointDestinatination = true;
    }

    public boolean isEndpointDestination() {
        return this.isEndpointDestinatination;
    }

    public void setEndpointSource() {
        this.isEndpointSource = true;
    }

    public boolean isEndpointSource() {
        return this.isEndpointSource;
    }

    public static enum DirectionKind {
        UNKNOWN,
        PUT,
        GET,
        BIDIRECTIONAL,
        ANALYSIS,
        NONE;


        public static DirectionKind fromString(String type) {
            if (type == null) {
                return UNKNOWN;
            }
            if (type.contains("_put_")) {
                return PUT;
            }
            if (type.contains("_get_") || type.contains("_peek_") || type.contains("_pull_")) {
                return GET;
            }
            if (type.contains("_analysis_")) {
                return ANALYSIS;
            }
            if (type.contains("_master_") || type.contains("_slave_") || type.contains("_transport_")) {
                return BIDIRECTIONAL;
            }
            return UNKNOWN;
        }
    }

    public static enum Kind {
        UNKNOWN,
        PORT,
        EXPORT,
        IMPLEMENTATION,
        INTERFACE;


        public static Kind fromString(String kind, String type) {
            if (kind != null) {
                if (kind.equals("port")) {
                    return PORT;
                }
                if (kind.equals("export")) {
                    return EXPORT;
                }
                if (kind.equals("implementation")) {
                    return IMPLEMENTATION;
                }
            } else if (type != null) {
                if (type.endsWith("_port")) {
                    return PORT;
                }
                if (type.endsWith("_export")) {
                    return EXPORT;
                }
                if (type.endsWith("_imp")) {
                    return IMPLEMENTATION;
                }
                if (type.contains("_port_")) {
                    return PORT;
                }
                if (type.contains("_export_")) {
                    return EXPORT;
                }
                if (type.contains("_imp")) {
                    return IMPLEMENTATION;
                }
            }
            return UNKNOWN;
        }
    }
}

