/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;

public class CHUVMComponent
extends CHContainer
implements IRfVHBreadcrumbElement {
    private String problemLabel;
    private IProject project;
    private LanguageKind lang;
    private String topInstanceType;
    private GoToInfo instanceMarker;
    private GoToInfo typeMarker;
    private int depth;
    private List<String> types;
    private List<String> names;

    public CHUVMComponent(String path, String name, String type, String svType, CHUVMComponent parent, LanguageKind lang, String topInstanceType, IProject project, IDVTElementWrapper wrapper) {
        super(path, name, type, svType, parent, wrapper);
        this.project = project;
        this.lang = lang;
        this.topInstanceType = topInstanceType;
    }

    public GoToInfo getTypeMarker() {
        if (this.project == null || this.typeMarker != null) {
            return this.typeMarker;
        }
        this.typeMarker = VHViewUtils.getTypeMarker(this.getSanitizedType(this.lang, true), this.lang, this.project);
        return this.typeMarker;
    }

    public GoToInfo getInstanceMarker() {
        if (this.project == null || this.instanceMarker != null) {
            return this.instanceMarker;
        }
        this.instanceMarker = VHViewUtils.getInstanceMarker(this.getNames(), this.getTypes(), this.lang, this.project);
        if (this.instanceMarker != null) {
            return this.instanceMarker;
        }
        if (this.wrapper == null) {
            return null;
        }
        Object wrapperElement = this.wrapper.getRfElement();
        if (wrapperElement instanceof IXXVMComponent) {
            this.instanceMarker = ((IXXVMComponent)wrapperElement).getCreateCallGoToInfo();
        }
        return this.instanceMarker;
    }

    @Override
    public GoToInfo getInspectViewMarker() {
        return this.getInstanceMarker() != null ? this.getInstanceMarker() : this.getTypeMarker();
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    public CHUVMComponent getCopy(CHUVMComponent parent) {
        CHUVMComponent copy = new CHUVMComponent(this.getPath(), this.getName(), this.getType(), this.getSVType(), parent, this.lang, this.getTopInstanceType(), this.project, this.wrapper);
        copy.setNames(this.getNames());
        copy.setTypes(this.getTypes());
        copy.setInterpMode(this.isInterpMode());
        return copy;
    }

    public List<String> getNames() {
        return this.names != null ? this.names : Collections.emptyList();
    }

    public List<String> getTypes() {
        return this.types != null ? this.types : Collections.emptyList();
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public void computeNames() {
        if (this.names != null) {
            return;
        }
        this.names = new ArrayList<String>();
        CHContainer parent = this;
        if (this.lang == LanguageKind.E) {
            String name = parent.getName();
            if (name.contains("[]")) {
                name = name.substring(0, name.indexOf(91));
            }
            this.names.add(name);
        } else {
            do {
                this.names.add(parent.getName());
            } while ((parent = parent.getParent()) != null && this.lang != LanguageKind.E);
            Collections.reverse(this.names);
        }
    }

    public void computeTypes() {
        if (this.types != null) {
            return;
        }
        this.types = new ArrayList<String>();
        CHContainer parent = this;
        if (this.lang == LanguageKind.E || this.lang == LanguageKind.SLN) {
            String parentType = this.getParent() != null ? this.getParent().getSanitizedType(this.lang, true) : (this.getTopInstanceType() != null ? this.getTopInstanceType() : "");
            this.types.add(parentType);
            this.types.add(this.getSanitizedType(this.lang, true));
        } else {
            do {
                this.types.add(parent.getSanitizedType(this.lang, true));
            } while ((parent = parent.getParent()) != null);
            Collections.reverse(this.types);
        }
    }

    public String problemDetected() {
        return this.problemLabel;
    }

    public void setProblemLabel(String name) {
        this.problemLabel = name;
    }

    public LanguageKind getLanguageKind() {
        return this.lang;
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        return namedElement.getEnclosingScope();
    }

    public String getTopInstanceType() {
        return this.topInstanceType;
    }

    public void setTypeMarker(GoToInfo marker) {
        this.typeMarker = marker;
    }

    public void setInstanceMarker(GoToInfo marker) {
        this.instanceMarker = marker;
    }
}

