/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;

public class CHUVMPort
extends CHPort {
    private static final Pattern VLOG_PARAMETER_PATTERN = Pattern.compile("^[a-zA-Z_$][a-zA-Z\\d_$]*#\\((?:[a-zA-Z_$][a-zA-Z\\d_$]*::)?([a-zA-Z_$][a-zA-Z\\d_$]*)[,)].*");
    private static final Pattern E_PARAMETER_PATTERN = Pattern.compile("^.*(\\sof\\s.*?)\\sof\\s(.*)");

    public CHUVMPort(String path, String name, String type, String svType, CHPort.Kind kind, CHPort.DirectionKind directionKind, CHUVMComponent parent) {
        super(path, name, type, svType, kind, directionKind, parent);
    }

    public CHUVMPort(String path, String name, String type, String svType, CHPort.Kind kind, CHPort.DirectionKind directionKind, CHUVMComponent parent, IProject project, LanguageKind lang) {
        super(path, name, type, svType, kind, directionKind, parent, project, lang);
    }

    public String getDataType() {
        String svType = this.getSVType();
        if (svType == null) {
            return null;
        }
        Matcher matcher = VLOG_PARAMETER_PATTERN.matcher(svType);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        Matcher eMatcher = E_PARAMETER_PATTERN.matcher(svType);
        if (eMatcher.matches()) {
            return eMatcher.group(2).trim();
        }
        return null;
    }

    @Override
    public CHPort getCopy(CHContainer parent) {
        if (!(parent instanceof CHUVMComponent)) {
            return null;
        }
        CHUVMPort uvmPort = new CHUVMPort(this.getPath(), this.getName(), this.getType(), this.getSVType(), this.getKind(), this.getDirectionKind(), (CHUVMComponent)parent);
        uvmPort.setInterpMode(this.isInterpMode());
        return uvmPort;
    }
}

