/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHDesign;
import ro.amiq.dvt.diagrams.ch.model.CHObject;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.ch.utils.CHFilterSet;
import ro.amiq.dvt.diagrams.ch.utils.CHPermanentFilter;
import ro.amiq.dvt.diagrams.ch.utils.ICHFilter;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class CHUtils {
    public static final int DEFAULT_DEPTH = 2;
    public static final boolean DEFAULT_EXPLICIT_VIF_CONNECTIONS = true;

    public static CHRoot makeSubRoot(ICHDiagram input, DProgressMonitor monitor) throws DCanceledException {
        return RfMixedLangManager.getInstance().makeSubRoot(input, monitor);
    }

    public static CHUVMComponent adjustRoot(CHUVMComponent component, CHUVMComponent parent, Map<CHPort, CHPort> portsMap, int depth, int[] maxDepth, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        CHUVMComponent copy = component.getCopy(parent);
        if (parent != null) {
            parent.addChild(copy);
            copy.setDepth(parent.getDepth() + 1);
            maxDepth[0] = Math.max(copy.getDepth(), maxDepth[0]);
        } else {
            copy.setDepth(0);
            copy.setIsRelevant(false);
        }
        if (copy.getDepth() > depth) {
            copy.setIsVisible(false, true);
            copy.setIsRelevant(false);
        }
        for (CHPort port : component.getPorts()) {
            CHPort portCopy = port.getCopy(copy);
            copy.addPort(portCopy);
            portsMap.put(port, portCopy);
        }
        for (CHContainer child : component.getChildren()) {
            if (!(child instanceof CHUVMComponent)) continue;
            CHUtils.adjustRoot((CHUVMComponent)child, copy, portsMap, depth, maxDepth, monitor);
        }
        return copy;
    }

    public static void adjustConnections(CHUVMComponent component, CHDesign design, Map<CHPort, CHPort> portsMap, List<CHConnection> connections, Map<CHConnection, CHConnection> connectionsMap, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        for (CHPort port : component.getPorts()) {
            for (CHConnection connection : port.getConnections()) {
                CHConnection copy;
                CHPort src = portsMap.get(connection.getSource());
                CHPort dest = portsMap.get(connection.getDestination());
                if (src == null) continue;
                if (dest == null) {
                    dest = connection.getDestination().getCopy(design);
                    if (dest == null) continue;
                    portsMap.put(connection.getDestination(), dest);
                    design.addPort(dest);
                }
                if ((copy = connectionsMap.get(connection)) != null) continue;
                copy = connection.getCopy(src, dest);
                connectionsMap.put(connection, copy);
                dest.addConnection(copy);
                src.addConnection(copy);
                connections.add(copy);
                src.getParent().setIsConnected();
                dest.getParent().setIsConnected();
            }
        }
        for (CHContainer child : component.getChildren()) {
            CHUtils.adjustConnections((CHUVMComponent)child, design, portsMap, connections, connectionsMap, monitor);
        }
    }

    public static boolean hasVisibleConnections(CHPort port) {
        if (port == null) {
            return false;
        }
        if (port.getConnections().isEmpty()) {
            return false;
        }
        for (CHConnection connection : port.getConnections()) {
            CHPort source = connection.getSource();
            CHPort destination = connection.getDestination();
            if (!connection.isVisible() || !source.isVisible() || !destination.isVisible() || !CHUtils.hasVisibleParents(source) || !CHUtils.hasVisibleParents(destination)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasVisiblePorts(CHContainer container) {
        if (container == null) {
            return false;
        }
        if (container.getPorts().isEmpty()) {
            return false;
        }
        for (CHPort port : container.getPorts()) {
            if (!port.isVisible()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasVisibleChildren(CHContainer container) {
        if (container == null) {
            return false;
        }
        if (container.getChildren().isEmpty()) {
            return false;
        }
        for (CHContainer child : container.getChildren()) {
            if (!child.isVisible()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasVisibleParents(CHObject obj) {
        if (obj.getParent() == null) {
            return true;
        }
        if (!obj.getParent().isVisible()) {
            return false;
        }
        return CHUtils.hasVisibleParents(obj.getParent());
    }

    public static boolean isAncestor(CHContainer comp1, CHContainer comp2) {
        CHContainer parent = comp2.getParent();
        if (parent == null) {
            return false;
        }
        do {
            if (parent != comp1) continue;
            return true;
        } while ((parent = parent.getParent()) != null);
        return false;
    }

    public static void applyFilters(CHRoot root, CHConfig config, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (root == null || root == CHRoot.DUMMY_ROOT) {
            return;
        }
        PrefConst.migrateCHDPrefFilters();
        CHPermanentFilter.INSTANCE.filter(root, monitor);
        CHUVMComponent firstComponent = root.getUVMComponent();
        if (config.hasFilters()) {
            CHFilterSet filterSet = config.getActiveFilters();
            for (ICHFilter filter : filterSet.getFilters()) {
                CHUtils.applyFilterToAllElements(firstComponent, filter, config, root.getLanguageKind(), monitor);
                for (CHConnection connection : root.getConnections()) {
                    CHUtils.applyFilterToConnections(connection, filter);
                }
            }
        }
        CHUtils.reduceUnconnectedPorts(root.getDesign());
        CHUtils.reduceUnconnectedBlocks(root.getDesign());
        if (config.reducePorts()) {
            CHUtils.reduceUnconnectedPorts(firstComponent);
        }
        if (config.reduceBlocks()) {
            CHUtils.reduceUnconnectedBlocks(firstComponent);
        }
    }

    private static void applyFilterToAllElements(CHUVMComponent component, ICHFilter filter, CHConfig config, LanguageKind lang, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        for (CHContainer child : component.getChildren()) {
            if (!(child instanceof CHUVMComponent)) continue;
            CHUtils.applyFilterToAllElements((CHUVMComponent)child, filter, config, lang, monitor);
        }
        CHUtils.applyFilterToPorts(component, lang, filter);
        CHUtils.applyFilterToComponents(component, lang, filter);
    }

    private static void applyFilterToConnections(CHConnection connection, ICHFilter filter) {
        String path;
        if (!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.TRANSACTION_TYPE)) {
            return;
        }
        String dataType = null;
        if (connection.getSource() instanceof CHUVMPort) {
            dataType = ((CHUVMPort)connection.getSource()).getDataType();
        }
        if (filter.matches(String.valueOf(path = CHUtils.getPathForConnection(connection)) + dataType, false)) {
            connection.setIsVisible(false);
        }
        if (filter.matches(String.valueOf(path) + dataType, true)) {
            connection.setIsVisible(true);
        }
    }

    private static void applyFilterToPorts(CHUVMComponent component, LanguageKind lang, ICHFilter filter) {
        if (!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.PORT) && !filter.getKinds().contains((Object)ICHFilter.CHFilterKind.PORT_TYPE)) {
            return;
        }
        for (CHPort port : component.getPorts()) {
            String path = CHUtils.getPathForFilters(port);
            if (filter.getKinds().contains((Object)ICHFilter.CHFilterKind.PORT) && filter.matches(String.valueOf(path) + port.getName(), false) || filter.getKinds().contains((Object)ICHFilter.CHFilterKind.PORT_TYPE) && filter.matches(String.valueOf(path) + port.getSanitizedType(lang, false), false)) {
                port.setIsVisible(false, port.isRelevant());
            }
            if ((!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.PORT) || !filter.matches(String.valueOf(path) + port.getName(), true)) && (!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.PORT_TYPE) || !filter.matches(String.valueOf(path) + port.getSanitizedType(lang, false), true))) continue;
            port.setIsVisible(true, port.isRelevant());
        }
    }

    private static void applyFilterToComponents(CHUVMComponent component, LanguageKind lang, ICHFilter filter) {
        if (!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.INSTANCE) && !filter.getKinds().contains((Object)ICHFilter.CHFilterKind.TYPE)) {
            return;
        }
        String type = component.getSanitizedType(lang, false);
        String path = CHUtils.getPathForFilters(component);
        if (filter.getKinds().contains((Object)ICHFilter.CHFilterKind.INSTANCE) && filter.matches(String.valueOf(path) + component.getName(), false) || filter.getKinds().contains((Object)ICHFilter.CHFilterKind.TYPE) && filter.matches(String.valueOf(path) + type, false)) {
            component.setIsVisible(false, component.isRelevant());
        }
        if (filter.getKinds().contains((Object)ICHFilter.CHFilterKind.INSTANCE) && filter.matches(String.valueOf(path) + component.getName(), true) || filter.getKinds().contains((Object)ICHFilter.CHFilterKind.TYPE) && filter.matches(String.valueOf(path) + type, true)) {
            component.setIsVisible(true, component.isRelevant());
            CHContainer parent = component.getParent();
            while (parent != null && parent.getParent() != null) {
                parent.setIsVisible(true, component.isRelevant());
                parent = parent.getParent();
            }
        }
    }

    public static String getPathForFilters(CHObject obj) {
        String path = obj.getPath();
        if (path == null || path.isEmpty()) {
            return "";
        }
        path = path.substring(0, path.lastIndexOf(46) + 1);
        return path.replaceAll("\\.", "/");
    }

    public static String getPathForConnection(CHConnection connection) {
        CHPort source = connection.getSource();
        CHPort destination = connection.getDestination();
        if (source.getParent() instanceof CHDesign || destination.getParent() instanceof CHDesign) {
            return "DESIGN/";
        }
        ArrayList<CHContainer> sourceParents = new ArrayList<CHContainer>();
        CHContainer parent = source.getParent();
        while (parent != null) {
            sourceParents.add(parent);
            parent = parent.getParent();
        }
        parent = destination.getParent();
        while (parent != null && !sourceParents.contains(parent)) {
            parent = parent.getParent();
        }
        return parent != null ? String.valueOf(parent.getPath().replaceAll("\\.", "/")) + "/" : "";
    }

    public static void reduceUnconnectedPorts(CHContainer component) {
        if (component == null) {
            return;
        }
        for (CHContainer child : component.getChildren()) {
            if (!(child instanceof CHUVMComponent)) continue;
            CHUtils.reduceUnconnectedPorts(child);
        }
        for (CHPort port : component.getPorts()) {
            if (CHUtils.hasVisibleConnections(port)) continue;
            port.setIsVisible(false, port.isRelevant());
        }
    }

    private static void reduceUnconnectedBlocks(CHContainer component) {
        if (component == null || !component.isVisible()) {
            return;
        }
        for (CHContainer child : component.getChildren()) {
            CHUtils.reduceUnconnectedBlocks(child);
        }
        if (!CHUtils.hasVisiblePorts(component) && !CHUtils.hasVisibleChildren(component)) {
            component.setIsVisible(false, component.isRelevant());
        }
    }
}

