/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHXMLParser1;
import ro.amiq.dvt.diagrams.ch.model.CHXMLParser2;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.utils.XMLErrorHandler;

public enum CHXMLParser {
    V1(CHXMLParser1.INSTANCE),
    V2(CHXMLParser2.INSTANCE);

    private final CHXMLParserImplementation implemenetation;
    private static final String TAG_UVM_HIERARCHY = "component-hierarchy";
    private static final String ATTR_VERSION = "version";

    private CHXMLParser(CHXMLParserImplementation implementation) {
        this.implemenetation = implementation;
    }

    public static CHRoot parse(File file, CHDiagram diagram, DProgressMonitor monitor) throws Exception {
        if (!file.exists()) {
            return null;
        }
        Element root = CHXMLParser.getRoot(file);
        if (root == null) {
            return null;
        }
        String version = root.getAttribute(ATTR_VERSION);
        if (version == null || version.isEmpty()) {
            version = "1";
        }
        switch (version) {
            case "1": {
                return CHXMLParser.V1.implemenetation.parse(root, diagram, monitor);
            }
            case "2": {
                return CHXMLParser.V2.implemenetation.parse(root, diagram, monitor);
            }
        }
        throw new IllegalArgumentException("Unknown XML file version " + version + ".");
    }

    private static Element getRoot(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList roots = document.getElementsByTagName(TAG_UVM_HIERARCHY);
        if (roots.getLength() < 1) {
            return null;
        }
        return (Element)roots.item(0);
    }

    public static interface CHXMLParserImplementation {
        public CHRoot parse(Element var1, CHDiagram var2, DProgressMonitor var3) throws DCanceledException;
    }
}

