/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHDesign;
import ro.amiq.dvt.diagrams.ch.model.CHInterface;
import ro.amiq.dvt.diagrams.ch.model.CHObject;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.ch.model.CHVif;
import ro.amiq.dvt.diagrams.ch.model.CHXMLParser;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;

public enum CHXMLParser1 implements CHXMLParser.CHXMLParserImplementation
{
    INSTANCE;

    public static final String VERSION_ID = "1";
    private static final String TAG_UVM_COMPONENT = "uvm-component";
    private static final String TAG_INTERFACE = "interface";
    private static final String TAG_VIF = "vif";
    private static final String TAG_UVM_PORT = "uvm-port";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_KIND = "kind";
    private static final String ATTR_SV_TYPE = "sv-type";
    private static final String TAG_CONNECTION = "connection";
    private static final String ATTR_SOURCE = "source";
    private static final String ATTR_DESTINATION = "destination";

    @Override
    public CHRoot parse(Element root, CHDiagram diagram, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        NodeList rootChildNodes = root.getChildNodes();
        if (rootChildNodes.getLength() < 1) {
            return CHRoot.DUMMY_ROOT;
        }
        Element firstUVMComponentElement = null;
        int i = 0;
        while (i < rootChildNodes.getLength()) {
            Element rootChildElement;
            Node rootChildNode = rootChildNodes.item(i);
            if (1 == rootChildNode.getNodeType() && TAG_UVM_COMPONENT.equals((rootChildElement = (Element)rootChildNode).getTagName())) {
                firstUVMComponentElement = rootChildElement;
                break;
            }
            ++i;
        }
        if (firstUVMComponentElement == null) {
            return CHRoot.DUMMY_ROOT;
        }
        HashMap<String, CHPort> portPaths = new HashMap<String, CHPort>();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] depth = nArray;
        CHObject firstUVMComponent = this.visitComponentNode(firstUVMComponentElement, null, "", portPaths, depth, diagram.getDepth(), diagram, monitor);
        if (!(firstUVMComponent instanceof CHUVMComponent)) {
            return CHRoot.DUMMY_ROOT;
        }
        CHDesign design = null;
        NodeList interfaceNodes = root.getElementsByTagName(TAG_INTERFACE);
        if (interfaceNodes.getLength() > 0) {
            design = new CHDesign();
            int i2 = 0;
            while (i2 < interfaceNodes.getLength()) {
                Element interfaceElement = (Element)interfaceNodes.item(i2);
                String name = interfaceElement.getAttribute(ATTR_NAME);
                if (name != null && !name.isEmpty()) {
                    String svType = interfaceElement.getAttribute(ATTR_SV_TYPE);
                    if (svType == null || svType.isEmpty()) {
                        svType = null;
                    }
                    String path = "design." + name;
                    CHInterface interf = new CHInterface(path, name, svType, design);
                    design.addPort(interf);
                    portPaths.put(path, interf);
                }
                ++i2;
            }
        }
        ArrayList<CHConnection> connections = new ArrayList<CHConnection>();
        NodeList connectionNodes = root.getElementsByTagName(TAG_CONNECTION);
        int i3 = 0;
        while (i3 < connectionNodes.getLength()) {
            CHPort destinationPort;
            String destination;
            CHPort sourcePort;
            Element connectionElements = (Element)connectionNodes.item(i3);
            String source = connectionElements.getAttribute(ATTR_SOURCE);
            if (source != null && !source.isEmpty() && (sourcePort = portPaths.get(source)) != null && (destination = connectionElements.getAttribute(ATTR_DESTINATION)) != null && !source.isEmpty() && (destinationPort = portPaths.get(destination)) != null) {
                CHConnection connection = new CHConnection(sourcePort, destinationPort, diagram.getLanguageKind(), diagram.getProject());
                sourcePort.addConnection(connection);
                destinationPort.addConnection(connection);
                sourcePort.getParent().setIsConnected();
                destinationPort.getParent().setIsConnected();
                connections.add(connection);
            }
            ++i3;
        }
        CHRoot chRoot = new CHRoot((CHUVMComponent)firstUVMComponent, design, connections, depth[0] - 1);
        chRoot.setCustomDepth(diagram.getDepth());
        return chRoot;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CHObject visitComponentNode(Element componentNode, CHUVMComponent parentComponent, String path, HashMap<String, CHPort> portPaths, int[] depth, int maxDepth, CHDiagram diagram, DProgressMonitor monitor) throws DCanceledException {
        String svType;
        monitor.checkCanceled();
        String name = componentNode.getAttribute(ATTR_NAME);
        if (name == null || name.isEmpty()) {
            return null;
        }
        String type = componentNode.getAttribute(ATTR_TYPE);
        if (type == null || type.isEmpty()) {
            type = null;
        }
        if ((svType = componentNode.getAttribute(ATTR_SV_TYPE)) == null || svType.isEmpty()) {
            svType = null;
        }
        path = path.isEmpty() ? name : String.valueOf(path) + "." + name;
        String componentTag = componentNode.getTagName();
        if (TAG_VIF.equals(componentTag)) {
            CHVif vif = new CHVif(path, name, svType, parentComponent);
            portPaths.put(path, vif);
            return vif;
        }
        if (TAG_UVM_PORT.equals(componentTag)) {
            String kind = componentNode.getAttribute(ATTR_KIND);
            if (kind == null || kind.isEmpty()) {
                kind = null;
            }
            CHUVMPort port = new CHUVMPort(path, name, type, svType, CHPort.Kind.fromString(kind, type), CHPort.DirectionKind.fromString(type), parentComponent);
            portPaths.put(path, port);
            return port;
        }
        if (!TAG_UVM_COMPONENT.equals(componentTag)) {
            return null;
        }
        depth[1] = depth[1] + 1;
        depth[0] = Math.max(depth[0], depth[1]);
        CHUVMComponent component = new CHUVMComponent(path, name, type, svType, parentComponent, diagram.getLanguageKind(), null, diagram.getProject(), null);
        component.setDepth(depth[1] - 1);
        component.computeNames();
        component.computeTypes();
        if (component.getDepth() > maxDepth) {
            component.setIsVisible(false, true);
            component.setIsRelevant(false);
        }
        if (parentComponent == null) {
            component.setIsRelevant(false);
        }
        NodeList childNodes = componentNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (1 == node.getNodeType()) {
                Element element = (Element)node;
                switch (element.getTagName()) {
                    case "uvm-component": 
                    case "uvm-port": 
                    case "vif": {
                        CHObject childComponent = this.visitComponentNode(element, component, path, portPaths, depth, maxDepth, diagram, monitor);
                        if (childComponent == null) break;
                        if (childComponent instanceof CHPort) {
                            component.addPort((CHPort)childComponent);
                            break;
                        }
                        if (!(childComponent instanceof CHUVMComponent)) break;
                        component.addChild((CHUVMComponent)childComponent);
                        break;
                    }
                }
            }
            ++i;
        }
        depth[1] = depth[1] - 1;
        return component;
    }
}

