/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHDesign;
import ro.amiq.dvt.diagrams.ch.model.CHInterface;
import ro.amiq.dvt.diagrams.ch.model.CHObject;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.ch.model.CHVif;
import ro.amiq.dvt.diagrams.ch.model.CHXMLParser;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum CHXMLParser2 implements CHXMLParser.CHXMLParserImplementation
{
    INSTANCE;

    public static final String VERSION_ID = "2";
    private static final String TAG_XVM_COMPONENT = "xvm-component";
    private static final String TAG_INTERFACE = "interface";
    private static final String TAG_VIF = "vif";
    private static final String TAG_XVM_PORT = "xvm-port";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_KIND = "kind";
    private static final String ATTR_SV_TYPE = "sv-type";
    private static final String TAG_CONNECTION = "connection";
    private static final String ATTR_SOURCE = "source";
    private static final String ATTR_DESTINATION = "destination";
    private static final Pattern DOT;

    static {
        DOT = Pattern.compile("\\.");
    }

    @Override
    public CHRoot parse(Element root, CHDiagram diagram, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        NodeList rootChildNodes = root.getChildNodes();
        if (rootChildNodes.getLength() < 1) {
            return CHRoot.DUMMY_ROOT;
        }
        Element firstXVMComponentElement = null;
        int i = 0;
        while (i < rootChildNodes.getLength()) {
            Element rootChildElement;
            Node rootChildNode = rootChildNodes.item(i);
            if (1 == rootChildNode.getNodeType() && TAG_XVM_COMPONENT.equals((rootChildElement = (Element)rootChildNode).getTagName())) {
                firstXVMComponentElement = rootChildElement;
                break;
            }
            ++i;
        }
        if (firstXVMComponentElement == null) {
            return CHRoot.DUMMY_ROOT;
        }
        HashMap<String, CHPort> portPaths = new HashMap<String, CHPort>();
        HashSet<String> tlmFifos = new HashSet<String>();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] depth = nArray;
        CHObject firstXVMComponent = this.visitComponentNode(firstXVMComponentElement, null, "", portPaths, tlmFifos, depth, diagram.getDepth(), diagram, monitor);
        if (!(firstXVMComponent instanceof CHUVMComponent)) {
            return CHRoot.DUMMY_ROOT;
        }
        CHDesign design = null;
        NodeList interfaceNodes = root.getElementsByTagName(TAG_INTERFACE);
        if (interfaceNodes.getLength() > 0) {
            design = new CHDesign();
            int i2 = 0;
            while (i2 < interfaceNodes.getLength()) {
                Element interfaceElement = (Element)interfaceNodes.item(i2);
                String name = interfaceElement.getAttribute(ATTR_NAME);
                if (name != null && !name.isEmpty()) {
                    String svType = interfaceElement.getAttribute(ATTR_SV_TYPE);
                    if (svType == null || svType.isEmpty()) {
                        svType = null;
                    }
                    String path = "design." + name;
                    CHInterface interf = new CHInterface(path, name, svType, design);
                    design.addPort(interf);
                    portPaths.put(path, interf);
                }
                ++i2;
            }
        }
        ArrayList<CHConnection> connections = new ArrayList<CHConnection>();
        NodeList connectionNodes = root.getElementsByTagName(TAG_CONNECTION);
        int i3 = 0;
        while (i3 < connectionNodes.getLength()) {
            Element connectionElements = (Element)connectionNodes.item(i3);
            String source = connectionElements.getAttribute(ATTR_SOURCE);
            if (source != null && !source.isEmpty()) {
                String destination;
                CHPort sourcePort;
                String[] sourcePath = DVTStringUtil.split(DOT, source);
                DVTStringBuilder sourceParent = new DVTStringBuilder();
                int j = 0;
                while (j < sourcePath.length - 1) {
                    sourceParent.append(sourcePath[j]).append(".");
                    ++j;
                }
                sourceParent.deleteLastChar();
                String workingSource = sourceParent.toString();
                if (tlmFifos.contains(workingSource)) {
                    source = workingSource;
                }
                if ((sourcePort = portPaths.get(source)) != null && (destination = connectionElements.getAttribute(ATTR_DESTINATION)) != null && !source.isEmpty()) {
                    CHPort destinationPort;
                    String[] destinationPath = DVTStringUtil.split(DOT, destination);
                    DVTStringBuilder destinationParent = new DVTStringBuilder();
                    int j2 = 0;
                    while (j2 < destinationPath.length - 1) {
                        destinationParent.append(destinationPath[j2]).append(".");
                        ++j2;
                    }
                    destinationParent.deleteLastChar();
                    String workingDestination = destinationParent.toString();
                    if (tlmFifos.contains(workingDestination)) {
                        destination = workingDestination;
                    }
                    if ((destinationPort = portPaths.get(destination)) != null) {
                        CHConnection connection = new CHConnection(sourcePort, destinationPort, diagram.getLanguageKind(), diagram.getProject());
                        sourcePort.addConnection(connection);
                        destinationPort.addConnection(connection);
                        sourcePort.getParent().setIsConnected();
                        destinationPort.getParent().setIsConnected();
                        connections.add(connection);
                    }
                }
            }
            ++i3;
        }
        CHRoot chRoot = new CHRoot((CHUVMComponent)firstXVMComponent, design, connections, depth[0] - 1);
        chRoot.setCustomDepth(diagram.getDepth());
        return chRoot;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CHObject visitComponentNode(Element componentNode, CHUVMComponent parentComponent, String path, HashMap<String, CHPort> portPaths, Set<String> tlmFifos, int[] depth, int maxDepth, CHDiagram diagram, DProgressMonitor monitor) throws DCanceledException {
        String svType;
        monitor.checkCanceled();
        String name = componentNode.getAttribute(ATTR_NAME);
        if (name == null || name.isEmpty()) {
            return null;
        }
        String type = componentNode.getAttribute(ATTR_TYPE);
        if (type == null || type.isEmpty()) {
            type = null;
        }
        if ((svType = componentNode.getAttribute(ATTR_SV_TYPE)) == null || svType.isEmpty()) {
            svType = null;
        }
        path = path.isEmpty() ? name : String.valueOf(path) + "." + name;
        String componentTag = componentNode.getTagName();
        if (TAG_VIF.equals(componentTag)) {
            CHVif vif = new CHVif(path, name, svType, parentComponent);
            portPaths.put(path, vif);
            return vif;
        }
        if (TAG_XVM_PORT.equals(componentTag)) {
            String kind = componentNode.getAttribute(ATTR_KIND);
            if (kind == null || kind.isEmpty()) {
                kind = null;
            }
            CHUVMPort port = new CHUVMPort(path, name, type, svType, CHPort.Kind.fromString(kind, type), CHPort.DirectionKind.fromString(type), parentComponent);
            portPaths.put(path, port);
            return port;
        }
        if (!TAG_XVM_COMPONENT.equals(componentTag)) {
            return null;
        }
        if (type != null) {
            for (String tlm_fifo_pattern : IXXVMComponent.TLM_FIFOS) {
                if (!type.startsWith(tlm_fifo_pattern)) continue;
                String kind = componentNode.getAttribute(ATTR_KIND);
                if (kind == null || kind.isEmpty()) {
                    kind = null;
                }
                CHUVMPort port = new CHUVMPort(path, name, type, svType, CHPort.Kind.fromString(kind, type), CHPort.DirectionKind.fromString(type), parentComponent);
                portPaths.put(path, port);
                tlmFifos.add(path);
                return port;
            }
        }
        depth[1] = depth[1] + 1;
        depth[0] = Math.max(depth[0], depth[1]);
        CHUVMComponent component = new CHUVMComponent(path, name, type, svType, parentComponent, diagram.getLanguageKind(), null, diagram.getProject(), null);
        component.setDepth(depth[1] - 1);
        component.computeNames();
        component.computeTypes();
        if (component.getDepth() > maxDepth) {
            component.setIsVisible(false, true);
            component.setIsRelevant(false);
        }
        if (parentComponent == null) {
            component.setIsRelevant(false);
        }
        NodeList childNodes = componentNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (1 == node.getNodeType()) {
                Element element = (Element)node;
                switch (element.getTagName()) {
                    case "xvm-port": 
                    case "vif": 
                    case "xvm-component": {
                        CHObject childComponent = this.visitComponentNode(element, component, path, portPaths, tlmFifos, depth, maxDepth, diagram, monitor);
                        if (childComponent == null) break;
                        if (childComponent instanceof CHPort) {
                            component.addPort((CHPort)childComponent);
                            break;
                        }
                        if (!(childComponent instanceof CHUVMComponent)) break;
                        component.addChild((CHUVMComponent)childComponent);
                        break;
                    }
                }
            }
            ++i;
        }
        depth[1] = depth[1] - 1;
        return component;
    }
}

