/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.IXVMBuildPhaseXMLParserCommon;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.IXVHContributor;
import ro.amiq.dvt.interpreter.XUVMElaborationSetup;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.optimized.collections.Stack;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.config.db.IXConfigDBContributor;
import ro.amiq.dvt.ui.views.factory.overrides.IXFactoryOverridesContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.UVMRuntimeSettings;
import ro.amiq.dvt.ui.views.registers.IXRegistersContributor;
import ro.amiq.dvt.utils.XMLErrorHandler;

public enum XVMBuildPhaseXMLParser implements IXVMBuildPhaseXMLParserCommon
{
    INSTANCE;


    public String getTestName(Document document) {
        Element root;
        block3: {
            try {
                root = XVMBuildPhaseXMLParser.getRoot(document, "uvm-elaboration-model");
                if (root != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return root.getAttribute("test-name");
    }

    public String getRootElementPath(Document document) {
        Element root;
        block3: {
            try {
                root = XVMBuildPhaseXMLParser.getRoot(document, "xvm-component");
                if (root != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return root.getAttribute("named-element-class");
    }

    public String getElabModelStatus(Document document) {
        Element root;
        block3: {
            try {
                root = XVMBuildPhaseXMLParser.getRoot(document, "uvm-elaboration-status");
                if (root != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return root.getAttribute("status");
    }

    public UVMRuntimeSettings getUVMRuntimeSettings(Document document, String elementName) {
        NodeList rootChildNodes;
        String timestamp;
        block7: {
            Element root;
            block6: {
                root = XVMBuildPhaseXMLParser.getRoot(document, "uvm-elaboration-model");
                if (root != null) break block6;
                return null;
            }
            timestamp = root.getAttribute("timestamp");
            rootChildNodes = root.getChildNodes();
            if (rootChildNodes.getLength() >= 1) break block7;
            return null;
        }
        try {
            int i = 0;
            while (i < rootChildNodes.getLength()) {
                Element rootChildElement;
                Node rootChildNode = rootChildNodes.item(i);
                if (1 == rootChildNode.getNodeType() && "runtime-settings".equals((rootChildElement = (Element)rootChildNode).getNodeName())) {
                    UVMRuntimeSettings uvmRuntimeSettings = new UVMRuntimeSettings(elementName);
                    uvmRuntimeSettings.setVerbosity(rootChildElement.getAttribute("verbosity"));
                    uvmRuntimeSettings.setSeed(rootChildElement.getAttribute("seed"));
                    uvmRuntimeSettings.setUseBuiltinDPIC(Boolean.parseBoolean(rootChildElement.getAttribute("builtin-dpic")));
                    uvmRuntimeSettings.setAddArguments(rootChildElement.getAttribute("additional-args"));
                    uvmRuntimeSettings.setTimestamp(timestamp);
                    return uvmRuntimeSettings;
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void parse(File file, IProject project) {
        this.parse(file, project, true);
    }

    public void parse(File file, final IProject project, boolean printNonErrorInfoToConsole) {
        Object xUVMElaborationStarter = XUVMElaborationStarters.getStarter(LanguageKind.VLOG);
        if (xUVMElaborationStarter == null) {
            throw new IllegalStateException("Unable to locate UVM Elaboration Starter");
        }
        XConsole console = XConsoleRegistry.getConsole(project, false, false);
        console.bringToTop();
        if (printNonErrorInfoToConsole) {
            console.print("\nLoading model from file " + file.getAbsolutePath());
        }
        try {
            if (file == null || project == null) {
                throw new IllegalStateException("Null element");
            }
            Document document = XVMBuildPhaseXMLParser.getDocument(file);
            Element root = XVMBuildPhaseXMLParser.getRoot(document, "uvm-elaboration-model");
            if (root == null) {
                console.print("\nFailed to load model from file " + file.getAbsoluteFile());
                return;
            }
            final String testName = root.getAttribute("test-name");
            if (testName == null || testName.isEmpty()) {
                return;
            }
            String projectName = root.getAttribute("project-name");
            if (projectName == null || !projectName.equals(project.getName())) {
                console.print("\nCannot parse files from another projects!");
                return;
            }
            NodeList rootChildNodes = root.getChildNodes();
            if (rootChildNodes.getLength() < 1) {
                return;
            }
            XUVMElaborationSetup uvmElaborationSetup = xUVMElaborationStarter.buildSetup(new String[]{"+UVM_TESTNAME=" + testName}, project, project.getName(), false, false, false, true);
            if (uvmElaborationSetup == null) {
                return;
            }
            xUVMElaborationStarter.start(uvmElaborationSetup);
            LinkedHashMap<IXContributor, Element> xContributorToElement = new LinkedHashMap<IXContributor, Element>();
            int i = 0;
            while (i < rootChildNodes.getLength()) {
                block35: {
                    Node rootChildNode = rootChildNodes.item(i);
                    if (1 != rootChildNode.getNodeType()) break block35;
                    Element rootChildElement = (Element)rootChildNode;
                    String tagName = rootChildElement.getTagName();
                    if (tagName == null || tagName.isEmpty()) {
                        throw new IllegalStateException("Unable to reach tag name while parsing");
                    }
                    switch (tagName) {
                        case "component-hierarchy": {
                            IXVHContributor xvhContributor = XViewsUtils.getXVHContributor();
                            if (xvhContributor == null) {
                                throw new IllegalStateException("Unable to locate Verification Hierarchy View Contributor!");
                            }
                            xContributorToElement.put(xvhContributor, rootChildElement);
                            break;
                        }
                        case "register-hierarchy": {
                            IXRegistersContributor xRegistersViewContributor = XViewsUtils.getXRegistersViewContributor();
                            if (xRegistersViewContributor == null) {
                                throw new IllegalStateException("Unable to locate Registers View Contributor!");
                            }
                            xContributorToElement.put(xRegistersViewContributor, rootChildElement);
                            break;
                        }
                        case "factory-overrides-hierarchy": {
                            IXFactoryOverridesContributor xFactoryOverridesViewContributor = XViewsUtils.getXFactoryOverridesViewContributor();
                            if (xFactoryOverridesViewContributor == null) {
                                throw new IllegalStateException("Unable to locate UVM Factory Overrides View Contributor!");
                            }
                            xContributorToElement.put(xFactoryOverridesViewContributor, rootChildElement);
                            break;
                        }
                        case "config-db-hierarchy": {
                            IXConfigDBContributor xConfigDBViewContributor = XViewsUtils.getXConfigDBViewContributor();
                            if (xConfigDBViewContributor == null) {
                                throw new IllegalStateException("Unable to locate Config DB View Contributor!");
                            }
                            xContributorToElement.put(xConfigDBViewContributor, rootChildElement);
                            break;
                        }
                    }
                }
                ++i;
            }
            ArrayList<1> workers = new ArrayList<1>();
            for (final Map.Entry entry : xContributorToElement.entrySet()) {
                final IXContributor contributor2 = (IXContributor)entry.getKey();
                Job worker2 = new Job("Parsing Elements for " + contributor2.getID()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            contributor2.deepClean();
                            contributor2.parseNode((Element)entry.getValue(), project, testName);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                workers.add(worker2);
                worker2.schedule();
            }
            workers.forEach(worker -> {
                try {
                    worker.join();
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
            if (XViewsUtils.hasXFactoryOverridesViewContributor()) {
                IXFactoryOverridesContributor xFactoryOverridesViewContributor = XViewsUtils.getXFactoryOverridesViewContributor();
                xFactoryOverridesViewContributor.computeAffectedXVMComponents();
            }
            xUVMElaborationStarter.setLoadModelSuccesfully(project, testName);
            xUVMElaborationStarter.notifyContributorsSuccessMode(uvmElaborationSetup);
            if (printNonErrorInfoToConsole) {
                console.print("\nModel loaded!");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            XViewsUtils.getXContributors().forEach(contributor -> contributor.notifyXViewError());
        }
    }

    public static Element getRoot(Document document, String tagName) {
        NodeList roots = document.getElementsByTagName(tagName);
        if (roots.getLength() < 1) {
            return null;
        }
        return (Element)roots.item(0);
    }

    public static Document getDocument(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        return document;
    }

    public static Document getRuntimeElabDocumentMetadata(File file) throws IOException, XMLStreamException, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElementNS(null, "root");
        doc.appendChild(root);
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        xmlif.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        XMLStreamReader xmlr = xmlif.createXMLStreamReader(bis);
        Stack<Element> parentsStack = new Stack<Element>();
        parentsStack.add(root);
        while (xmlr.hasNext()) {
            if (xmlr.getEventType() == 1) {
                Element el = doc.createElement(xmlr.getLocalName());
                int i = 0;
                while (i < xmlr.getAttributeCount()) {
                    String attributeName = xmlr.getAttributeLocalName(i);
                    String attributeValue = xmlr.getAttributeValue(i);
                    el.setAttribute(attributeName, attributeValue);
                    ++i;
                }
                ((Element)parentsStack.peek()).appendChild(el);
                parentsStack.add(el);
            } else if (xmlr.getEventType() == 2) {
                parentsStack.pop();
                if (xmlr.getLocalName().equals("component-hierarchy")) break;
            }
            xmlr.next();
        }
        bis.close();
        xmlr.close();
        return doc;
    }

    public String getTimestamp(Document document) {
        Element root;
        block3: {
            try {
                root = XVMBuildPhaseXMLParser.getRoot(document, "uvm-elaboration-model");
                if (root != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return root.getAttribute("timestamp");
    }
}

