/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.utils;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.ch.utils.ICHFilter;
import ro.amiq.dvt.diagrams.netlist.rendering.NLDefaultRenderingConstants;

public class CHColorFilter
implements ICHFilter {
    private Set<ICHFilter.CHFilterKind> kinds;
    private Pattern pattern;
    private Pattern pathPattern;
    private RGB color;
    private String text;
    private String path;

    public CHColorFilter(String text, String path, Set<ICHFilter.CHFilterKind> kinds, RGB color) {
        this.kinds = kinds;
        this.color = color != null ? color : (kinds.contains((Object)ICHFilter.CHFilterKind.INSTANCE) ? NLDefaultRenderingConstants.LIGHT_GREEN : NLDefaultRenderingConstants.DARK_GREEN);
        this.text = text;
        this.text = text != null ? text : "";
        this.path = path != null ? path : "";
        this.kinds = kinds;
        try {
            this.pattern = this.text.isEmpty() ? null : Pattern.compile(this.text);
            this.pathPattern = this.path.isEmpty() ? null : Pattern.compile(this.path);
        }
        catch (Exception exception) {
            this.pattern = null;
            this.pathPattern = null;
        }
    }

    @Override
    public boolean isColorFilter() {
        return true;
    }

    @Override
    public boolean isExcludeFilter() {
        return false;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public RGB getColor() {
        return this.color;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getFullText() {
        return String.valueOf(this.path) + this.text;
    }

    @Override
    public boolean isHide() {
        return false;
    }

    @Override
    public boolean isShow() {
        return false;
    }

    @Override
    public boolean isColor() {
        return true;
    }

    @Override
    public Set<ICHFilter.CHFilterKind> getKinds() {
        return this.kinds;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public Pattern getPathPattern() {
        return this.pathPattern;
    }
}

