/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.utils;

import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.utils.CHFilterSet;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;

public class CHConfig {
    private LanguageKind languageKind;
    private CHFilterSet activeFilters;
    private boolean configReducePorts = true;
    private boolean configReduceBlocks;
    private BreadcrumbInput breadcrumbInput;

    public CHConfig(CHFilterSet filters, LanguageKind language) {
        this.activeFilters = filters;
        this.languageKind = language;
    }

    public LanguageKind getLanguageKind() {
        return this.languageKind;
    }

    public boolean configReducePorts() {
        return this.configReducePorts;
    }

    public void setReducePorts(boolean configReducePorts) {
        this.configReducePorts = configReducePorts;
    }

    public boolean configReduceBlocks() {
        return this.configReduceBlocks;
    }

    public void setReduceBlocks(boolean configReduceBlocks) {
        this.configReduceBlocks = configReduceBlocks;
    }

    public CHFilterSet getActiveFilters() {
        return this.activeFilters;
    }

    public boolean hasFilters() {
        return this.activeFilters != null;
    }

    public BreadcrumbInput getBreadcrumbInput() {
        return this.breadcrumbInput;
    }

    public void setBreadcrumbInput(BreadcrumbInput breadcrumbInput) {
        this.breadcrumbInput = breadcrumbInput;
    }

    public boolean reducePorts() {
        return this.activeFilters != null ? this.activeFilters.reducePortsWithoutConnections() : this.configReducePorts;
    }

    public boolean reduceBlocks() {
        return this.activeFilters != null ? this.activeFilters.reduceBlocksWithoutPorts() : this.configReduceBlocks;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.activeFilters == null ? 0 : this.activeFilters.hashCode());
        result = 31 * result + (this.configReduceBlocks ? 1231 : 1237);
        result = 31 * result + (this.configReducePorts ? 1231 : 1237);
        result = 31 * result + (this.languageKind == null ? 0 : this.languageKind.hashCode());
        result = 31 * result + (this.breadcrumbInput == null ? 0 : this.breadcrumbInput.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CHConfig other = (CHConfig)obj;
        if (this.breadcrumbInput == null ? other.breadcrumbInput != null : !this.breadcrumbInput.equals(other.breadcrumbInput)) {
            return false;
        }
        if (this.activeFilters == null ? other.activeFilters != null : !this.activeFilters.equals(other.activeFilters)) {
            return false;
        }
        if (this.configReduceBlocks != other.configReduceBlocks) {
            return false;
        }
        if (this.configReducePorts != other.configReducePorts) {
            return false;
        }
        return this.languageKind == other.languageKind;
    }
}

