/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHUVMPort;
import ro.amiq.dvt.diagrams.ch.model.CHUtils;
import ro.amiq.dvt.diagrams.ch.utils.CHColorFilter;
import ro.amiq.dvt.diagrams.ch.utils.CHExcludeFilter;
import ro.amiq.dvt.diagrams.ch.utils.ICHFilter;
import ro.amiq.dvt.diagrams.filters.IDiagramFilter;
import ro.amiq.dvt.diagrams.filters.IDiagramFilterSet;

public class CHFilterSet
implements IDiagramFilterSet {
    private String name;
    private List<ICHFilter> instanceColorFilters;
    private List<ICHFilter> connectionColorFilters;
    private List<ICHFilter> portColorFilters;
    private List<ICHFilter> allFilters;
    private boolean reduceBlocks;
    private boolean reducePorts;

    public CHFilterSet(String name) {
        this.name = name.trim();
    }

    public List<ICHFilter> getFilters() {
        if (this.allFilters == null) {
            return Collections.emptyList();
        }
        return this.allFilters;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean reduceBlocksWithoutPorts() {
        return this.reduceBlocks;
    }

    public void setReduceBlocksWithoutPorts(boolean reduceGates) {
        this.reduceBlocks = reduceGates;
    }

    public boolean reducePortsWithoutConnections() {
        return this.reducePorts;
    }

    public void setReducePortsWithoutConnections(boolean reducePorts) {
        this.reducePorts = reducePorts;
    }

    public ICHFilter getConnectionColoringFilter(CHConnection connection) {
        if (connection == null || this.connectionColorFilters == null) {
            return null;
        }
        String path = CHUtils.getPathForConnection(connection);
        CHPort source = connection.getSource();
        String label = source instanceof CHUVMPort ? ((CHUVMPort)source).getDataType() : "";
        ICHFilter result = null;
        for (ICHFilter filter : this.connectionColorFilters) {
            if (!filter.matches(String.valueOf(path) + label, false)) continue;
            result = filter;
        }
        return result;
    }

    public ICHFilter getPortColoringFilter(CHPort port, LanguageKind lang) {
        if (port == null || this.portColorFilters == null) {
            return null;
        }
        String portPath = CHUtils.getPathForFilters(port);
        String portType = port.getSanitizedType(lang, false);
        ICHFilter result = null;
        for (ICHFilter filter : this.portColorFilters) {
            if ((!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.PORT) || !filter.matches(String.valueOf(portPath) + port.getName(), false)) && (!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.PORT_TYPE) || !filter.matches(String.valueOf(portPath) + portType, false))) continue;
            result = filter;
        }
        return result;
    }

    public ICHFilter getBlockColoringFilter(CHContainer component, LanguageKind lang) {
        if (component == null || this.instanceColorFilters == null) {
            return null;
        }
        String path = CHUtils.getPathForFilters(component);
        String typePath = component.getSanitizedType(lang, false);
        ICHFilter result = null;
        for (ICHFilter filter : this.instanceColorFilters) {
            if ((!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.INSTANCE) || !filter.matches(String.valueOf(path) + component.getName(), false)) && (!filter.getKinds().contains((Object)ICHFilter.CHFilterKind.TYPE) || !filter.matches(String.valueOf(path) + typePath, false))) continue;
            result = filter;
        }
        return result;
    }

    public void addFilter(IDiagramFilter filter) {
        if (!(filter instanceof ICHFilter)) {
            return;
        }
        ICHFilter chFilter = (ICHFilter)filter;
        if (!chFilter.isColorFilter()) {
            if (this.allFilters == null) {
                this.allFilters = new ArrayList<ICHFilter>();
            }
            this.allFilters.add(chFilter);
            return;
        }
        for (ICHFilter.CHFilterKind kind : chFilter.getKinds()) {
            switch (kind) {
                case INSTANCE: 
                case TYPE: {
                    if (this.instanceColorFilters == null) {
                        this.instanceColorFilters = new ArrayList<ICHFilter>();
                    }
                    this.instanceColorFilters.add(chFilter);
                    break;
                }
                case PORT: 
                case PORT_TYPE: {
                    if (this.portColorFilters == null) {
                        this.portColorFilters = new ArrayList<ICHFilter>();
                    }
                    this.portColorFilters.add(chFilter);
                    break;
                }
                case TRANSACTION_TYPE: {
                    if (this.connectionColorFilters == null) {
                        this.connectionColorFilters = new ArrayList<ICHFilter>();
                    }
                    this.connectionColorFilters.add(chFilter);
                }
            }
        }
    }

    public static CHFilterSet deserializeSingleSet(String stringInput, CHFilterSet initialSet) {
        CHFilterSet set;
        if (stringInput == null || stringInput.isEmpty()) {
            return null;
        }
        String[] elements = stringInput.split("\n");
        CHFilterSet cHFilterSet = set = initialSet != null ? initialSet : new CHFilterSet(elements[0].trim());
        if (set.allFilters != null) {
            set.allFilters.clear();
        }
        if (set.instanceColorFilters != null) {
            set.instanceColorFilters.clear();
        }
        if (set.portColorFilters != null) {
            set.portColorFilters.clear();
        }
        if (set.connectionColorFilters != null) {
            set.connectionColorFilters.clear();
        }
        set.reduceBlocks = false;
        set.reducePorts = false;
        if (elements.length == 1) {
            return set;
        }
        int start = 1;
        if ("reducePorts".equals(elements[start])) {
            set.reducePorts = true;
            ++start;
        }
        if (elements.length > start && "reduceBlocks".equals(elements[start])) {
            set.reduceBlocks = true;
            ++start;
        }
        int i = start;
        while (i < elements.length) {
            block43: {
                RGB color;
                boolean isColorFilter;
                boolean include;
                String elementKinds;
                String expression;
                block45: {
                    String lowercaseFilter;
                    String originalFilter;
                    block46: {
                        block44: {
                            if (elements[i].trim().startsWith("#")) break block43;
                            expression = "";
                            elementKinds = "";
                            include = false;
                            isColorFilter = false;
                            color = null;
                            if (!elements[i].toLowerCase().contains("matching")) break block43;
                            originalFilter = elements[i].trim();
                            lowercaseFilter = originalFilter.toLowerCase();
                            if (!lowercaseFilter.startsWith("show")) break block44;
                            include = true;
                            elementKinds = lowercaseFilter.substring(4, lowercaseFilter.indexOf("matching"));
                            expression = originalFilter.substring(lowercaseFilter.indexOf("matching") + 8).trim();
                            break block45;
                        }
                        if (!lowercaseFilter.startsWith("hide")) break block46;
                        elementKinds = lowercaseFilter.substring(4, lowercaseFilter.indexOf("matching"));
                        expression = originalFilter.substring(lowercaseFilter.indexOf("matching") + 8).trim();
                        break block45;
                    }
                    if (!lowercaseFilter.startsWith("color")) break block43;
                    isColorFilter = true;
                    elementKinds = lowercaseFilter.substring(5, lowercaseFilter.indexOf("matching"));
                    expression = originalFilter.substring(lowercaseFilter.indexOf("matching") + 8).trim();
                    if (lowercaseFilter.contains("using")) {
                        expression = originalFilter.substring(lowercaseFilter.indexOf("matching") + 8, lowercaseFilter.indexOf("using")).trim();
                        color = IDiagramFilterSet.getRGB(lowercaseFilter.substring(lowercaseFilter.indexOf("using") + 5).trim(), expression);
                    }
                }
                if (elementKinds.trim().isEmpty() || expression.trim().isEmpty()) break block43;
                String path = "";
                if (expression.contains("/")) {
                    path = expression.substring(0, expression.lastIndexOf("/") + 1);
                    expression = expression.substring(path.length()).trim();
                }
                String[] stringKinds = elementKinds.split(",");
                EnumSet<ICHFilter.CHFilterKind> kinds = EnumSet.noneOf(ICHFilter.CHFilterKind.class);
                String[] stringArray = stringKinds;
                int n = stringKinds.length;
                int n2 = 0;
                while (n2 < n) {
                    block47: {
                        String kind = stringArray[n2];
                        if (kind.trim().isEmpty()) break block47;
                        switch (kind.trim()) {
                            case "port": 
                            case "ports": {
                                kinds.add(ICHFilter.CHFilterKind.PORT);
                                break;
                            }
                            case "port types": 
                            case "port type": {
                                kinds.add(ICHFilter.CHFilterKind.PORT_TYPE);
                                break;
                            }
                            case "transaction type": 
                            case "transaction types": {
                                kinds.add(ICHFilter.CHFilterKind.TRANSACTION_TYPE);
                                break;
                            }
                            case "instances": 
                            case "instance": {
                                kinds.add(ICHFilter.CHFilterKind.INSTANCE);
                                break;
                            }
                            case "type": 
                            case "types": {
                                kinds.add(ICHFilter.CHFilterKind.TYPE);
                            }
                        }
                    }
                    ++n2;
                }
                if (isColorFilter) {
                    set.addFilter(new CHColorFilter(expression, path.replaceAll(" ", ""), kinds, color));
                } else {
                    set.addFilter(new CHExcludeFilter(expression, path.replaceAll(" ", ""), kinds, include));
                }
            }
            ++i;
        }
        return set;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.allFilters == null ? 0 : this.allFilters.hashCode());
        result = 31 * result + (this.instanceColorFilters == null ? 0 : this.instanceColorFilters.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.portColorFilters == null ? 0 : this.portColorFilters.hashCode());
        result = 31 * result + (this.connectionColorFilters == null ? 0 : this.connectionColorFilters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CHFilterSet other = (CHFilterSet)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.allFilters == null ? other.allFilters != null : !this.allFilters.equals(other.allFilters)) {
            return false;
        }
        if (this.instanceColorFilters == null ? other.instanceColorFilters != null : !this.instanceColorFilters.equals(other.instanceColorFilters)) {
            return false;
        }
        if (this.portColorFilters == null ? other.portColorFilters != null : !this.portColorFilters.equals(other.portColorFilters)) {
            return false;
        }
        return !(this.connectionColorFilters == null ? other.connectionColorFilters != null : !this.connectionColorFilters.equals(other.connectionColorFilters));
    }
}

