/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.utils;

import java.util.HashSet;
import java.util.function.Predicate;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.model.CHConnection;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHDesign;
import ro.amiq.dvt.diagrams.ch.model.CHPort;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.model.CHUtils;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;

public enum CHPermanentFilter {
    INSTANCE;

    private static final String UVM_ANALYSIS_IMP = "uvm_analysis_imp";
    private static final String ANALYSIS_EXPORT = "analysis_export";
    private static final String SQR_RSP_ANALYSIS_FIFO = "sqr_rsp_analysis_fifo";
    private static final String UVM_TLM_FIFO = "uvm_tlm_fifo";

    public CHRoot filter(CHRoot root, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        HashSet removeObjects = new HashSet();
        int depth = root.getCustomDepth();
        this.filterRoot(root, depth, container -> {
            String type = container.getSanitizedType(root.getLanguageKind(), true);
            if (UVM_TLM_FIFO.equals(type)) {
                CHPort analysisExport;
                if (SQR_RSP_ANALYSIS_FIFO.equals(container.getName()) && (analysisExport = this.getPort((CHContainer)container, ANALYSIS_EXPORT, UVM_ANALYSIS_IMP, root.getLanguageKind())) != null && analysisExport.getConnections().size() == 1) {
                    CHConnection analysisExportConnection = analysisExport.getConnections().get(0);
                    removeObjects.add(analysisExportConnection);
                    CHPort source = analysisExportConnection.getSource();
                    CHPort destination = analysisExportConnection.getDestination();
                    source.getConnections().remove(analysisExportConnection);
                    destination.getConnections().remove(analysisExportConnection);
                    if (source.getConnections().isEmpty()) {
                        source.setIsVisible(false, true);
                        source.setIsRelevant(false);
                    }
                    if (destination.getConnections().isEmpty()) {
                        destination.setIsVisible(false, true);
                        destination.setIsRelevant(false);
                    }
                }
                CHUtils.reduceUnconnectedPorts(container);
                if (!CHUtils.hasVisiblePorts(container)) {
                    removeObjects.add(container);
                }
            }
            return false;
        }, null, null, monitor);
        this.filterRoot(root, depth, container -> removeObjects.contains(container), port -> removeObjects.contains(port), connection -> removeObjects.contains(connection), monitor);
        if (!CHUtils.hasVisibleChildren(root.getDesign()) && !CHUtils.hasVisiblePorts(root.getDesign())) {
            root.setDesign(null);
        }
        return root;
    }

    private void filterRoot(CHRoot root, int depth, Predicate<CHContainer> containerFilter, Predicate<CHPort> portFilter, Predicate<CHConnection> connectionFilter, DProgressMonitor monitor) throws DCanceledException {
        CHDesign design;
        CHUVMComponent uvmComponent = root.getUVMComponent();
        if (uvmComponent != null) {
            this.filterContainer(uvmComponent, depth, containerFilter, portFilter, connectionFilter, monitor);
        }
        if ((design = root.getDesign()) != null) {
            this.filterContainer(design, depth, containerFilter, portFilter, connectionFilter, monitor);
        }
    }

    private boolean filterContainer(CHContainer container, int depth, Predicate<CHContainer> containerFilter, Predicate<CHPort> portFilter, Predicate<CHConnection> connectionFilter, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        for (CHPort port : container.getPorts()) {
            if (!this.filterPort(port, depth, portFilter, connectionFilter)) continue;
            port.setIsVisible(false, true);
            port.setIsRelevant(false);
        }
        for (CHContainer chContainer : container.getChildren()) {
            if (!this.filterContainer(chContainer, depth, containerFilter, portFilter, connectionFilter, monitor)) continue;
            chContainer.setIsVisible(false, true);
            chContainer.setIsRelevant(false);
        }
        if (containerFilter != null) {
            return containerFilter.test(container);
        }
        return false;
    }

    private boolean filterPort(CHPort port, int depth, Predicate<CHPort> portFilter, Predicate<CHConnection> connectionFilter) {
        if (connectionFilter != null) {
            for (CHConnection connection : port.getConnections()) {
                CHPort source = connection.getSource();
                CHPort destination = connection.getDestination();
                if (source == null || destination == null) continue;
                CHContainer sourceContainer = source.getParent();
                CHContainer destinationContainer = destination.getParent();
                if (sourceContainer != null && destinationContainer != null && sourceContainer.getDepth() <= depth && destinationContainer.getDepth() <= depth && sourceContainer.isVisible() && destinationContainer.isVisible() && !connectionFilter.test(connection)) continue;
                connection.setIsVisible(false);
            }
        }
        if (portFilter != null) {
            return portFilter.test(port);
        }
        return false;
    }

    private CHPort getPort(CHContainer container, String name, String type, LanguageKind language) {
        return container.getPorts().stream().filter(port -> port.getName().equals(name) && port.getSanitizedType(language, true).equals(type)).findFirst().orElse(null);
    }
}

