/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.ch.utils;

import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.diagrams.filters.IDiagramFilter;

public interface ICHFilter
extends IDiagramFilter {
    default public boolean matchesPath(String path) {
        Pattern pattern = this.getPathPattern();
        return path.isEmpty() || pattern == null || pattern.matcher(path).matches();
    }

    default public boolean matches(String name, boolean checkIncluded) {
        Pattern pathPattern;
        if (name == null || name.isEmpty() || !this.isColor() && checkIncluded && !this.isShow()) {
            return false;
        }
        String path = "";
        if (name.contains("/")) {
            path = name.substring(0, name.lastIndexOf(47) + 1);
        }
        name = name.substring(name.lastIndexOf(47) + 1);
        if (!(this.getPath().isEmpty() || (pathPattern = this.getPathPattern()) == null || !path.isEmpty() && pathPattern.matcher(path).matches())) {
            return false;
        }
        Pattern pattern = this.getPattern();
        return name != null && !name.isEmpty() && (this.getText().equals(".*") || pattern != null && pattern.matcher(name).matches());
    }

    public Set<CHFilterKind> getKinds();

    public Pattern getPattern();

    public Pattern getPathPattern();

    public static enum CHFilterKind {
        INSTANCE,
        TYPE,
        TRANSACTION_TYPE,
        PORT,
        PORT_TYPE;

    }
}

