/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DGenerator;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.diagrams.design.DDesignPhases;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignScene;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.power.format.DVTPFModel;

public class DPFDiagram
implements DDiagram {
    private IProject project;
    private NLConfig config;
    private Set<String> selectedPDs;
    private static final DGenerator.Builder<DPFDiagram, DDesignScene> SCENE_GENERATOR = DGenerator.Builder.input(DPFDiagram.class).phase(DDesignPhases::createPFKNode).phase(DPhases::layoutKNode).phase(DDesignPhases::createDesignScene);

    public DPFDiagram(IProject project, NLConfig config, Set<String> selectedPDs) {
        this.project = project;
        this.config = config;
        this.selectedPDs = selectedPDs;
    }

    @Override
    public DGenerator<? extends DDiagram, ? extends DObject> getSceneGenerator() {
        return SCENE_GENERATOR.build(this);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public DVTPFModel getPFModel() {
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.getProject(), false);
        if (mixedLangProject == null) {
            return null;
        }
        return mixedLangProject.getPFModel();
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getName() {
        return "Supply Network of " + this.project.getName();
    }

    public NLConfig getConfig() {
        return this.config;
    }

    public Set<String> getSelectedPDs() {
        return this.selectedPDs;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        result = 31 * result + (this.selectedPDs == null ? 0 : this.selectedPDs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DPFDiagram other = (DPFDiagram)obj;
        if (this.project == null ? other.project != null : !this.project.equals((Object)other.project)) {
            return false;
        }
        return !(this.selectedPDs == null ? other.selectedPDs != null : !this.selectedPDs.equals(other.selectedPDs));
    }
}

