/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTRefactorConnectWizardInput;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DGenerator;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.diagrams.design.DDesignPhases;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignScene;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.designelement.RefactorDesignElementOperation;

public class DRefactoringConnectDiagram
implements DDiagram {
    private static final String ROOT_NAME = "root";
    private static final String REFACTORING_CONNECT_DIAGRAM_NAME = "Refactoring Connect";
    private IProject project;
    private NLConfig config;
    private Set<RefactorInputWrapper> inputWrappers;
    private RefactorInputWrapper fTopWrapper;
    private LinkedHashSet<RefactorInputWrapper> fResult;
    private String[] srcPath;
    private String[] dstPath;
    private String[] rootPath;
    private IRfNamedElement srcPort;
    private IRfNamedElement dstPort;
    private DVTRefactorConnectWizardInput info;
    private int fTopIndex;
    private boolean hideSideEffects;
    private static final DGenerator.Builder<DRefactoringConnectDiagram, DDesignScene> SCENE_GENERATOR = DGenerator.Builder.input(DRefactoringConnectDiagram.class).phase(DDesignPhases::createRefactoringConnectKNode).phase(DPhases::layoutKNode).phase(DDesignPhases::createDesignScene);

    public DRefactoringConnectDiagram(IProject project, NLConfig config, Set<RefactorInputWrapper> input, DVTRefactorConnectWizardInput info, String[] srcPath, String[] dstPath, IRfNamedElement srcPort, IRfNamedElement dstPort, String[] rootNode, boolean hideSideEffects) {
        this.project = project;
        this.config = config;
        this.inputWrappers = input;
        this.info = info;
        this.srcPath = srcPath;
        this.dstPath = dstPath;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
        this.rootPath = rootNode;
        this.hideSideEffects = hideSideEffects;
    }

    @Override
    public DGenerator<? extends DDiagram, ? extends DObject> getSceneGenerator() {
        return SCENE_GENERATOR.build(this);
    }

    public NLConfig getConfig() {
        return this.config;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public String getTitle() {
        return REFACTORING_CONNECT_DIAGRAM_NAME;
    }

    @Override
    public String getName() {
        return REFACTORING_CONNECT_DIAGRAM_NAME;
    }

    public Set<RefactorInputWrapper> getResult() {
        return this.fResult;
    }

    public void computeTopElement() {
        RefactorInputWrapper topWrapper = null;
        for (RefactorInputWrapper wrapper : this.fResult) {
            if (topWrapper == null) {
                topWrapper = wrapper;
                continue;
            }
            String[] currentInfoInstancePath = wrapper.getPath();
            String[] topInfoInstancePath = topWrapper.getPath();
            ArrayList<String> workingInstancePath = new ArrayList<String>();
            if (currentInfoInstancePath == null || topInfoInstancePath == null) continue;
            int i = 0;
            while (i < Integer.min(currentInfoInstancePath.length, topInfoInstancePath.length)) {
                String currentDesignInstance = currentInfoInstancePath[i];
                String topDesignInstance = topInfoInstancePath[i];
                if (currentDesignInstance != null && topDesignInstance != null) {
                    if (currentDesignInstance.equals(topDesignInstance)) {
                        workingInstancePath.add(currentDesignInstance);
                    } else if (!workingInstancePath.isEmpty()) {
                        topWrapper = new RefactorInputWrapper(wrapper.getRefactorOperation(), null, workingInstancePath.toArray(new String[0]), wrapper.isOutput(), wrapper.getNewElementName(), wrapper.getDirection(), wrapper.getType(), wrapper.getConnectionExpression(), wrapper.getWidth(), wrapper.getGenericDefaultValue(), wrapper.isInsideBlock(), wrapper.isInitialGate());
                    }
                }
                ++i;
            }
            if (workingInstancePath.size() != wrapper.getPath().length) continue;
            topWrapper = wrapper;
        }
        if (topWrapper == null) {
            String[] rootString = new String[]{ROOT_NAME};
            topWrapper = new RefactorInputWrapper(RefactorDesignElementOperation.ADD_WIRE, null, rootString, false, "", "", "", "", "", "", false, false);
        }
        this.fTopWrapper = topWrapper;
        if (topWrapper != null && topWrapper.getPath() != null) {
            this.fTopIndex = topWrapper.getPath().length;
        }
    }

    public RefactorInputWrapper getTopWrapper() {
        return this.fTopWrapper;
    }

    public int getTopIndex() {
        return this.fTopIndex;
    }

    public DVTRefactorConnectWizardInput getInfo() {
        return this.info;
    }

    public void addSideEffects() {
        this.fResult = new LinkedHashSet();
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.project);
        if (memory == null) {
            return;
        }
        if (this.inputWrappers == null || this.inputWrappers.isEmpty()) {
            return;
        }
        for (RefactorInputWrapper wrapper : this.inputWrappers) {
            IRfNamedElement targetElement = wrapper.getTargetElement();
            if (!(targetElement instanceof IRfInstanceElement)) {
                boolean isInitialGate = Arrays.equals(this.srcPath, wrapper.getPath()) || Arrays.equals(this.dstPath, wrapper.getPath());
                String[] newName = DRefactoringConnectDiagram.appendAtiBeginning(wrapper.getPath(), ROOT_NAME);
                RefactorInputWrapper currentWrapper = new RefactorInputWrapper(wrapper.getRefactorOperation(), wrapper.getTargetElement(), newName, wrapper.isOutput(), wrapper.getNewElementName(), wrapper.getDirection(), wrapper.getType(), wrapper.getConnectionExpression(), wrapper.getWidth(), wrapper.getGenericDefaultValue(), wrapper.isInsideBlock(), isInitialGate);
                if (DVTRefactorDesignElementUtils.isSideEffect(wrapper.getPath(), this.srcPath, this.dstPath)) {
                    currentWrapper.setIsSideEffect();
                }
                this.fResult.add(currentWrapper);
                continue;
            }
            List<ELInstance> instancesFor = memory.getInstancesFor((IRfInstanceElement)targetElement, Integer.MAX_VALUE);
            if (instancesFor == null || instancesFor.isEmpty()) continue;
            for (ELInstance instanceFor : instancesFor) {
                ElementPath hierarchyPath = instanceFor.getHierarchyPath();
                Object[] segments = hierarchyPath.getSegments();
                boolean isInitialGate = Arrays.equals(this.srcPath, segments) || Arrays.equals(this.dstPath, segments);
                String[] newName = DRefactoringConnectDiagram.appendAtiBeginning((String[])segments, ROOT_NAME);
                RefactorInputWrapper currentWrapper = new RefactorInputWrapper(wrapper.getRefactorOperation(), wrapper.getTargetElement(), newName, wrapper.isOutput(), wrapper.getNewElementName(), wrapper.getDirection(), wrapper.getType(), wrapper.getConnectionExpression(), wrapper.getWidth(), wrapper.getGenericDefaultValue(), wrapper.isInsideBlock(), isInitialGate);
                if (DVTRefactorDesignElementUtils.isSideEffect((String[])segments, this.srcPath, this.dstPath)) {
                    currentWrapper.setIsSideEffect();
                }
                if (this.hideSideEffects && currentWrapper.isSideEffect()) continue;
                this.fResult.add(currentWrapper);
            }
        }
        ArrayList<RefactorInputWrapper> listInput = new ArrayList<RefactorInputWrapper>(this.fResult);
        Collections.sort(listInput, (o1, o2) -> {
            if (o1.isSideEffect() == o2.isSideEffect() && o1.getPath() != null && o2.getPath() != null) {
                return o1.getPath().length - o2.getPath().length;
            }
            if (o1.isSideEffect()) {
                return 1;
            }
            if (o2.isSideEffect()) {
                return -1;
            }
            return 0;
        });
        this.fResult = new LinkedHashSet<RefactorInputWrapper>(listInput);
    }

    private static String[] appendAtiBeginning(String[] elements, String element) {
        String[] temp = new String[elements.length + 1];
        temp[0] = element;
        System.arraycopy(elements, 0, temp, 1, elements.length);
        return temp;
    }

    public String[] getDstPath() {
        return this.dstPath;
    }

    public String[] getSrcPath() {
        return this.srcPath;
    }

    public IRfNamedElement getSrcPort() {
        return this.srcPort;
    }

    public IRfNamedElement getDstPort() {
        return this.dstPort;
    }

    public String[] getRootPath() {
        return this.rootPath;
    }
}

