/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DGenerator;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.diagrams.design.DDesignPhases;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.design.DDesignScene;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.refactor.rename.PreviewDiagramInfo;
import ro.amiq.dvt.ui.refactor.rename.PreviewDiagramInstanceInfo;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyUserSettings;
import ro.amiq.dvt.ui.refactor.rename.RenameConflictType;

public class DRefactoringDiagram
implements DDiagram {
    private IProject project;
    private PreviewDiagramInfo previewDiagramInfo;
    private List<PreviewDiagramInstanceInfo> fullDiagramInfo;
    private NLConfig config;
    private PreviewDiagramInstanceInfo topElement;
    private int breadcrumbStartIndex;
    private RenameAcrossHierarchyUserSettings userSettings;
    private RfDummyElement rootElement;
    private static final DGenerator.Builder<DRefactoringDiagram, DDesignScene> SCENE_GENERATOR = DGenerator.Builder.input(DRefactoringDiagram.class).phase(DDesignPhases::createRefactoringKNode).phase(DPhases::layoutKNode).phase(DDesignPhases::createDesignScene);

    public DRefactoringDiagram(IProject project, NLConfig config, PreviewDiagramInfo refactoringInfo) {
        this.project = project;
        this.previewDiagramInfo = refactoringInfo;
        this.config = config;
        this.fullDiagramInfo = new ArrayList<PreviewDiagramInstanceInfo>();
    }

    @Override
    public DGenerator<? extends DDiagram, ? extends DObject> getSceneGenerator() {
        return SCENE_GENERATOR.build(this);
    }

    public NLConfig getConfig() {
        return this.config;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getName() {
        return "Refactoring of " + this.previewDiagramInfo.getRenamedPortOrSignal().getName() + " to " + this.previewDiagramInfo.getNewName();
    }

    public PreviewDiagramInstanceInfo getTopElement() {
        return this.topElement;
    }

    public int getBreadcrumbStartIndex() {
        return this.breadcrumbStartIndex;
    }

    public List<PreviewDiagramInstanceInfo> getFullDiagramInfo() {
        return this.fullDiagramInfo;
    }

    public String getNewName() {
        return this.previewDiagramInfo.getNewName();
    }

    public void setUserSettings(RenameAcrossHierarchyUserSettings renameAcrossHierarchyUserSettings) {
        this.userSettings = renameAcrossHierarchyUserSettings;
    }

    public RenameAcrossHierarchyUserSettings getUserSettings() {
        return this.userSettings;
    }

    public void addSideEffects() {
        try {
            HashMap instanceToDesignPaths = new HashMap();
            Map<IRfNamedElement, PreviewDiagramInstanceInfo> refactoringElements = this.previewDiagramInfo.getPreviewDiagramInstanceInfos();
            if (refactoringElements == null || refactoringElements.isEmpty()) {
                return;
            }
            List<IRfNamedElement> initialDesignInstance = this.previewDiagramInfo.getInitialDesignInstance();
            if (initialDesignInstance == null || initialDesignInstance.isEmpty()) {
                return;
            }
            IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(this.project);
            for (Map.Entry<IRfNamedElement, PreviewDiagramInstanceInfo> entry : refactoringElements.entrySet()) {
                List<ElementPath> instancePaths;
                IRfNamedElement instance = entry.getKey();
                if (instance == null) continue;
                IRfDesignElement designElement = null;
                PreviewDiagramInstanceInfo originalPreviewInfo = entry.getValue();
                if (instance instanceof IRfDesignElement) {
                    designElement = (IRfDesignElement)instance;
                } else {
                    if (!(instance instanceof IRfInstanceElement)) continue;
                    IRfNamedElement assocType = ((IRfInstanceElement)instance).getAssociatedType();
                    if (assocType instanceof IRfEntityComplement) {
                        assocType = ((IRfEntityComplement)((Object)assocType)).getEntity();
                    }
                    if (!(assocType instanceof IRfDesignElement)) continue;
                    designElement = (IRfDesignElement)assocType;
                }
                List designPaths = (List)instanceToDesignPaths.get(instance);
                if (designPaths != null) {
                    for (List designPath : designPaths) {
                        designPath.add(0, this.getRootElement());
                        this.addRefactoringElement(designPath, originalPreviewInfo, initialDesignInstance);
                    }
                    continue;
                }
                if (elMemory == null || (instancePaths = elMemory.getInstancePathsFor(designElement, Integer.MAX_VALUE)) == null || instancePaths.isEmpty()) continue;
                for (ElementPath path : instancePaths) {
                    List<IRfNamedElement> designSegments = DesignPathManager.getInstance().getDesignSegmentsFromElementPath(this.project, path);
                    if (designSegments == null || designSegments.isEmpty()) continue;
                    IRfNamedElement leaf = designSegments.get(designSegments.size() - 1);
                    if (refactoringElements.containsKey(leaf) && !leaf.equals(instance)) {
                        ArrayList<List<IRfNamedElement>> computedDesignPaths = (ArrayList<List<IRfNamedElement>>)instanceToDesignPaths.get(leaf);
                        if (computedDesignPaths == null) {
                            computedDesignPaths = new ArrayList<List<IRfNamedElement>>();
                        }
                        if (computedDesignPaths.contains(designSegments)) continue;
                        computedDesignPaths.add(designSegments);
                        instanceToDesignPaths.put(leaf, computedDesignPaths);
                        continue;
                    }
                    designSegments.add(0, this.getRootElement());
                    this.addRefactoringElement(designSegments, originalPreviewInfo, initialDesignInstance);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (TestHelper.isTestMode()) {
            this.fullDiagramInfo.sort(new Comparator<PreviewDiagramInstanceInfo>(){

                @Override
                public int compare(PreviewDiagramInstanceInfo o1, PreviewDiagramInstanceInfo o2) {
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    List<IRfNamedElement> instancePath1 = o1.getInstancePath();
                    List<IRfNamedElement> instancePath2 = o2.getInstancePath();
                    if (instancePath1 == null) {
                        return 1;
                    }
                    if (instancePath2 == null) {
                        return -1;
                    }
                    int iterationLength = Integer.min(instancePath1.size(), instancePath2.size());
                    int i = 0;
                    while (i < iterationLength) {
                        IRfNamedElement namedElement1 = instancePath1.get(i);
                        IRfNamedElement namedElement2 = instancePath2.get(i);
                        if (namedElement1 == null) {
                            return 1;
                        }
                        if (namedElement2 == null) {
                            return -1;
                        }
                        if (namedElement1.getName() == null) {
                            return 1;
                        }
                        if (namedElement2.getName() == null) {
                            return -1;
                        }
                        int result = namedElement1.getName().compareTo(namedElement2.getName());
                        if (result != 0) {
                            return result;
                        }
                        ++i;
                    }
                    if (iterationLength == instancePath1.size()) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
    }

    private void addRefactoringElement(List<IRfNamedElement> instancePath, PreviewDiagramInstanceInfo originalPreviewInfo, List<IRfNamedElement> initialDesignInstance) {
        IRfNamedElement segmentTop = instancePath.get(0);
        IRfNamedElement designInstanceTop = initialDesignInstance.get(0);
        if (designInstanceTop instanceof DummyInstance) {
            designInstanceTop = ((DummyInstance)designInstanceTop).design;
        }
        if (segmentTop instanceof DummyInstance) {
            segmentTop = ((DummyInstance)segmentTop).design;
        }
        ArrayList<IRfNamedElement> initialDesignInstanceWithRoot = new ArrayList<IRfNamedElement>(initialDesignInstance);
        initialDesignInstanceWithRoot.add(0, this.getRootElement());
        int designInstanceCommonSegmentsLength = this.getDesignInstanceCommonSegmentsLength(initialDesignInstanceWithRoot, instancePath);
        int initialPathSize = instancePath.size();
        boolean isSideEffect = designInstanceCommonSegmentsLength != Integer.min(initialDesignInstanceWithRoot.size(), initialPathSize);
        Iterator<IRfNamedElement> it = instancePath.iterator();
        while (it.hasNext()) {
            IRfNamedElement namedElement = it.next();
            if (!DesignUtils.isBlock(namedElement)) continue;
            it.remove();
        }
        PreviewDiagramInstanceInfo previewDiagramInfo = new PreviewDiagramInstanceInfo(originalPreviewInfo, instancePath, isSideEffect);
        if (designInstanceCommonSegmentsLength == initialPathSize && designInstanceCommonSegmentsLength == initialDesignInstanceWithRoot.size()) {
            previewDiagramInfo.setInitialElement();
        }
        this.fullDiagramInfo.add(previewDiagramInfo);
    }

    private int getDesignInstanceCommonSegmentsLength(List<IRfNamedElement> initialDesignPath, List<IRfNamedElement> designPath) {
        try {
            int minLength = Integer.min(initialDesignPath.size(), designPath.size());
            int i = 0;
            while (i < minLength) {
                if (!initialDesignPath.get(i).equals(designPath.get(i))) {
                    return i;
                }
                ++i;
            }
            return minLength;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return 0;
        }
    }

    public void computeTopElement() {
        try {
            if (this.fullDiagramInfo == null) {
                return;
            }
            for (PreviewDiagramInstanceInfo diagramInstanceInfo : this.fullDiagramInfo) {
                if (this.topElement == null) {
                    this.topElement = diagramInstanceInfo;
                    continue;
                }
                List<IRfNamedElement> currentInfoInstancePath = diagramInstanceInfo.getInstancePath();
                List<IRfNamedElement> topInstancePath = this.topElement.getInstancePath();
                ArrayList<IRfNamedElement> workingInstancePath = new ArrayList<IRfNamedElement>();
                if (currentInfoInstancePath == null || topInstancePath == null) continue;
                int i = 0;
                while (i < Integer.min(currentInfoInstancePath.size(), topInstancePath.size())) {
                    IRfNamedElement currentDesignInstance = currentInfoInstancePath.get(i);
                    IRfNamedElement topDesignInstance = topInstancePath.get(i);
                    if (currentDesignInstance != null && topDesignInstance != null) {
                        if (currentDesignInstance.equals(topDesignInstance)) {
                            workingInstancePath.add(currentDesignInstance);
                        } else if (!workingInstancePath.isEmpty()) {
                            this.topElement = new PreviewDiagramInstanceInfo((IRfNamedElement)workingInstancePath.get(workingInstancePath.size() - 1), false, RenameConflictType.NO_CONFLICT, false);
                            this.topElement.setInstancePath(workingInstancePath);
                        }
                    }
                    ++i;
                }
                if (workingInstancePath.size() != diagramInstanceInfo.getInstancePath().size()) continue;
                this.topElement = diagramInstanceInfo;
            }
            if (this.topElement == null) {
                IRfNamedElement modifiedPortOrSignal = this.previewDiagramInfo.getRenamedPortOrSignal();
                this.topElement = new PreviewDiagramInstanceInfo(modifiedPortOrSignal, true, RenameConflictType.NO_CONFLICT, true);
                ArrayList<IRfNamedElement> instancePath = new ArrayList<IRfNamedElement>(this.previewDiagramInfo.getInitialDesignInstance());
                instancePath.add(0, this.getRootElement());
                this.topElement.setInstancePath(instancePath);
                this.topElement.addPort(modifiedPortOrSignal, false);
            }
            this.breadcrumbStartIndex = this.topElement.getInstancePath() != null ? this.topElement.getInstancePath().size() : 0;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IRfNamedElement getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = new RfDummyElement("");
        }
        return this.rootElement;
    }
}

