/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.design;

import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.ElaborationControl;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.diagrams.DNamedElementDiagram;
import ro.amiq.dvt.diagrams.netlist.DMemoryAccessor;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;

public abstract class DTopPathDiagram
extends DNamedElementDiagram {
    private final NLConfig config;
    private final ElementPath topPath;
    private final boolean onlyShallowElaboration;

    protected DTopPathDiagram(IRfNamedElement namedElement, String namePrefix, NLConfig config, ElementPath topPath, boolean generateShallowIfNotElaborated) {
        super(namedElement, namePrefix, topPath);
        this.config = config;
        this.topPath = topPath == null ? null : topPath.toElaborationForm();
        this.fullName = this.makeFullName(this.fullName, namePrefix, namedElement, topPath);
        this.onlyShallowElaboration = generateShallowIfNotElaborated && namedElement instanceof IRfDesignElement && ((IRfDesignElement)namedElement).getSemanticEnableRaw() < 3;
    }

    protected String makeFullName(String fullName, String namePrefix, IRfNamedElement namedElement, ElementPath topPath) {
        if (namedElement instanceof IRfInstanceElement) {
            IRfNamedElement design;
            RfElementPath designElementPath;
            IELMemory memory;
            StringBuilder sb = new StringBuilder().append(namePrefix);
            String firstPart = NLUtils.getNLLabel(topPath != null ? topPath.toString(".") : namedElement.getName());
            sb.append(firstPart);
            Object element = namedElement;
            IRfSingleLangProject rfProject = namedElement.getRfProject();
            if (rfProject != null && (memory = RfMixedLangManager.getInstance().getELMemory(rfProject.getProject())) != null) {
                element = memory.instanceFor(topPath);
            }
            RfElementPath rfElementPath = designElementPath = (design = NLUtils.getNLDesign(element)) != null ? RfElementPath.path(design) : null;
            if (designElementPath != null) {
                sb.append(" (").append(designElementPath.toNiceString()).append(")");
            }
            return sb.toString();
        }
        return fullName;
    }

    public NLConfig getConfig() {
        return this.config;
    }

    public ElementPath getTopPath() {
        return this.topPath;
    }

    public DMemoryAccessor getMemoryAccessor(int depth, IProgressMonitor monitor) {
        IRfNamedElement namedElement = this.getNamedElement();
        IELMemory elMemory = null;
        elMemory = this.onlyShallowElaboration ? DTopPathDiagram.elaborateLocal((IRfDesignElement)namedElement, depth, this.getProject(), monitor) : RfMixedLangManager.getInstance().getELMemory(this.getProject());
        return new DMemoryAccessor(elMemory);
    }

    private static IELMemory elaborateLocal(IRfDesignElement design, int depth, IProject project, IProgressMonitor monitor) {
        if (design == null || project == null) {
            return null;
        }
        int loopBlockCutoff = BuildConfigManager.getElaborationLoopBlockCutoff(project);
        int loopStatementCutoff = BuildConfigManager.getElaborationLoopStatementCutoff(project);
        EnumSet<ElaborationControl> elabControlSet = BuildConfigManager.getElaborationControl(project);
        ELManagerConfiguration config = ELManagerConfiguration.newElabLocalConfig(project, depth, (byte)0, false, loopBlockCutoff, loopStatementCutoff, false, elabControlSet);
        return design.elaborateLocal(ELBuildPhase.NONE, config, new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class), monitor);
    }

    @Override
    public IRfNamedElement getNamedElement() {
        if (this.topPath == null) {
            return super.getNamedElement();
        }
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(this.project);
        if (elManager == null) {
            return super.getNamedElement();
        }
        ELInstance instanceFor = elManager.getMemory().instanceFor(this.topPath);
        if (instanceFor == null) {
            return super.getNamedElement();
        }
        IRfInstanceElement description = instanceFor.getDescription();
        if (description == null) {
            return super.getNamedElement();
        }
        return description;
    }

    public boolean isOnlyShallowElaboration() {
        return this.onlyShallowElaboration;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.topPath == null ? 0 : this.topPath.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DTopPathDiagram other = (DTopPathDiagram)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        return !(this.topPath == null ? other.topPath != null : !this.topPath.equals(other.topPath));
    }
}

